/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.amendrenew;

import java.sql.Date;
import java.util.ArrayList;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewModule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.protocol.location.ProtocolLocationService;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.reference.ProtocolReference;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReview;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class ProtocolMergeTest
extends KcUnitTestBase {
    private static final long DAY = 86400000L;
    private static final String TITLE = "Amendment Title";
    private static final String PROTOCOL_TYPE_CODE = "1";
    private static final String DESCRIPTION = "amendment description";
    private static final Date INITIAL_SUBMISSION_DATE = new Date(System.currentTimeMillis() - 172800000L);
    private static final Date APPROVAL_DATE = new Date(System.currentTimeMillis() - 86400000L);
    private static final Date EXPIRATION_DATE = new Date(System.currentTimeMillis() + 172800000L);
    private static final Date LAST_APPROVAL_DATE = new Date(System.currentTimeMillis());
    private static final String FDA_NUM = "777";
    private static final String REF1 = "amendment ref 1";
    private static final String REF2 = "amendment ref 2";
    private static final String UNIT_FUNDING_SOURCE = "2";
    private static final String OTHER_FUNDING_SOURCE = "3";
    private static final String RESEARCH_AREA_1 = "47.0699";
    private static final String RESEARCH_AREA_2 = "41.0699";
    private static final String PARTICIPANT_TYPE_1 = "1";
    private static final String PARTICIPANT_TYPE_2 = "2";
    private static final String REF_KEY_1 = "1";
    private static final String REF_KEY_2 = "2";
    private static final Integer ROLODEX_ID_1 = 3;
    private static final Integer ROLODEX_ID_2 = 5;
    private static final String NAME_1 = "Donald";
    private static final String NAME_2 = "Molly";
    private static final String SPECIAL_REVIEW_CODE_1 = "2";
    private static final String SPECIAL_REVIEW_CODE_2 = "9";
    private static final String DESCRIPTION_1 = "another description 1";
    private static final String DESCRIPTION_2 = "another description 2";

    @Test
    public void testGeneralInfoMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("001");
        amendment.setTitle(TITLE);
        amendment.setProtocolTypeCode("1");
        amendment.setDescription(DESCRIPTION);
        amendment.setInitialSubmissionDate(INITIAL_SUBMISSION_DATE);
        amendment.setApprovalDate(APPROVAL_DATE);
        amendment.setExpirationDate(EXPIRATION_DATE);
        amendment.setLastApprovalDate(LAST_APPROVAL_DATE);
        amendment.setFdaApplicationNumber(FDA_NUM);
        amendment.setReferenceNumber1(REF1);
        amendment.setReferenceNumber2(REF2);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((Object)TITLE, (Object)protocol.getTitle());
        ProtocolMergeTest.assertEquals((Object)"1", (Object)protocol.getProtocolTypeCode());
        ProtocolMergeTest.assertEquals((Object)DESCRIPTION, (Object)protocol.getDescription());
        ProtocolMergeTest.assertEquals((Object)INITIAL_SUBMISSION_DATE, (Object)protocol.getInitialSubmissionDate());
        ProtocolMergeTest.assertEquals((Object)APPROVAL_DATE, (Object)protocol.getApprovalDate());
        ProtocolMergeTest.assertEquals((Object)EXPIRATION_DATE, (Object)protocol.getExpirationDate());
        ProtocolMergeTest.assertEquals((Object)LAST_APPROVAL_DATE, (Object)protocol.getLastApprovalDate());
        ProtocolMergeTest.assertEquals((Object)FDA_NUM, (Object)protocol.getFdaApplicationNumber());
        ProtocolMergeTest.assertEquals((Object)REF1, (Object)protocol.getReferenceNumber1());
        ProtocolMergeTest.assertEquals((Object)REF2, (Object)protocol.getReferenceNumber2());
    }

    @Test
    public void testFundingSourceMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("024");
        ProtocolFundingSource fundingSource = this.createFundingSource("2");
        amendment.getProtocolFundingSources().add(fundingSource);
        fundingSource = this.createFundingSource(OTHER_FUNDING_SOURCE);
        amendment.getProtocolFundingSources().add(fundingSource);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getProtocolFundingSources().size());
        ProtocolMergeTest.assertEquals((Object)"2", (Object)((ProtocolFundingSourceBase)protocol.getProtocolFundingSources().get(0)).getFundingSourceTypeCode());
        ProtocolMergeTest.assertEquals((Object)OTHER_FUNDING_SOURCE, (Object)((ProtocolFundingSourceBase)protocol.getProtocolFundingSources().get(1)).getFundingSourceTypeCode());
    }

    private ProtocolFundingSource createFundingSource(String fundingSourceType) {
        ProtocolFundingSource fundingSource = new ProtocolFundingSource();
        fundingSource.setFundingSourceTypeCode(fundingSourceType);
        return fundingSource;
    }

    @Test
    public void testResearchAreaMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("004");
        ProtocolResearchArea ra = this.createResearchArea(RESEARCH_AREA_1);
        amendment.getProtocolResearchAreas().add(ra);
        ra = this.createResearchArea(RESEARCH_AREA_2);
        amendment.getProtocolResearchAreas().add(ra);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getProtocolResearchAreas().size());
        ProtocolMergeTest.assertEquals((Object)RESEARCH_AREA_1, (Object)((ProtocolResearchAreaBase)protocol.getProtocolResearchAreas().get(0)).getResearchAreaCode());
        ProtocolMergeTest.assertEquals((Object)RESEARCH_AREA_2, (Object)((ProtocolResearchAreaBase)protocol.getProtocolResearchAreas().get(1)).getResearchAreaCode());
    }

    private ProtocolResearchArea createResearchArea(String researchAreaCode) {
        ProtocolResearchArea ra = new ProtocolResearchArea();
        ra.setResearchAreaCode(researchAreaCode);
        return ra;
    }

    @Test
    public void testSubjectsMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("006");
        ProtocolParticipant subject = this.createParticipant("1");
        amendment.getProtocolParticipants().add(subject);
        subject = this.createParticipant("2");
        amendment.getProtocolParticipants().add(subject);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getProtocolParticipants().size());
        ProtocolMergeTest.assertEquals((Object)"1", (Object)((ProtocolParticipant)protocol.getProtocolParticipants().get(0)).getParticipantTypeCode());
        ProtocolMergeTest.assertEquals((Object)"2", (Object)((ProtocolParticipant)protocol.getProtocolParticipants().get(1)).getParticipantTypeCode());
    }

    private ProtocolParticipant createParticipant(String typeCode) {
        ProtocolParticipant pp = new ProtocolParticipant();
        pp.setParticipantTypeCode(typeCode);
        return pp;
    }

    @Test
    public void testReferencesMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("016");
        ProtocolReference ref = this.createReference("1");
        amendment.getProtocolReferences().add(ref);
        ref = this.createReference("2");
        amendment.getProtocolReferences().add(ref);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getProtocolReferences().size());
        ProtocolMergeTest.assertEquals((Object)"1", (Object)((ProtocolReferenceBase)protocol.getProtocolReferences().get(0)).getReferenceKey());
        ProtocolMergeTest.assertEquals((Object)"2", (Object)((ProtocolReferenceBase)protocol.getProtocolReferences().get(1)).getReferenceKey());
    }

    private ProtocolReference createReference(String refKey) {
        ProtocolReference ref = new ProtocolReference();
        ref.setReferenceKey(refKey);
        return ref;
    }

    @Test
    public void testOrganizationsMerge() {
        Protocol protocol = this.createProtocol();
        ((ProtocolLocationService)KraServiceLocator.getService(ProtocolLocationService.class)).addDefaultProtocolLocation((ProtocolBase)protocol);
        Protocol amendment = this.createAmendment("017");
        ProtocolLocation loc = this.createLocation(ROLODEX_ID_1);
        amendment.getProtocolLocations().add(loc);
        loc = this.createLocation(ROLODEX_ID_2);
        amendment.getProtocolLocations().add(loc);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)3L, (long)protocol.getProtocolLocations().size());
        ProtocolMergeTest.assertEquals((Object)ROLODEX_ID_1, (Object)((ProtocolLocationBase)protocol.getProtocolLocations().get(1)).getRolodexId());
        ProtocolMergeTest.assertEquals((Object)ROLODEX_ID_2, (Object)((ProtocolLocationBase)protocol.getProtocolLocations().get(2)).getRolodexId());
    }

    private ProtocolLocation createLocation(Integer rolodexId) {
        ProtocolLocation loc = new ProtocolLocation();
        loc.setRolodexId(rolodexId);
        return loc;
    }

    @Test
    public void testPersonnelMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("002");
        ProtocolPerson person = this.createPerson(NAME_1);
        person.setPersonId("1");
        person.setProtocolPersonRoleId("PI");
        amendment.getProtocolPersons().add(person);
        person = this.createPerson(NAME_2);
        person.setPersonId("2");
        person.setProtocolPersonRoleId("COI");
        amendment.getProtocolPersons().add(person);
        ProtocolAttachmentPersonnel pal = this.createPersonnelAttachment(DESCRIPTION_1);
        person.setAttachmentPersonnels(new ArrayList());
        amendment.getAttachmentPersonnels().add(pal);
        person.getAttachmentPersonnels().add(pal);
        pal = this.createPersonnelAttachment(DESCRIPTION_2);
        amendment.getAttachmentPersonnels().add(pal);
        person.getAttachmentPersonnels().add(pal);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getProtocolPersons().size());
        ProtocolMergeTest.assertEquals((Object)NAME_1, (Object)((ProtocolPersonBase)protocol.getProtocolPersons().get(0)).getPersonName());
        ProtocolMergeTest.assertEquals((Object)NAME_2, (Object)((ProtocolPersonBase)protocol.getProtocolPersons().get(1)).getPersonName());
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getAttachmentPersonnels().size());
        ProtocolMergeTest.assertEquals((Object)DESCRIPTION_1, (Object)((ProtocolAttachmentPersonnelBase)protocol.getAttachmentPersonnels().get(0)).getDescription());
        ProtocolMergeTest.assertEquals((Object)DESCRIPTION_2, (Object)((ProtocolAttachmentPersonnelBase)protocol.getAttachmentPersonnels().get(1)).getDescription());
    }

    private ProtocolPerson createPerson(String personName) {
        ProtocolPerson person = new ProtocolPerson();
        person.setPersonName(personName);
        return person;
    }

    @Test
    public void testSpecialReviewMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("007");
        ProtocolSpecialReview sr = this.createSpecialReview("2");
        amendment.getSpecialReviews().add(sr);
        sr = this.createSpecialReview(SPECIAL_REVIEW_CODE_2);
        amendment.getSpecialReviews().add(sr);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getSpecialReviews().size());
        ProtocolMergeTest.assertEquals((Object)"2", (Object)((ProtocolSpecialReviewBase)protocol.getSpecialReviews().get(0)).getSpecialReviewTypeCode());
        ProtocolMergeTest.assertEquals((Object)SPECIAL_REVIEW_CODE_2, (Object)((ProtocolSpecialReviewBase)protocol.getSpecialReviews().get(1)).getSpecialReviewTypeCode());
    }

    private ProtocolSpecialReview createSpecialReview(String specialReviewCode) {
        ProtocolSpecialReview sr = new ProtocolSpecialReview();
        sr.setSpecialReviewTypeCode(specialReviewCode);
        return sr;
    }

    @Test
    public void testAttachmentsMerge() {
        Protocol protocol = this.createProtocol();
        Protocol amendment = this.createAmendment("008");
        ProtocolAttachmentProtocol pap = this.createProtocolAttachment(NAME_1);
        amendment.getAttachmentProtocols().add(pap);
        pap = this.createProtocolAttachment(NAME_2);
        amendment.getAttachmentProtocols().add(pap);
        protocol.merge((ProtocolBase)amendment);
        ProtocolMergeTest.assertEquals((long)2L, (long)protocol.getAttachmentProtocols().size());
        ProtocolMergeTest.assertEquals((Object)NAME_1, (Object)((ProtocolAttachmentProtocolBase)protocol.getAttachmentProtocols().get(0)).getContactName());
        ProtocolMergeTest.assertEquals((Object)NAME_2, (Object)((ProtocolAttachmentProtocolBase)protocol.getAttachmentProtocols().get(1)).getContactName());
    }

    private ProtocolAttachmentPersonnel createPersonnelAttachment(String description) {
        ProtocolAttachmentPersonnel pal = new ProtocolAttachmentPersonnel();
        pal.setDescription(description);
        return pal;
    }

    private ProtocolAttachmentProtocol createProtocolAttachment(String name) {
        ProtocolAttachmentProtocol pap = new ProtocolAttachmentProtocol();
        pap.setContactName(name);
        pap.setDocumentStatusCode("1");
        return pap;
    }

    private Protocol createProtocol() {
        Protocol protocol = new Protocol();
        protocol.setProtocolId(Long.valueOf(1L));
        protocol.setProtocolNumber("0906000001");
        return protocol;
    }

    private Protocol createAmendment(String moduleTypeCode) {
        Protocol protocol = new Protocol();
        ((ProtocolLocationService)KraServiceLocator.getService(ProtocolLocationService.class)).addDefaultProtocolLocation((ProtocolBase)protocol);
        protocol.setProtocolId(Long.valueOf(2L));
        protocol.setProtocolNumber("0906000001A001");
        this.addModule(protocol, moduleTypeCode);
        ArrayList<ProtocolAction> actions = new ArrayList<ProtocolAction>();
        ProtocolAction action1 = new ProtocolAction();
        action1.setActionId(Integer.valueOf(1));
        actions.add(action1);
        ProtocolAction action2 = new ProtocolAction();
        action2.setActionId(Integer.valueOf(2));
        actions.add(action2);
        protocol.setProtocolActions(actions);
        return protocol;
    }

    private void addModule(Protocol protocol, String moduleTypeCode) {
        ProtocolAmendRenewal amendRenewal = new ProtocolAmendRenewal();
        ProtocolAmendRenewModule module = new ProtocolAmendRenewModule();
        module.setProtocolModuleTypeCode(moduleTypeCode);
        amendRenewal.addModule((ProtocolAmendRenewModuleBase)module);
        protocol.setProtocolAmendRenewal((ProtocolAmendRenewalBase)amendRenewal);
    }
}

