/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.approve;

import java.util.Date;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Test;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveEvent;
import org.kuali.kra.irb.actions.approve.ProtocolApproveRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.kra.util.DateUtils;

public class ProtocolApproveRuleTest
extends ProtocolRuleTestBase {
    private static final java.sql.Date ACTION_DATE = new java.sql.Date(System.currentTimeMillis());
    private static final java.sql.Date APPROVAL_DATE = DateUtils.convertToSqlDate((Date)DateUtils.addWeeks((Date)ACTION_DATE, (int)-1));
    private static final java.sql.Date EXPIRATION_DATE = DateUtils.convertToSqlDate((Date)DateUtils.addYears((Date)ACTION_DATE, (int)1));
    private static final String APPROVAL_DATE_FIELD = "approvalDate";
    private static final String EXPIRATION_DATE_FIELD = "expirationDate";
    private static final String ACTION_DATE_FIELD = "actionDate";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Test
    public void testOk() {
        new TemplateRuleTest<ProtocolApproveEvent, ProtocolApproveRule>(){

            @Override
            protected void prerequisite() {
                ProtocolApproveBean bean = ProtocolApproveRuleTest.this.getMockProtocolApproveBean(APPROVAL_DATE, EXPIRATION_DATE, ACTION_DATE);
                this.event = new ProtocolApproveEvent(null, bean);
                this.rule = new ProtocolApproveRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testNoApprovalDate() {
        new TemplateRuleTest<ProtocolApproveEvent, ProtocolApproveRule>(){

            @Override
            protected void prerequisite() {
                ProtocolApproveBean bean = ProtocolApproveRuleTest.this.getMockProtocolApproveBean(null, EXPIRATION_DATE, ACTION_DATE);
                this.event = new ProtocolApproveEvent(null, bean);
                this.rule = new ProtocolApproveRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolApproveRuleTest.this.assertError(ProtocolApproveRuleTest.APPROVAL_DATE_FIELD, "error.protocol.approve.approveDate.required");
            }
        };
    }

    @Test
    public void testNoExpirationDate() throws Exception {
        new TemplateRuleTest<ProtocolApproveEvent, ProtocolApproveRule>(){

            @Override
            protected void prerequisite() {
                ProtocolApproveBean bean = ProtocolApproveRuleTest.this.getMockProtocolApproveBean(APPROVAL_DATE, null, ACTION_DATE);
                this.event = new ProtocolApproveEvent(null, bean);
                this.rule = new ProtocolApproveRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolApproveRuleTest.this.assertError(ProtocolApproveRuleTest.EXPIRATION_DATE_FIELD, "error.protocol.approve.expirationDate.required");
            }
        };
    }

    @Test
    public void testNoActionDate() {
        new TemplateRuleTest<ProtocolApproveEvent, ProtocolApproveRule>(){

            @Override
            protected void prerequisite() {
                ProtocolApproveBean bean = ProtocolApproveRuleTest.this.getMockProtocolApproveBean(APPROVAL_DATE, EXPIRATION_DATE, null);
                this.event = new ProtocolApproveEvent(null, bean);
                this.rule = new ProtocolApproveRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolApproveRuleTest.this.assertError(ProtocolApproveRuleTest.ACTION_DATE_FIELD, "error.protocol.generic.actionDate.required");
            }
        };
    }

    private ProtocolApproveBean getMockProtocolApproveBean(final java.sql.Date approvalDate, final java.sql.Date expirationDate, final java.sql.Date actionDate) {
        final ProtocolApproveBean bean = (ProtocolApproveBean)this.context.mock(ProtocolApproveBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolApproveBean)this.allowing(bean)).getApprovalDate();
                this.will(6.returnValue((Object)approvalDate));
                ((ProtocolApproveBean)this.allowing(bean)).getExpirationDate();
                this.will(6.returnValue((Object)expirationDate));
                ((ProtocolApproveBean)this.allowing(bean)).getActionDate();
                this.will(6.returnValue((Object)actionDate));
                ((ProtocolApproveBean)this.allowing(bean)).getErrorPropertyKey();
                this.will(6.returnValue((Object)"actionHelper.protocolFullApprovalBean"));
            }
        });
        return bean;
    }
}

