/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.approve;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveServiceImpl;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolApproveServiceImplTest
extends KcUnitTestBase {
    private static final Date ACTION_DATE = new Date(System.currentTimeMillis());
    private static final String COMMENTS = "some comments go here";
    private static final Date APPROVAL_DATE = DateUtils.convertToSqlDate((java.util.Date)DateUtils.addWeeks((java.util.Date)ACTION_DATE, (int)-1));
    private static final Date EXPIRATION_DATE = DateUtils.convertToSqlDate((java.util.Date)DateUtils.addYears((java.util.Date)ACTION_DATE, (int)1));
    private static final String PROTOCOL_TYPE_EXEMPT = "4";
    private ProtocolApproveServiceImpl service;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolApproveServiceImpl();
        this.service.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setParameterService(this.getMockParameterService());
        this.service.setProtocolActionCorrespondenceGenerationService((org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService)this.getMockActionCorrespondenceGenerationService());
        this.service.setProtocolOnlineReviewService((org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService)this.getMockOnlineReviewService());
        this.service.setDocumentService((DocumentService)KraServiceLocator.getService(DocumentService.class));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testFullApproval() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.addProtocolAction(protocolDocument.getProtocol());
        this.service.grantFullApproval((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.approve.ProtocolApproveBean)this.getMockProtocolApproveBean());
        this.verifyPersistStatusAction(protocolDocument.getProtocol());
    }

    @Test
    public void testExpeditedApproval() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.addProtocolAction(protocolDocument.getProtocol());
        this.service.grantExpeditedApproval(protocolDocument.getProtocol(), this.getMockProtocolApproveBean());
        this.verifyPersistStatusAction(protocolDocument.getProtocol());
    }

    @Test
    public void testResponseApproval() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.addProtocolAction(protocolDocument.getProtocol());
        this.service.grantResponseApproval(protocolDocument.getProtocol(), this.getMockProtocolApproveBean());
        this.verifyPersistStatusAction(protocolDocument.getProtocol());
    }

    private void addProtocolAction(Protocol protocol) {
        ProtocolAction newAction = new ProtocolAction();
        newAction.setActionId(protocol.getNextValue("actionId"));
        newAction.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        newAction.setActionDate(new Timestamp(ACTION_DATE.getTime()));
        newAction.setProtocolActionTypeCode("109");
        newAction.setProtocolNumber(protocol.getProtocolNumber());
        newAction.setProtocolId(protocol.getProtocolId());
        newAction.setSequenceNumber(protocol.getSequenceNumber());
        newAction.setComments(COMMENTS);
        if (protocol.getProtocolActions() == null) {
            protocol.setProtocolActions(new ArrayList());
        }
        protocol.getProtocolActions().add(newAction);
    }

    private void verifyPersistStatusAction(Protocol protocol) {
        ProtocolApproveServiceImplTest.assertEquals((Object)"200", (Object)protocol.getProtocolStatusCode());
        ProtocolApproveServiceImplTest.assertTrue((!protocol.getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocol.getLastProtocolAction();
        ProtocolApproveServiceImplTest.assertNotNull((Object)action);
        ProtocolApproveServiceImplTest.assertEquals((Object)APPROVAL_DATE, (Object)protocol.getApprovalDate());
        ProtocolApproveServiceImplTest.assertEquals((Object)EXPIRATION_DATE, (Object)protocol.getExpirationDate());
        ProtocolApproveServiceImplTest.assertEquals((Object)COMMENTS, (Object)action.getComments());
        ProtocolApproveServiceImplTest.assertEquals((Object)ACTION_DATE, (Object)action.getActionDate());
    }

    private ParameterService getMockParameterService() {
        final ParameterService service = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.allowing(service)).getParameterValueAsString(ProtocolDocument.class, "irb.protocol.protocoltype.exempt");
                this.will(2.returnValue((Object)ProtocolApproveServiceImplTest.PROTOCOL_TYPE_EXEMPT));
            }
        });
        return service;
    }

    private ProtocolActionCorrespondenceGenerationService getMockActionCorrespondenceGenerationService() {
        final ProtocolActionCorrespondenceGenerationService service = (ProtocolActionCorrespondenceGenerationService)this.context.mock(ProtocolActionCorrespondenceGenerationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolOnlineReviewService getMockOnlineReviewService() {
        final ProtocolOnlineReviewService service = (ProtocolOnlineReviewService)this.context.mock(ProtocolOnlineReviewService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolApproveBean getMockProtocolApproveBean() {
        final ProtocolApproveBean bean = (ProtocolApproveBean)this.context.mock(ProtocolApproveBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolApproveBean)this.allowing(bean)).getApprovalDate();
                this.will(5.returnValue((Object)APPROVAL_DATE));
                ((ProtocolApproveBean)this.allowing(bean)).getExpirationDate();
                this.will(5.returnValue((Object)EXPIRATION_DATE));
                ((ProtocolApproveBean)this.allowing(bean)).getActionDate();
                this.will(5.returnValue((Object)ACTION_DATE));
                ((ProtocolApproveBean)this.allowing(bean)).getComments();
                this.will(5.returnValue((Object)ProtocolApproveServiceImplTest.COMMENTS));
            }
        });
        return bean;
    }
}

