/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assignagenda;

import java.sql.Date;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Test;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaEvent;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;

public class ProtocolAssignToAgendaRuleTest
extends ProtocolRuleTestBase {
    private static final String COMMITTEE_ID = "10014";
    private static final Date ACTION_DATE = new Date(System.currentTimeMillis());
    private static final String COMMITTEE_ID_FIELD = "committeeId";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Test
    public void testHasCommittee() throws Exception {
        new TemplateRuleTest<ProtocolAssignToAgendaEvent, ProtocolAssignToAgendaRule>(){

            @Override
            protected void prerequisite() {
                this.event = new ProtocolAssignToAgendaEvent(null, ProtocolAssignToAgendaRuleTest.this.getMockAssignToAgendaBean(ProtocolAssignToAgendaRuleTest.COMMITTEE_ID));
                this.rule = new ProtocolAssignToAgendaRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testNoCommittee() throws Exception {
        new TemplateRuleTest<ProtocolAssignToAgendaEvent, ProtocolAssignToAgendaRule>(){

            @Override
            protected void prerequisite() {
                this.event = new ProtocolAssignToAgendaEvent(null, ProtocolAssignToAgendaRuleTest.this.getMockAssignToAgendaBean(""));
                this.rule = new ProtocolAssignToAgendaRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolAssignToAgendaRuleTest.this.assertError(ProtocolAssignToAgendaRuleTest.COMMITTEE_ID_FIELD, "error.protocol.submission.committee.required");
            }
        };
    }

    private ProtocolAssignToAgendaBean getMockAssignToAgendaBean(final String committeeId) {
        final ProtocolAssignToAgendaBean bean = (ProtocolAssignToAgendaBean)this.context.mock(ProtocolAssignToAgendaBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAssignToAgendaBean)this.allowing(bean)).getCommitteeId();
                this.will(4.returnValue((Object)committeeId));
                ((ProtocolAssignToAgendaBean)this.allowing(bean)).getActionDate();
                this.will(4.returnValue((Object)ACTION_DATE));
                ((ProtocolAssignToAgendaBean)this.allowing(bean)).isProtocolAssigned();
                this.will(4.returnValue((Object)true));
            }
        });
        return bean;
    }
}

