/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assignagenda;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.document.CommitteeDocumentBase;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolAssignToAgendaServiceTest
extends KcUnitTestBase {
    private static final String COMMITTEE_ID = "699";
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private ProtocolAssignToAgendaService protocolAssignToAgendaService;
    private ProtocolAssignToAgendaServiceImpl protocolAssignToAgendaServiceImpl;
    private BusinessObjectService businessObjectService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.protocolActionService = (ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class);
        this.protocolAssignToAgendaService = (ProtocolAssignToAgendaService)KraServiceLocator.getService(ProtocolAssignToAgendaService.class);
        this.protocolAssignToAgendaServiceImpl = (ProtocolAssignToAgendaServiceImpl)KraServiceLocator.getService(ProtocolAssignToAgendaService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.businessObjectService = null;
        this.documentService = null;
        this.protocolActionService = null;
        this.protocolAssignToAgendaService = null;
        this.protocolAssignToAgendaServiceImpl = null;
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testSetDocumentService() {
        this.protocolAssignToAgendaServiceImpl.setDocumentService(this.documentService);
        ProtocolAssignToAgendaServiceTest.assertTrue((boolean)true);
    }

    @Test
    public void testSetProtocolActionService() {
        this.protocolAssignToAgendaServiceImpl.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)this.protocolActionService);
        ProtocolAssignToAgendaServiceTest.assertTrue((boolean)true);
    }

    @Test
    public void testAssignToAgenda() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "100");
        Committee committee = this.getCommittee();
        committee.refreshReferenceObject("committeeType");
        submission.setCommittee((CommitteeBase)committee);
        submission.setCommitteeIdFk(committee.getId());
        submission.setCommitteeId(committee.getCommitteeId());
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        ProtocolForm form = new ProtocolForm();
        ActionHelper actionHelper = new ActionHelper(form);
        ProtocolAssignToAgendaBean actionBean = (ProtocolAssignToAgendaBean)actionHelper.getAssignToAgendaBean();
        actionBean.setComments("this is a comment");
        actionBean.setCommitteName("committee name");
        actionBean.setProtocolAssigned(true);
        this.protocolAssignToAgendaService.assignToAgenda((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean)actionBean);
        ProtocolAssignToAgendaServiceTest.assertTrue((boolean)true);
    }

    private Committee getCommittee() throws WorkflowException {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("committeeId", COMMITTEE_ID);
        List comms = (List)this.businessObjectService.findMatching(Committee.class, keymap);
        Committee committee = new Committee();
        if (comms.size() == 1) {
            committee = (Committee)comms.get(0);
        }
        if (committee == null) {
            committee = (Committee)this.createCommittee(COMMITTEE_ID).getCommittee();
        }
        committee.refreshReferenceObject("committeeType");
        return committee;
    }

    private CommitteeDocument createCommittee(String committeeId) throws WorkflowException {
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument(committeeId);
        Committee committee = (Committee)committeeDocument.getCommittee();
        CommitteeSchedule schedule = new CommitteeSchedule();
        schedule.setScheduleId("1");
        schedule.setPlace("my office");
        schedule.setEndTime(new Timestamp(System.currentTimeMillis() + 100L));
        schedule.setScheduledDate(new Date(System.currentTimeMillis()));
        schedule.setStartTime(new Timestamp(System.currentTimeMillis() - 100L));
        schedule.setFilter(false);
        schedule.setMaxProtocols(committee.getMaxProtocols());
        schedule.setTime(new Timestamp(System.currentTimeMillis()));
        schedule.setViewTime(new Time12HrFmt(new Timestamp(System.currentTimeMillis())));
        schedule.setProtocolSubDeadline(new Date(System.currentTimeMillis() - 500L));
        schedule.setScheduleStatusCode(Integer.valueOf(1));
        committee.getCommitteeSchedules().add(schedule);
        this.documentService.saveDocument((Document)committeeDocument);
        this.documentService.routeDocument((Document)committeeDocument, "Test Routing", new ArrayList());
        return committeeDocument;
    }

    @Test
    public void testIsAssignedToAgenda1() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "100");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        ArrayList<ProtocolAction> actions = new ArrayList<ProtocolAction>();
        actions.add(new ProtocolAction(protocolDocument.getProtocol(), submission, "101"));
        protocolDocument.getProtocol().setProtocolActions(actions);
        boolean result = this.protocolAssignToAgendaService.isAssignedToAgenda((ProtocolBase)protocolDocument.getProtocol());
        ProtocolAssignToAgendaServiceTest.assertFalse((boolean)result);
    }

    @Test
    public void testIsAssignedToAgenda2() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "101");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        ArrayList<ProtocolAction> actions = new ArrayList<ProtocolAction>();
        actions.add(new ProtocolAction(protocolDocument.getProtocol(), submission, "200"));
        protocolDocument.getProtocol().setProtocolActions(actions);
        boolean result = this.protocolAssignToAgendaService.isAssignedToAgenda((ProtocolBase)protocolDocument.getProtocol());
        ProtocolAssignToAgendaServiceTest.assertTrue((boolean)result);
    }

    @Test
    public void testGetAssignToAgendaComments() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "100");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        ArrayList<ProtocolAction> actions = new ArrayList<ProtocolAction>();
        ProtocolAction pa = new ProtocolAction(protocolDocument.getProtocol(), submission, "200");
        String comments = "My test protocol action comments";
        pa.setComments(comments);
        actions.add(pa);
        protocolDocument.getProtocol().setProtocolActions(actions);
        String result = this.protocolAssignToAgendaService.getAssignToAgendaComments((ProtocolBase)protocolDocument.getProtocol());
        ProtocolAssignToAgendaServiceTest.assertEquals((Object)comments, (Object)result);
    }

    @Test
    public void testGetAssignedCommitteeId() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "100");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        String committeeId = this.protocolAssignToAgendaService.getAssignedCommitteeId((ProtocolBase)protocolDocument.getProtocol());
        ProtocolAssignToAgendaServiceTest.assertEquals((Object)"1", (Object)committeeId);
    }

    @Test
    public void testGetAssignedCommitteeName() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "100");
        Committee com = new Committee();
        com.setCommitteeId("1");
        com.setHomeUnitNumber("000001");
        com.setCommitteeTypeCode("1");
        com.setReviewTypeCode("1");
        String passedInCommitteeName = "testCommitteeName";
        com.setCommitteeName(passedInCommitteeName);
        submission.setCommittee((CommitteeBase)com);
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setDocumentNumber("101");
        documentHeader.setDocumentDescription("super cool description");
        CommitteeDocument cd = new CommitteeDocument();
        cd.setCommittee((CommitteeBase)com);
        cd.setDocumentNumber("1");
        cd.setDocumentHeader(documentHeader);
        cd.setUpdateTimestamp(new Timestamp(20100305L));
        cd.setUpdateUser("quickstart");
        cd.setVersionNumber(new Long(1L));
        com.setCommitteeDocument((CommitteeDocumentBase)cd);
        this.businessObjectService.save((PersistableBusinessObject)documentHeader);
        this.businessObjectService.save((PersistableBusinessObject)cd);
        this.businessObjectService.save((PersistableBusinessObject)com);
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        this.documentService.saveDocument((Document)protocolDocument);
        String committeeName = this.protocolAssignToAgendaService.getAssignedCommitteeName((ProtocolBase)protocolDocument.getProtocol());
        ProtocolAssignToAgendaServiceTest.assertEquals((Object)passedInCommitteeName, (Object)committeeName);
    }

    @Test
    public void testGetAssignedScheduleDate() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "100");
        Committee com = new Committee();
        com.setCommitteeId("1");
        com.setId(new Long(1L));
        com.setHomeUnitNumber("000001");
        com.setCommitteeTypeCode("1");
        com.setReviewTypeCode("1");
        com.setAdvancedSubmissionDaysRequired(new Integer(1));
        String passedInCommitteeName = "testCommitteeName";
        com.setCommitteeName(passedInCommitteeName);
        submission.setCommittee((CommitteeBase)com);
        CommitteeSchedule cs = new CommitteeSchedule();
        cs.setCommittee(com);
        cs.setCommitteeIdFk(com.getId());
        cs.setScheduleId("1069");
        Date basicDate = new Date(2010, 3, 17);
        cs.setAgendaProdRevDate(basicDate);
        cs.setId(new Long(12345L));
        cs.setScheduledDate(basicDate);
        cs.setProtocolSubDeadline(basicDate);
        cs.setScheduleStatusCode(new Integer(1));
        cs.setTime(new Timestamp(20100305L));
        ArrayList<CommitteeSchedule> committeeSchedules = new ArrayList<CommitteeSchedule>();
        committeeSchedules.add(cs);
        com.setCommitteeSchedules(committeeSchedules);
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setDocumentNumber("101");
        documentHeader.setDocumentDescription("super cool description");
        CommitteeDocument cd = new CommitteeDocument();
        cd.setCommittee((CommitteeBase)com);
        cd.setDocumentNumber("1");
        cd.setDocumentHeader(documentHeader);
        cd.setUpdateTimestamp(new Timestamp(20100305L));
        cd.setUpdateUser("quickstart");
        cd.setVersionNumber(new Long(1L));
        com.setCommitteeDocument((CommitteeDocumentBase)cd);
        this.businessObjectService.save((PersistableBusinessObject)documentHeader);
        this.businessObjectService.save((PersistableBusinessObject)cd);
        this.businessObjectService.save((PersistableBusinessObject)com);
        this.businessObjectService.save((PersistableBusinessObject)cs);
        submission.setScheduleId(cs.getScheduleId());
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        this.documentService.saveDocument((Document)protocolDocument);
        String agendaDate = this.protocolAssignToAgendaService.getAssignedScheduleDate((ProtocolBase)protocolDocument.getProtocol());
        ProtocolAssignToAgendaServiceTest.assertNotNull((Object)agendaDate);
    }

    private ProtocolSubmission createSubmission(Protocol protocol, String statusCode) {
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocol((ProtocolBase)protocol);
        submission.setProtocolId(protocol.getProtocolId());
        submission.setProtocolNumber(protocol.getProtocolNumber());
        submission.setSubmissionNumber(Integer.valueOf(1));
        submission.setSubmissionTypeCode("100");
        submission.setSubmissionStatusCode(statusCode);
        submission.setProtocolReviewTypeCode("1");
        submission.setSubmissionDate(new Date(System.currentTimeMillis()));
        if (StringUtils.equals((String)statusCode, (String)"100")) {
            submission.setCommitteeId("1");
        }
        return submission;
    }
}

