/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assigncmtsched;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolAssignCmtSchedServiceTest
extends KcUnitTestBase {
    private BusinessObjectService businessObjectService;
    private ProtocolAssignCmtSchedService protocolAssignCmtSchedService;
    private CommitteeDocument committeeDocument;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.protocolAssignCmtSchedService = (ProtocolAssignCmtSchedService)KraServiceLocator.getService(ProtocolAssignCmtSchedService.class);
        this.committeeDocument = this.createCommittee("666");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testNoSubmission() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        String committeeId = this.protocolAssignCmtSchedService.getAssignedCommitteeId(protocolDocument.getProtocol());
        ProtocolAssignCmtSchedServiceTest.assertTrue((boolean)StringUtils.isBlank((String)committeeId));
    }

    @Test
    public void testSubmissionNoCommittee() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "102");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        String committeeId = this.protocolAssignCmtSchedService.getAssignedCommitteeId(protocolDocument.getProtocol());
        ProtocolAssignCmtSchedServiceTest.assertTrue((boolean)StringUtils.isBlank((String)committeeId));
    }

    @Test
    public void testSubmissionWithCommittee() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "100");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        String committeeId = this.protocolAssignCmtSchedService.getAssignedCommitteeId(protocolDocument.getProtocol());
        ProtocolAssignCmtSchedServiceTest.assertEquals((Object)"1", (Object)committeeId);
    }

    @Test
    public void testAssignmentToCommittee() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "102");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        ProtocolAssignCmtSchedBean actionBean = new ProtocolAssignCmtSchedBean(null);
        actionBean.setCommitteeId(((Committee)this.committeeDocument.getCommittee()).getCommitteeId());
        this.protocolAssignCmtSchedService.assignToCommitteeAndSchedule(protocolDocument.getProtocol(), actionBean);
        ProtocolAssignCmtSchedServiceTest.assertEquals((Object)"100", (Object)submission.getSubmissionStatusCode());
        ProtocolAssignCmtSchedServiceTest.assertEquals((Object)"666", (Object)submission.getCommitteeId());
        ProtocolAssignCmtSchedServiceTest.assertEquals(null, (Object)submission.getScheduleId());
    }

    @Test
    public void testAssignmentToSchedule() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "102");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        ProtocolAssignCmtSchedBean actionBean = new ProtocolAssignCmtSchedBean(null);
        actionBean.setCommitteeId(((Committee)this.committeeDocument.getCommittee()).getCommitteeId());
        actionBean.setScheduleId("1");
        this.protocolAssignCmtSchedService.assignToCommitteeAndSchedule(protocolDocument.getProtocol(), actionBean);
        ProtocolAssignCmtSchedServiceTest.assertEquals((Object)"100", (Object)submission.getSubmissionStatusCode());
        ProtocolAssignCmtSchedServiceTest.assertEquals((Object)"666", (Object)submission.getCommitteeId());
        ProtocolAssignCmtSchedServiceTest.assertEquals((Object)"1", (Object)submission.getScheduleId());
    }

    private ProtocolSubmission createSubmission(Protocol protocol, String statusCode) {
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocol((ProtocolBase)protocol);
        submission.setProtocolId(protocol.getProtocolId());
        submission.setProtocolNumber(protocol.getProtocolNumber());
        submission.setSubmissionNumber(Integer.valueOf(1));
        submission.setSubmissionTypeCode("100");
        submission.setSubmissionStatusCode(statusCode);
        submission.setProtocolReviewTypeCode("1");
        submission.setSubmissionDate(new Date(System.currentTimeMillis()));
        if (StringUtils.equals((String)statusCode, (String)"100")) {
            submission.setCommitteeId("1");
        }
        return submission;
    }

    private CommitteeDocument createCommittee(String committeeId) throws WorkflowException {
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument(committeeId);
        Committee committee = (Committee)committeeDocument.getCommittee();
        CommitteeSchedule schedule = new CommitteeSchedule();
        schedule.setScheduleId("1");
        schedule.setPlace("my office");
        schedule.setEndTime(new Timestamp(System.currentTimeMillis() + 100L));
        schedule.setScheduledDate(new Date(System.currentTimeMillis()));
        schedule.setStartTime(new Timestamp(System.currentTimeMillis() - 100L));
        schedule.setFilter(false);
        schedule.setMaxProtocols(committee.getMaxProtocols());
        schedule.setTime(new Timestamp(System.currentTimeMillis()));
        schedule.setViewTime(new Time12HrFmt(new Timestamp(System.currentTimeMillis())));
        schedule.setProtocolSubDeadline(new Date(System.currentTimeMillis() - 500L));
        schedule.setScheduleStatusCode(Integer.valueOf(1));
        committee.getCommitteeSchedules().add(schedule);
        this.businessObjectService.save((PersistableBusinessObject)committeeDocument);
        return committeeDocument;
    }
}

