/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.assignreviewers;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeMembershipExpertise;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.service.CommitteeMembershipService;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolAssignReviewersServiceTest
extends KcUnitTestBase {
    private static final String PERSON_ID = "000000003";
    private static final String MEMBERSHIP_TYPE_CD = "1";
    private static final Date TERM_START_DATE = Date.valueOf("2009-01-01");
    private static final Date TERM_END_DATE = Date.valueOf("2009-01-31");
    private static final String MEMBERSHIP_ROLE_CD_1 = "1";
    private static final String MEMBERSHIP_ROLE_CD_4 = "4";
    private static final String MEMBERSHIP_ROLE_CD_7 = "7";
    private static final Date ROLE_START_DATE = Date.valueOf("2009-01-10");
    private static final Date ROLE_END_DATE = Date.valueOf("2009-01-20");
    private static final String RESEARCH_AREA_CODE_1 = "000001";
    private static final String RESEARCH_AREA_CODE_3 = "01.0101";
    private static final String RESEARCH_AREA_CODE_5 = "01.0201";
    private BusinessObjectService businessObjectService;
    private ProtocolAssignCmtSchedService protocolAssignCmtSchedService;
    private CommitteeMembershipService committeeMembershipService;
    private CommitteeDocument committeeDocument;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.protocolAssignCmtSchedService = (ProtocolAssignCmtSchedService)KraServiceLocator.getService(ProtocolAssignCmtSchedService.class);
        this.committeeMembershipService = (CommitteeMembershipService)KraServiceLocator.getService(CommitteeMembershipService.class);
        this.committeeDocument = this.createCommittee("666");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testAssignmentReviewers() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission submission = this.createSubmission(protocolDocument.getProtocol(), "102");
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        ProtocolAssignCmtSchedBean actionBean = new ProtocolAssignCmtSchedBean(null);
        actionBean.setCommitteeId(((Committee)this.committeeDocument.getCommittee()).getCommitteeId());
        actionBean.setScheduleId("1");
        this.protocolAssignCmtSchedService.assignToCommitteeAndSchedule(protocolDocument.getProtocol(), actionBean);
        ProtocolAssignReviewersServiceTest.assertEquals((Object)"100", (Object)submission.getSubmissionStatusCode());
        ProtocolAssignReviewersServiceTest.assertEquals((Object)"666", (Object)submission.getCommitteeId());
        ProtocolAssignReviewersServiceTest.assertEquals((Object)"1", (Object)submission.getScheduleId());
    }

    private ProtocolSubmission createSubmission(Protocol protocol, String statusCode) {
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocol((ProtocolBase)protocol);
        submission.setProtocolId(protocol.getProtocolId());
        submission.setProtocolNumber(protocol.getProtocolNumber());
        submission.setSubmissionId(new Long(1L));
        submission.setSubmissionNumber(Integer.valueOf(1));
        submission.setSubmissionTypeCode("100");
        submission.setSubmissionStatusCode(statusCode);
        submission.setProtocolReviewTypeCode("1");
        submission.setSubmissionDate(new Date(System.currentTimeMillis()));
        if (StringUtils.equals((String)statusCode, (String)"100")) {
            submission.setCommitteeId("1");
        }
        return submission;
    }

    private CommitteeDocument createCommittee(String committeeId) throws WorkflowException {
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument(committeeId);
        Committee committee = (Committee)committeeDocument.getCommittee();
        CommitteeSchedule schedule = new CommitteeSchedule();
        schedule.setScheduleId("1");
        schedule.setPlace("my office");
        schedule.setEndTime(new Timestamp(System.currentTimeMillis() + 100L));
        schedule.setScheduledDate(new Date(System.currentTimeMillis()));
        schedule.setStartTime(new Timestamp(System.currentTimeMillis() - 100L));
        schedule.setFilter(false);
        schedule.setMaxProtocols(committee.getMaxProtocols());
        schedule.setTime(new Timestamp(System.currentTimeMillis()));
        schedule.setViewTime(new Time12HrFmt(new Timestamp(System.currentTimeMillis())));
        schedule.setProtocolSubDeadline(new Date(System.currentTimeMillis() - 500L));
        schedule.setScheduleStatusCode(Integer.valueOf(1));
        committee.getCommitteeSchedules().add(schedule);
        CommitteeMembership committeeMembership = this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE);
        committeeMembership.getMembershipExpertise().add(this.getExpertise(RESEARCH_AREA_CODE_1));
        committeeMembership.getMembershipExpertise().add(this.getExpertise(RESEARCH_AREA_CODE_3));
        committeeMembership.getMembershipExpertise().add(this.getExpertise(RESEARCH_AREA_CODE_5));
        committeeMembership.getMembershipRoles().add(this.getRole("1", ROLE_START_DATE, ROLE_END_DATE));
        committeeMembership.getMembershipRoles().add(this.getRole(MEMBERSHIP_ROLE_CD_4, ROLE_START_DATE, ROLE_END_DATE));
        committeeMembership.getMembershipRoles().add(this.getRole(MEMBERSHIP_ROLE_CD_7, ROLE_START_DATE, ROLE_END_DATE));
        this.committeeMembershipService.addCommitteeMembership((CommitteeBase)committee, (CommitteeMembershipBase)committeeMembership);
        this.businessObjectService.save((PersistableBusinessObject)committeeDocument);
        return committeeDocument;
    }

    private CommitteeMembership getMembership(String personID, Integer rolodexID, String membershipTypeCode, Date termStartDate, Date termEndDate) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonId(personID);
        committeeMembership.setPersonName("Jack");
        committeeMembership.setRolodexId(rolodexID);
        committeeMembership.setMembershipTypeCode(membershipTypeCode);
        committeeMembership.setTermStartDate(termStartDate);
        committeeMembership.setTermEndDate(termEndDate);
        return committeeMembership;
    }

    private CommitteeMembershipRole getRole(String membershipRoleCode, Date startDate, Date endDate) {
        CommitteeMembershipRole committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode(membershipRoleCode);
        committeeMembershipRole.setStartDate(startDate);
        committeeMembershipRole.setEndDate(endDate);
        return committeeMembershipRole;
    }

    private CommitteeMembershipExpertise getExpertise(String researchAreaCode) {
        CommitteeMembershipExpertise committeeMembershipExpertise = new CommitteeMembershipExpertise();
        committeeMembershipExpertise.setResearchAreaCode(researchAreaCode);
        return committeeMembershipExpertise;
    }
}

