/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.correspondence;

import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.withdraw.WithdrawCorrespondence;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolActionCorrespondenceGenerationServiceTest
extends KcUnitTestBase {
    ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService;
    BusinessObjectService businessObjectService;
    Protocol protocol;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.protocolActionCorrespondenceGenerationService = (ProtocolActionCorrespondenceGenerationService)KraServiceLocator.getService(ProtocolActionCorrespondenceGenerationService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.protocol = ProtocolFactory.createProtocolDocument().getProtocol();
        this.createActionHistory();
    }

    private void createActionHistory() {
        ProtocolAction protocolAction = new ProtocolAction(this.protocol, null, "100");
        protocolAction.setProtocolNumber(this.protocol.getProtocolNumber());
        protocolAction.setSequenceNumber(this.protocol.getSequenceNumber());
        protocolAction.setProtocolId(this.protocol.getProtocolId());
        protocolAction.setActionId(this.protocol.getNextValue("actionId"));
        protocolAction.setComments("Protocol created");
        this.protocol.getProtocolActions().add(protocolAction);
        this.getBusinessObjectService().save((PersistableBusinessObject)this.protocol);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.protocolActionCorrespondenceGenerationService = null;
        this.protocol = null;
        super.tearDown();
    }

    @Test
    public void testGenerateCorrespondenceDocumentAndAttach() throws WorkflowException {
        try {
            WithdrawCorrespondence correspondence = new WithdrawCorrespondence();
            Protocol prot = ProtocolFactory.createProtocolDocument().getProtocol();
            ProtocolAction pa = new ProtocolAction();
            ProtocolActionType type = this.getActionType();
            pa.setProtocolActionTypeCode(type.getProtocolActionTypeCode());
            pa.setProtocolActionType((ProtocolActionTypeBase)type);
            prot.getProtocolActions().add(pa);
            prot.setProtocolNumber("123");
            pa.setProtocol((ProtocolBase)prot);
            pa.setActionId(Integer.valueOf(123456));
            pa.setProtocolNumber(prot.getProtocolNumber());
            this.businessObjectService.save((PersistableBusinessObject)prot);
            correspondence.setProtocol((ProtocolBase)prot);
            this.protocolActionCorrespondenceGenerationService.generateCorrespondenceDocumentAndAttach((ProtocolActionsCorrespondenceBase)correspondence);
            ProtocolActionCorrespondenceGenerationServiceTest.assertTrue((boolean)true);
        }
        catch (PrintingException e) {
            ProtocolActionCorrespondenceGenerationServiceTest.assertTrue((boolean)false);
        }
    }

    private ProtocolActionType getActionType() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("PROTOCOL_ACTION_TYPE_CODE", "100");
        return (ProtocolActionType)this.businessObjectService.findByPrimaryKey(ProtocolActionType.class, fieldValues);
    }
}

