/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.correspondence;

import java.util.Collection;
import java.util.List;
import org.apache.struts.upload.FormFile;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.actions.correspondence.FormFileMock;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionTypeToCorrespondenceTemplateService;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplate;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplateService;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceType;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolActionTypeToCorrespondenceTemplateServiceTest
extends KcUnitTestBase {
    ProtocolActionTypeToCorrespondenceTemplateService service;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = (ProtocolActionTypeToCorrespondenceTemplateService)KraServiceLocator.getService(ProtocolActionTypeToCorrespondenceTemplateService.class);
        Collection protocolCorrespondenceTypes = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findAll(ProtocolCorrespondenceType.class);
        for (ProtocolCorrespondenceType type : protocolCorrespondenceTypes) {
            FormFileMock file;
            ProtocolCorrespondenceTemplate template;
            if ("Protocol Submission Report #1".equals(type.getDescription())) {
                template = new ProtocolCorrespondenceTemplate();
                template.setFileName("test.xml");
                template.setProtoCorrespTypeCode(type.getProtoCorrespTypeCode());
                file = new FormFileMock();
                template.setTemplateFile((FormFile)file);
                ((ProtocolCorrespondenceTemplateService)KraServiceLocator.getService(ProtocolCorrespondenceTemplateService.class)).addDefaultProtocolCorrespondenceTemplate((ProtocolCorrespondenceTypeBase)type, (ProtocolCorrespondenceTemplateBase)template);
                ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).save((PersistableBusinessObject)template);
                continue;
            }
            if (!"Protocol Submission Report #2".equals(type.getDescription())) continue;
            template = new ProtocolCorrespondenceTemplate();
            template.setFileName("test2.xml");
            template.setProtoCorrespTypeCode(type.getProtoCorrespTypeCode());
            file = new FormFileMock();
            template.setTemplateFile((FormFile)file);
            ((ProtocolCorrespondenceTemplateService)KraServiceLocator.getService(ProtocolCorrespondenceTemplateService.class)).addDefaultProtocolCorrespondenceTemplate((ProtocolCorrespondenceTypeBase)type, (ProtocolCorrespondenceTemplateBase)template);
            ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).save((PersistableBusinessObject)template);
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
    }

    @Test
    public void testGetTemplatesByProtocolAction1() {
        List result = this.service.getTemplatesByProtocolAction("101");
        ProtocolActionTypeToCorrespondenceTemplateServiceTest.assertTrue((result.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTemplatesByProtocolAction2() {
        List result = this.service.getTemplatesByProtocolAction("113");
        ProtocolActionTypeToCorrespondenceTemplateServiceTest.assertTrue((result.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTemplatesByProtocolAction3() {
        boolean didError = false;
        try {
            List result = this.service.getTemplatesByProtocolAction("foobar");
        }
        catch (IllegalArgumentException ae) {
            didError = true;
        }
        ProtocolActionTypeToCorrespondenceTemplateServiceTest.assertTrue((boolean)didError);
    }
}

