/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.decision;

import java.util.ArrayList;
import java.util.Collections;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.kuali.kra.committee.service.CommitteeScheduleAttendanceService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.decision.CommitteeDecision;
import org.kuali.kra.irb.actions.decision.CommitteePerson;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsBean;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public abstract class CommitteeDecisionRuleBase
extends KcUnitTestBase {
    protected static final Integer YES_COUNT = 2;
    protected static final Integer NO_COUNT = 0;
    protected static final Integer ABSTAIN_COUNT = 1;
    protected static final Integer RECUSED_COUNT = 1;
    protected static final String VOTING_COMMENTS = "just some dumb comments";
    protected static final String REVIEW_COMMENTS = "More dumb comments";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    protected CommitteeScheduleAttendanceService getMockCommitteeScheduleAttendanceService(final Integer yesCount, final Integer noCount) {
        final CommitteeScheduleAttendanceService service = (CommitteeScheduleAttendanceService)this.context.mock(CommitteeScheduleAttendanceService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeScheduleAttendanceService)this.allowing(service)).getActualVotingMembersCount(null, null);
                this.will(2.returnValue((Object)((yesCount != null ? yesCount : 0) + (noCount != null ? noCount : 0) + ABSTAIN_COUNT + RECUSED_COUNT)));
            }
        });
        return service;
    }

    protected CommitteeDecision getMockCommitteeDecisionBean(final String motionTypeCode, final Integer yesCount, final Integer noCount, final CommitteePerson newAbstainer, final CommitteePerson newRecused, final Protocol protocol, final boolean hasReviewComment) {
        final CommitteeDecision bean = (CommitteeDecision)this.context.mock(CommitteeDecision.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeDecision)this.allowing(bean)).getProtocol();
                this.will(3.returnValue((Object)protocol));
                ((CommitteeDecision)this.allowing(bean)).getMotionTypeCode();
                this.will(3.returnValue((Object)motionTypeCode));
                ((CommitteeDecision)this.allowing(bean)).getYesCount();
                this.will(3.returnValue((Object)yesCount));
                ((CommitteeDecision)this.allowing(bean)).getNoCount();
                this.will(3.returnValue((Object)noCount));
                ((CommitteeDecision)this.allowing(bean)).getAbstainCount();
                this.will(3.returnValue((Object)ABSTAIN_COUNT));
                ((CommitteeDecision)this.allowing(bean)).getRecusedCount();
                this.will(3.returnValue((Object)RECUSED_COUNT));
                ((CommitteeDecision)this.allowing(bean)).getVotingComments();
                this.will(3.returnValue((Object)CommitteeDecisionRuleBase.VOTING_COMMENTS));
                ((CommitteeDecision)this.allowing(bean)).getNewAbstainer();
                this.will(3.returnValue((Object)newAbstainer));
                ((CommitteeDecision)this.allowing(bean)).getNewRecused();
                this.will(3.returnValue((Object)newRecused));
                ((CommitteeDecision)this.allowing(bean)).getAbstainers();
                this.will(3.returnValue(Collections.singletonList(CommitteeDecisionRuleBase.this.getBasicAbstainer())));
                ((CommitteeDecision)this.allowing(bean)).getRecused();
                this.will(3.returnValue(Collections.singletonList(CommitteeDecisionRuleBase.this.getBasicRecused())));
                ((CommitteeDecision)this.allowing(bean)).getAbstainersToDelete();
                this.will(3.returnValue(new ArrayList()));
                ((CommitteeDecision)this.allowing(bean)).getRecusedToDelete();
                this.will(3.returnValue(new ArrayList()));
                ((CommitteeDecision)this.allowing(bean)).getTotalVoteCount();
                this.will(3.returnValue((Object)((yesCount != null ? yesCount : 0) + (noCount != null ? noCount : 0) + ABSTAIN_COUNT + RECUSED_COUNT)));
                ((CommitteeDecision)this.allowing(bean)).getReviewCommentsBean();
                this.will(3.returnValue((Object)CommitteeDecisionRuleBase.this.getMockReviewCommentsBean(protocol, hasReviewComment)));
                ((CommitteeDecision)this.allowing(bean)).getYesCountValue();
                this.will(3.returnValue((Object)(yesCount != null ? yesCount : 0)));
                ((CommitteeDecision)this.allowing(bean)).getNoCountValue();
                this.will(3.returnValue((Object)(noCount != null ? noCount : 0)));
            }
        });
        return bean;
    }

    private ReviewCommentsBean getMockReviewCommentsBean(final Protocol protocol, final boolean hasReviewComment) {
        final ReviewCommentsBean bean = (ReviewCommentsBean)this.context.mock(ReviewCommentsBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ReviewCommentsBean)this.allowing(bean)).getReviewComments();
                this.will(4.returnValue((Object)(hasReviewComment ? Collections.singletonList(CommitteeDecisionRuleBase.this.getBasicReviewComment(protocol)) : Collections.EMPTY_LIST)));
            }
        });
        return bean;
    }

    protected CommitteePerson getBasicAbstainer() {
        CommitteePerson person = new CommitteePerson();
        person.setMembershipId(new Long(1L));
        return person;
    }

    protected CommitteePerson getBasicRecused() {
        CommitteePerson person = new CommitteePerson();
        person.setMembershipId(new Long(2L));
        return person;
    }

    protected CommitteePerson getBasicPerson() {
        CommitteePerson person = new CommitteePerson();
        person.setMembershipId(new Long(3L));
        return person;
    }

    private CommitteeScheduleMinute getBasicReviewComment(Protocol protocol) {
        CommitteeScheduleMinute minute = new CommitteeScheduleMinute();
        minute.setProtocolIdFk(protocol.getProtocolId());
        minute.setProtocol((ProtocolBase)protocol);
        minute.setMinuteEntryTypeCode("3");
        minute.setMinuteEntry(REVIEW_COMMENTS);
        return minute;
    }
}

