/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.decision;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.common.committee.service.CommitteeScheduleAttendanceServiceBase;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.decision.CommitteeDecision;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionRule;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionRuleBase;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolDocumentBase;

public class CommitteeDecisionRuleTest
extends CommitteeDecisionRuleBase {
    private CommitteeDecisionRule rule;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new CommitteeDecisionRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testValidApprove() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("1", YES_COUNT, NO_COUNT, null, null, protocolDocument.getProtocol(), false);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(YES_COUNT, NO_COUNT));
        CommitteeDecisionRuleTest.assertTrue((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }

    @Test
    public void testInvalidApprove() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("1", null, NO_COUNT, null, null, protocolDocument.getProtocol(), false);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(null, NO_COUNT));
        CommitteeDecisionRuleTest.assertFalse((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }

    @Test
    public void testValidDisapprove() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("2", YES_COUNT, null, null, null, protocolDocument.getProtocol(), true);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(YES_COUNT, 5));
        CommitteeDecisionRuleTest.assertTrue((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }

    @Test
    public void testInvalidDisapprove() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("2", YES_COUNT, null, null, null, protocolDocument.getProtocol(), false);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(YES_COUNT, null));
        CommitteeDecisionRuleTest.assertFalse((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }

    @Test
    public void testValidSMR() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("3", YES_COUNT, NO_COUNT, null, null, protocolDocument.getProtocol(), true);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(YES_COUNT, NO_COUNT));
        CommitteeDecisionRuleTest.assertTrue((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }

    @Test
    public void testInvalidSMR() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("3", YES_COUNT, NO_COUNT, null, null, protocolDocument.getProtocol(), false);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(YES_COUNT, NO_COUNT));
        CommitteeDecisionRuleTest.assertFalse((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }

    @Test
    public void testValidSRR() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("4", YES_COUNT, NO_COUNT, null, null, protocolDocument.getProtocol(), true);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(YES_COUNT, NO_COUNT));
        CommitteeDecisionRuleTest.assertTrue((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }

    @Test
    public void testInvalidSRR() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDecision decision = this.getMockCommitteeDecisionBean("4", YES_COUNT, NO_COUNT, null, null, protocolDocument.getProtocol(), false);
        this.rule.setAttendanceService((CommitteeScheduleAttendanceServiceBase)this.getMockCommitteeScheduleAttendanceService(YES_COUNT, NO_COUNT));
        CommitteeDecisionRuleTest.assertFalse((boolean)this.rule.proccessCommitteeDecisionRule((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)decision));
    }
}

