/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.decision;

import java.util.ArrayList;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedService;
import org.kuali.kra.irb.actions.decision.CommitteeDecision;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionServiceImpl;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsBean;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class CommitteeDecisionServiceTest
extends KcUnitTestBase {
    private static final Integer YES_COUNT = 2;
    private static final Integer NO_COUNT = 0;
    private static final Integer ABSTAIN_COUNT = 0;
    private static final Integer RECUSED_COUNT = 0;
    private static final String VOTING_COMMENTS = "just some dumb comments";
    private CommitteeDecisionServiceImpl service;
    private ProtocolSubmitActionService protocolSubmitActionService;
    private ProtocolAssignCmtSchedService protocolAssignCmtSchedService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new CommitteeDecisionServiceImpl();
        this.service.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setBusinessObjectService((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class));
        this.service.setCommitteeService((CommitteeServiceBase)this.getMockCommitteeService());
        this.service.setDocumentService(this.getMockDocumentService());
        this.protocolSubmitActionService = (ProtocolSubmitActionService)KraServiceLocator.getService(ProtocolSubmitActionService.class);
        this.protocolAssignCmtSchedService = (ProtocolAssignCmtSchedService)KraServiceLocator.getService(ProtocolAssignCmtSchedService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.protocolSubmitActionService = null;
        this.protocolAssignCmtSchedService = null;
        super.tearDown();
    }

    @Test
    public void testProcessApproveCommitteeDecision() throws Exception {
        Protocol protocol = this.getProtocolAssignedToAgenda();
        CommitteeDecision committeeDecision = this.getMockCommitteeDecisionBean("1");
        this.service.processCommitteeDecision((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)committeeDecision);
        ProtocolAction lastAction = protocol.getLastProtocolAction();
        CommitteeDecisionServiceTest.assertNotNull((Object)lastAction);
        CommitteeDecisionServiceTest.assertEquals((Object)"308", (Object)lastAction.getProtocolActionTypeCode());
        ProtocolSubmission submission = protocol.getProtocolSubmission();
        CommitteeDecisionServiceTest.assertNotNull((Object)submission);
        CommitteeDecisionServiceTest.assertEquals((Object)"1", (Object)submission.getCommitteeDecisionMotionTypeCode());
        CommitteeDecisionServiceTest.assertEquals((Object)YES_COUNT, (Object)submission.getYesVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)NO_COUNT, (Object)submission.getNoVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)ABSTAIN_COUNT, (Object)submission.getAbstainerCount());
        CommitteeDecisionServiceTest.assertEquals((Object)RECUSED_COUNT, (Object)submission.getRecusedCount());
        CommitteeDecisionServiceTest.assertEquals((Object)VOTING_COMMENTS, (Object)submission.getVotingComments());
    }

    @Test
    public void testProcessDisapproveCommitteeDecision() throws Exception {
        Protocol protocol = this.getProtocolAssignedToAgenda();
        CommitteeDecision committeeDecision = this.getMockCommitteeDecisionBean("2");
        this.service.processCommitteeDecision((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)committeeDecision);
        ProtocolAction lastAction = protocol.getLastProtocolAction();
        CommitteeDecisionServiceTest.assertNotNull((Object)lastAction);
        CommitteeDecisionServiceTest.assertEquals((Object)"308", (Object)lastAction.getProtocolActionTypeCode());
        ProtocolSubmission submission = protocol.getProtocolSubmission();
        CommitteeDecisionServiceTest.assertNotNull((Object)submission);
        CommitteeDecisionServiceTest.assertEquals((Object)"2", (Object)submission.getCommitteeDecisionMotionTypeCode());
        CommitteeDecisionServiceTest.assertEquals((Object)YES_COUNT, (Object)submission.getYesVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)NO_COUNT, (Object)submission.getNoVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)ABSTAIN_COUNT, (Object)submission.getAbstainerCount());
        CommitteeDecisionServiceTest.assertEquals((Object)RECUSED_COUNT, (Object)submission.getRecusedCount());
        CommitteeDecisionServiceTest.assertEquals((Object)VOTING_COMMENTS, (Object)submission.getVotingComments());
    }

    @Test
    public void testProcessSMRCommitteeDecision() throws Exception {
        Protocol protocol = this.getProtocolAssignedToAgenda();
        CommitteeDecision committeeDecision = this.getMockCommitteeDecisionBean("3");
        this.service.processCommitteeDecision((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)committeeDecision);
        ProtocolAction lastAction = protocol.getLastProtocolAction();
        CommitteeDecisionServiceTest.assertNotNull((Object)lastAction);
        CommitteeDecisionServiceTest.assertEquals((Object)"308", (Object)lastAction.getProtocolActionTypeCode());
        ProtocolSubmission submission = protocol.getProtocolSubmission();
        CommitteeDecisionServiceTest.assertNotNull((Object)submission);
        CommitteeDecisionServiceTest.assertEquals((Object)"3", (Object)submission.getCommitteeDecisionMotionTypeCode());
        CommitteeDecisionServiceTest.assertEquals((Object)YES_COUNT, (Object)submission.getYesVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)NO_COUNT, (Object)submission.getNoVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)ABSTAIN_COUNT, (Object)submission.getAbstainerCount());
        CommitteeDecisionServiceTest.assertEquals((Object)RECUSED_COUNT, (Object)submission.getRecusedCount());
        CommitteeDecisionServiceTest.assertEquals((Object)VOTING_COMMENTS, (Object)submission.getVotingComments());
    }

    @Test
    public void testProcessSRRCommitteeDecision() throws Exception {
        Protocol protocol = this.getProtocolAssignedToAgenda();
        CommitteeDecision committeeDecision = this.getMockCommitteeDecisionBean("4");
        this.service.processCommitteeDecision((ProtocolBase)protocol, (org.kuali.kra.protocol.actions.decision.CommitteeDecision)committeeDecision);
        ProtocolAction lastAction = protocol.getLastProtocolAction();
        CommitteeDecisionServiceTest.assertNotNull((Object)lastAction);
        CommitteeDecisionServiceTest.assertEquals((Object)"308", (Object)lastAction.getProtocolActionTypeCode());
        ProtocolSubmission submission = protocol.getProtocolSubmission();
        CommitteeDecisionServiceTest.assertNotNull((Object)submission);
        CommitteeDecisionServiceTest.assertEquals((Object)"4", (Object)submission.getCommitteeDecisionMotionTypeCode());
        CommitteeDecisionServiceTest.assertEquals((Object)YES_COUNT, (Object)submission.getYesVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)NO_COUNT, (Object)submission.getNoVoteCount());
        CommitteeDecisionServiceTest.assertEquals((Object)ABSTAIN_COUNT, (Object)submission.getAbstainerCount());
        CommitteeDecisionServiceTest.assertEquals((Object)RECUSED_COUNT, (Object)submission.getRecusedCount());
        CommitteeDecisionServiceTest.assertEquals((Object)VOTING_COMMENTS, (Object)submission.getVotingComments());
    }

    private Protocol getProtocolAssignedToAgenda() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), this.getMockSubmitAction());
        CommitteeDecisionServiceTest.assertEquals((Object)"101", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        this.protocolAssignCmtSchedService.assignToCommitteeAndSchedule(protocolDocument.getProtocol(), this.getMockAssignCmtSchedBean());
        CommitteeDecisionServiceTest.assertEquals((Object)"100", (Object)protocolDocument.getProtocol().getProtocolSubmission().getSubmissionStatusCode());
        return protocolDocument.getProtocol();
    }

    private ProtocolSubmitAction getMockSubmitAction() {
        final ProtocolSubmitAction action = (ProtocolSubmitAction)this.context.mock(ProtocolSubmitAction.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionTypeCode();
                this.will(2.returnValue((Object)"100"));
                ((ProtocolSubmitAction)this.allowing(action)).getProtocolReviewTypeCode();
                this.will(2.returnValue((Object)"1"));
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionQualifierTypeCode();
                this.will(2.returnValue((Object)"2"));
                ((ProtocolSubmitAction)this.allowing(action)).getNewCommitteeId();
                this.will(2.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getNewScheduleId();
                this.will(2.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getReviewers();
                this.will(2.returnValue(new ArrayList()));
            }
        });
        return action;
    }

    private ProtocolAssignCmtSchedBean getMockAssignCmtSchedBean() {
        final ProtocolAssignCmtSchedBean bean = (ProtocolAssignCmtSchedBean)this.context.mock(ProtocolAssignCmtSchedBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAssignCmtSchedBean)this.allowing(bean)).getNewCommitteeId();
                this.will(3.returnValue((Object)""));
                ((ProtocolAssignCmtSchedBean)this.allowing(bean)).getNewScheduleId();
                this.will(3.returnValue((Object)""));
                ((ProtocolAssignCmtSchedBean)this.allowing(bean)).scheduleHasChanged();
                this.will(3.returnValue((Object)false));
            }
        });
        return bean;
    }

    private CommitteeService getMockCommitteeService() {
        final CommitteeService service = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(service)).getAvailableMembers(null, null);
                this.will(4.returnValue(new ArrayList()));
            }
        });
        return service;
    }

    private DocumentService getMockDocumentService() {
        final DocumentService service = (DocumentService)this.context.mock(DocumentService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private CommitteeDecision getMockCommitteeDecisionBean(final String motionTypeCode) {
        final CommitteeDecision bean = (CommitteeDecision)this.context.mock(CommitteeDecision.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeDecision)this.allowing(bean)).getMotionTypeCode();
                this.will(6.returnValue((Object)motionTypeCode));
                ((CommitteeDecision)this.allowing(bean)).getYesCount();
                this.will(6.returnValue((Object)YES_COUNT));
                ((CommitteeDecision)this.allowing(bean)).getNoCount();
                this.will(6.returnValue((Object)NO_COUNT));
                ((CommitteeDecision)this.allowing(bean)).getAbstainCount();
                this.will(6.returnValue((Object)ABSTAIN_COUNT));
                ((CommitteeDecision)this.allowing(bean)).getRecusedCount();
                this.will(6.returnValue((Object)RECUSED_COUNT));
                ((CommitteeDecision)this.allowing(bean)).getVotingComments();
                this.will(6.returnValue((Object)CommitteeDecisionServiceTest.VOTING_COMMENTS));
                ((CommitteeDecision)this.allowing(bean)).getAbstainers();
                this.will(6.returnValue(new ArrayList()));
                ((CommitteeDecision)this.allowing(bean)).getRecused();
                this.will(6.returnValue(new ArrayList()));
                ((CommitteeDecision)this.allowing(bean)).getAbstainersToDelete();
                this.will(6.returnValue(new ArrayList()));
                ((CommitteeDecision)this.allowing(bean)).getRecusedToDelete();
                this.will(6.returnValue(new ArrayList()));
                ((CommitteeDecision)this.allowing(bean)).getReviewCommentsBean();
                this.will(6.returnValue((Object)new ReviewCommentsBean("")));
            }
        });
        return bean;
    }
}

