/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.delete;

import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.actions.delete.ProtocolDeleteBean;
import org.kuali.kra.irb.actions.delete.ProtocolDeleteService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class ProtocolDeleteServiceTest
extends KcUnitTestBase {
    private static final String REASON = "my test reason";
    private static final String SUMMARY = "summary";
    private ProtocolDeleteService service;
    private ProtocolAmendRenewService protocolAmendRenewService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = (ProtocolDeleteService)KraServiceLocator.getService(ProtocolDeleteService.class);
        this.protocolAmendRenewService = (ProtocolAmendRenewService)KraServiceLocator.getService(ProtocolAmendRenewService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.protocolAmendRenewService = null;
        super.tearDown();
    }

    @Test
    public void testDelete() throws WorkflowException {
        ProtocolDeleteBean protocolDeleteBean = this.getMockProtocolDeleteBean();
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.service.delete((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.delete.ProtocolDeleteBean)protocolDeleteBean);
        ProtocolDeleteServiceTest.assertFalse((boolean)protocolDocument.getProtocol().isActive());
        ProtocolDeleteServiceTest.assertEquals((Object)"303", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
    }

    @Test
    public void testDeleteAmendment() throws Exception {
        ProtocolAmendmentBean protocolAmendmentBean = this.getMockProtocolAmendmentBean();
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        String docNbr = this.protocolAmendRenewService.createAmendment((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean)protocolAmendmentBean);
        ProtocolDocument amendmentDocument = (ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(docNbr);
        List modules = this.protocolAmendRenewService.getAvailableModules(protocolDocument.getProtocol().getProtocolNumber());
        ProtocolDeleteServiceTest.assertEquals((long)10L, (long)modules.size());
        ProtocolDeleteBean protocolDeleteBean = this.getMockProtocolDeleteBean();
        this.service.delete((ProtocolBase)amendmentDocument.getProtocol(), (org.kuali.kra.protocol.actions.delete.ProtocolDeleteBean)protocolDeleteBean);
        modules = this.protocolAmendRenewService.getAvailableModules(protocolDocument.getProtocol().getProtocolNumber());
        ProtocolDeleteServiceTest.assertEquals((long)12L, (long)modules.size());
    }

    private ProtocolDeleteBean getMockProtocolDeleteBean() {
        final ProtocolDeleteBean bean = (ProtocolDeleteBean)this.context.mock(ProtocolDeleteBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolDeleteBean)this.allowing(bean)).getReason();
                this.will(2.returnValue((Object)ProtocolDeleteServiceTest.REASON));
            }
        });
        return bean;
    }

    private ProtocolAmendmentBean getMockProtocolAmendmentBean() {
        final ProtocolAmendmentBean bean = (ProtocolAmendmentBean)this.context.mock(ProtocolAmendmentBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAmendmentBean)this.allowing(bean)).getSummary();
                this.will(3.returnValue((Object)ProtocolDeleteServiceTest.SUMMARY));
                ((ProtocolAmendmentBean)this.allowing(bean)).getGeneralInfo();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getFundingSource();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolReferencesAndOtherIdentifiers();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolOrganizations();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getSubjects();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getAddModifyAttachments();
                this.will(3.returnValue((Object)true));
                ((ProtocolAmendmentBean)this.allowing(bean)).getAreasOfResearch();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getSpecialReview();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolPersonnel();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getOthers();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolPermissions();
                this.will(3.returnValue((Object)true));
                ((ProtocolAmendmentBean)this.allowing(bean)).getQuestionnaire();
                this.will(3.returnValue((Object)false));
            }
        });
        return bean;
    }
}

