/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.genericactions;

import java.sql.Date;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Test;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionEvent;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;

public class ProtocolGenericActionRuleTest
extends ProtocolRuleTestBase {
    private static final Date ACTION_DATE = new Date(System.currentTimeMillis());
    private static final String ACTION_DATE_FIELD = "actionDate";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Test
    public void testOk() {
        new TemplateRuleTest<ProtocolGenericActionEvent, ProtocolGenericActionRule>(){

            @Override
            protected void prerequisite() {
                ProtocolGenericActionBean bean = ProtocolGenericActionRuleTest.this.getMockProtocolGenericActionBean(ACTION_DATE);
                this.event = new ProtocolGenericActionEvent(null, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)bean);
                this.rule = new ProtocolGenericActionRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testNoActionDate() {
        new TemplateRuleTest<ProtocolGenericActionEvent, ProtocolGenericActionRule>(){

            @Override
            protected void prerequisite() {
                ProtocolGenericActionBean bean = ProtocolGenericActionRuleTest.this.getMockProtocolGenericActionBean(null);
                this.event = new ProtocolGenericActionEvent(null, (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)bean);
                this.rule = new ProtocolGenericActionRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolGenericActionRuleTest.this.assertError(ProtocolGenericActionRuleTest.ACTION_DATE_FIELD, "error.protocol.generic.actionDate.required");
            }
        };
    }

    private ProtocolGenericActionBean getMockProtocolGenericActionBean(final Date actionDate) {
        final ProtocolGenericActionBean bean = (ProtocolGenericActionBean)this.context.mock(ProtocolGenericActionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolGenericActionBean)this.allowing(bean)).getActionDate();
                this.will(4.returnValue((Object)actionDate));
                ((ProtocolGenericActionBean)this.allowing(bean)).getErrorPropertyKey();
                this.will(4.returnValue((Object)"actionHelper.protocolCloseBean"));
            }
        });
        return bean;
    }
}

