/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.genericactions;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolVersionService;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolGenericActionsServiceTest
extends KcUnitTestBase {
    private static final String BASIC_COMMENT = "some dummy comments here";
    private static final Date BASIC_ACTION_DATE = new Date(System.currentTimeMillis());
    private ProtocolGenericActionServiceImpl service;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolGenericActionServiceImpl();
        this.service.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setDocumentService((DocumentService)KraServiceLocator.getService(DocumentService.class));
        this.service.setProtocolActionCorrespondenceGenerationService((ProtocolActionCorrespondenceGenerationService)this.getMockProtocolActionCorrespondenceGenerationService());
        this.service.setProtocolOnlineReviewService((org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService)this.getMockProtocolOnlineReviewService());
        this.service.setProtocolVersionService((org.kuali.kra.protocol.ProtocolVersionService)KraServiceLocator.getService(ProtocolVersionService.class));
        this.service.setKcNotificationService(this.getMockKcNotificationService());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testClosedByPI() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolActionType prevType = new ProtocolActionType();
        prevType.setProtocolActionTypeCode("105");
        ProtocolAction pa = new ProtocolAction();
        pa.setProtocolActionType((ProtocolActionTypeBase)prevType);
        pa.setProtocolActionTypeCode(prevType.getProtocolActionTypeCode());
        pa.setProtocolId(protocolDocument.getProtocol().getProtocolId());
        pa.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
        pa.setActionId(Integer.valueOf(123));
        pa.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        protocolDocument.getProtocol().getProtocolActions().add(pa);
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.close(protocolDocument.getProtocol(), actionBean);
        String expected = "301";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testClosedAdministratively() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolActionType prevType = new ProtocolActionType();
        prevType.setProtocolActionTypeCode("204");
        ProtocolAction pa = new ProtocolAction();
        pa.setProtocolActionType((ProtocolActionTypeBase)prevType);
        pa.setProtocolActionTypeCode(prevType.getProtocolActionTypeCode());
        pa.setProtocolId(protocolDocument.getProtocol().getProtocolId());
        pa.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
        pa.setActionId(Integer.valueOf(1234));
        pa.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        protocolDocument.getProtocol().getProtocolActions().add(pa);
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.close(protocolDocument.getProtocol(), actionBean);
        String expected = "300";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testCloseEnrollment() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.closeEnrollment(protocolDocument.getProtocol(), actionBean);
        String expected = "201";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testExpire() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.expire((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean);
        String expected = "305";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testIrbAcknowledgement() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmissionType prevSubmissionType = new ProtocolSubmissionType();
        prevSubmissionType.setSubmissionTypeCode("100");
        ProtocolReviewType prevReviewType = new ProtocolReviewType();
        prevReviewType.setReviewTypeCode("1");
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocolSubmissionType((ProtocolSubmissionTypeBase)prevSubmissionType);
        submission.setSubmissionTypeCode(prevSubmissionType.getSubmissionTypeCode());
        submission.setProtocolReviewType((ProtocolReviewTypeBase)prevReviewType);
        submission.setProtocolReviewTypeCode(prevReviewType.getReviewTypeCode());
        submission.setProtocolId(protocolDocument.getProtocol().getProtocolId());
        submission.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
        submission.setSubmissionId(Long.valueOf(1234L));
        submission.setSubmissionNumber(Integer.valueOf(1));
        submission.setSubmissionDate(new Date(System.currentTimeMillis()));
        protocolDocument.getProtocol().getProtocolSubmissions().add(submission);
        submission.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.irbAcknowledgement(protocolDocument.getProtocol(), actionBean);
        String expected = "212";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolSubmission().getSubmissionStatusCode());
    }

    @Test
    public void testPermitDataAnalysis() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.permitDataAnalysis(protocolDocument.getProtocol(), actionBean);
        String expected = "202";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testReopen() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.reopenEnrollment(protocolDocument.getProtocol(), actionBean);
        String expected = "200";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testSuspendByPI() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolActionType prevType = new ProtocolActionType();
        prevType.setProtocolActionTypeCode("106");
        ProtocolAction pa = new ProtocolAction();
        pa.setProtocolActionType((ProtocolActionTypeBase)prevType);
        pa.setProtocolActionTypeCode(prevType.getProtocolActionTypeCode());
        pa.setProtocolId(protocolDocument.getProtocol().getProtocolId());
        pa.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
        pa.setActionId(Integer.valueOf(123));
        pa.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        protocolDocument.getProtocol().getProtocolActions().add(pa);
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.suspend((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean);
        String expected = "302";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testSuspendByIRB() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolActionType prevType = new ProtocolActionType();
        prevType.setProtocolActionTypeCode("204");
        ProtocolAction pa = new ProtocolAction();
        pa.setProtocolActionType((ProtocolActionTypeBase)prevType);
        pa.setProtocolActionTypeCode(prevType.getProtocolActionTypeCode());
        pa.setProtocolId(protocolDocument.getProtocol().getProtocolId());
        pa.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
        pa.setActionId(Integer.valueOf(1234));
        pa.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        protocolDocument.getProtocol().getProtocolActions().add(pa);
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.suspend((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean);
        String expected = "308";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testSuspendByDsmb() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.suspendByDsmb(protocolDocument.getProtocol(), actionBean);
        String expected = "311";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testTerminate() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.terminate((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean);
        String expected = "307";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
    }

    @Test
    public void testDisapprove() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmitActionService protocolSubmitActionService = (ProtocolSubmitActionService)KraServiceLocator.getService(ProtocolSubmitActionService.class);
        protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), this.getMockProtocolSubmitAction());
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        documentService.routeDocument((Document)protocolDocument.getProtocol().getProtocolDocument(), "Initial Document Route", new ArrayList());
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        this.service.disapprove((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean);
        String expected = "306";
        ProtocolGenericActionsServiceTest.assertEquals((Object)expected, (Object)protocolDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
        ProtocolGenericActionsServiceTest.assertTrue((boolean)protocolDocument.getProtocol().getProtocolDocument().getDocumentHeader().getWorkflowDocument().isDisapproved());
    }

    @Test
    public void testReturnForSMR() throws Exception {
        ProtocolDocument oldDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        ProtocolDocument newDocument = this.service.returnForSMR((ProtocolBase)oldDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean);
        String expectedStatus = "102";
        String unexpectedDocumentNumber = oldDocument.getDocumentNumber();
        ProtocolGenericActionsServiceTest.assertEquals((Object)expectedStatus, (Object)newDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
        ProtocolGenericActionsServiceTest.assertTrue((boolean)oldDocument.getDocumentHeader().getWorkflowDocument().isCanceled());
        ProtocolGenericActionsServiceTest.assertNotSame((Object)unexpectedDocumentNumber, (Object)newDocument.getDocumentNumber());
    }

    @Test
    public void testReturnForSRR() throws Exception {
        ProtocolDocument oldDocument = ProtocolFactory.createProtocolDocument();
        ProtocolGenericActionBean actionBean = this.getMockProtocolGenericActionBean();
        ProtocolDocument newDocument = this.service.returnForSRR((ProtocolBase)oldDocument.getProtocol(), (org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionBean)actionBean);
        String expectedStatus = "104";
        String unexpectedDocumentNumber = oldDocument.getDocumentNumber();
        ProtocolGenericActionsServiceTest.assertEquals((Object)expectedStatus, (Object)newDocument.getProtocol().getProtocolStatus().getProtocolStatusCode());
        ProtocolGenericActionsServiceTest.assertTrue((boolean)oldDocument.getDocumentHeader().getWorkflowDocument().isCanceled());
        ProtocolGenericActionsServiceTest.assertNotSame((Object)unexpectedDocumentNumber, (Object)newDocument.getDocumentNumber());
    }

    private org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService getMockProtocolActionCorrespondenceGenerationService() {
        final org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService service = (org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService)this.context.mock(org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolOnlineReviewService getMockProtocolOnlineReviewService() {
        final ProtocolOnlineReviewService service = (ProtocolOnlineReviewService)this.context.mock(ProtocolOnlineReviewService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolGenericActionBean getMockProtocolGenericActionBean() {
        final ProtocolGenericActionBean bean = (ProtocolGenericActionBean)this.context.mock(ProtocolGenericActionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolGenericActionBean)this.allowing(bean)).getComments();
                this.will(4.returnValue((Object)ProtocolGenericActionsServiceTest.BASIC_COMMENT));
                ((ProtocolGenericActionBean)this.allowing(bean)).getActionDate();
                this.will(4.returnValue((Object)BASIC_ACTION_DATE));
            }
        });
        return bean;
    }

    private ProtocolSubmitAction getMockProtocolSubmitAction() {
        final ProtocolSubmitAction action = (ProtocolSubmitAction)this.context.mock(ProtocolSubmitAction.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionTypeCode();
                this.will(5.returnValue((Object)"100"));
                ((ProtocolSubmitAction)this.allowing(action)).getProtocolReviewTypeCode();
                this.will(5.returnValue((Object)"1"));
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionQualifierTypeCode();
                this.will(5.returnValue((Object)"2"));
                ((ProtocolSubmitAction)this.allowing(action)).getNewCommitteeId();
                this.will(5.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getNewScheduleId();
                this.will(5.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getReviewers();
                this.will(5.returnValue(new ArrayList()));
            }
        });
        return action;
    }

    private KcNotificationService getMockKcNotificationService() {
        final KcNotificationService service = (KcNotificationService)this.context.mock(KcNotificationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }
}

