/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.grantexemption;

import java.util.Date;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Test;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionBean;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionEvent;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.kra.util.DateUtils;

public class ProtocolGrantExemptionRuleTest
extends ProtocolRuleTestBase {
    private static final java.sql.Date ACTION_DATE = new java.sql.Date(System.currentTimeMillis());
    private static final java.sql.Date APPROVAL_DATE = DateUtils.convertToSqlDate((Date)DateUtils.addWeeks((Date)ACTION_DATE, (int)-1));
    private static final String APPROVAL_DATE_FIELD = "approvalDate";
    private static final String ACTION_DATE_FIELD = "actionDate";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Test
    public void testOk() {
        new TemplateRuleTest<ProtocolGrantExemptionEvent, ProtocolGrantExemptionRule>(){

            @Override
            protected void prerequisite() {
                ProtocolGrantExemptionBean bean = ProtocolGrantExemptionRuleTest.this.getMockProtocolGrantExemptionBean(APPROVAL_DATE, ACTION_DATE);
                this.event = new ProtocolGrantExemptionEvent(null, bean);
                this.rule = new ProtocolGrantExemptionRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testNoApprovalDate() {
        new TemplateRuleTest<ProtocolGrantExemptionEvent, ProtocolGrantExemptionRule>(){

            @Override
            protected void prerequisite() {
                ProtocolGrantExemptionBean bean = ProtocolGrantExemptionRuleTest.this.getMockProtocolGrantExemptionBean(null, ACTION_DATE);
                this.event = new ProtocolGrantExemptionEvent(null, bean);
                this.rule = new ProtocolGrantExemptionRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolGrantExemptionRuleTest.this.assertError(ProtocolGrantExemptionRuleTest.APPROVAL_DATE_FIELD, "error.protocol.approve.approveDate.required");
            }
        };
    }

    @Test
    public void testNoActionDate() {
        new TemplateRuleTest<ProtocolGrantExemptionEvent, ProtocolGrantExemptionRule>(){

            @Override
            protected void prerequisite() {
                ProtocolGrantExemptionBean bean = ProtocolGrantExemptionRuleTest.this.getMockProtocolGrantExemptionBean(APPROVAL_DATE, null);
                this.event = new ProtocolGrantExemptionEvent(null, bean);
                this.rule = new ProtocolGrantExemptionRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolGrantExemptionRuleTest.this.assertError(ProtocolGrantExemptionRuleTest.ACTION_DATE_FIELD, "error.protocol.generic.actionDate.required");
            }
        };
    }

    private ProtocolGrantExemptionBean getMockProtocolGrantExemptionBean(final java.sql.Date approvalDate, final java.sql.Date actionDate) {
        final ProtocolGrantExemptionBean bean = (ProtocolGrantExemptionBean)this.context.mock(ProtocolGrantExemptionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolGrantExemptionBean)this.allowing(bean)).getApprovalDate();
                this.will(5.returnValue((Object)approvalDate));
                ((ProtocolGrantExemptionBean)this.allowing(bean)).getActionDate();
                this.will(5.returnValue((Object)actionDate));
                ((ProtocolGrantExemptionBean)this.allowing(bean)).getErrorPropertyKey();
                this.will(5.returnValue((Object)"actionHelper.protocolGrantExemptionBean"));
            }
        });
        return bean;
    }
}

