/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.grantexemption;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.grantexemption.GrantExemptionCorrespondence;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionBean;
import org.kuali.kra.irb.actions.grantexemption.ProtocolGrantExemptionServiceImpl;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolGrantExemptionServiceTest
extends KcUnitTestBase {
    private static final Date ACTION_DATE = new Date(System.currentTimeMillis());
    private static final Date APPROVAL_DATE = DateUtils.convertToSqlDate((java.util.Date)DateUtils.addWeeks((java.util.Date)ACTION_DATE, (int)-1));
    private static final String COMMENTS = "something silly";
    private static final String VALID_EXEMPT_STUDIES_ITEM_CODE = "1";
    private ProtocolGrantExemptionServiceImpl service;
    private ProtocolSubmitActionService protocolSubmitActionService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolGrantExemptionServiceImpl();
        this.service.setProtocolActionService((ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setDocumentService(this.getMockDocumentService());
        this.service.setProtocolActionCorrespondenceGenerationService(this.getMockActionCorrespondenceGenerationService());
        this.protocolSubmitActionService = (ProtocolSubmitActionService)KraServiceLocator.getService(ProtocolSubmitActionService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.protocolSubmitActionService = null;
        super.tearDown();
    }

    @Test
    public void testGrantExemption() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), this.getMockSubmitAction());
        ProtocolGrantExemptionServiceTest.assertEquals((Object)"101", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        this.service.grantExemption(protocolDocument.getProtocol(), this.getMockGrantExemptionBean());
        ProtocolGrantExemptionServiceTest.assertEquals((Object)"203", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        ProtocolGrantExemptionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocolDocument.getProtocol().getLastProtocolAction();
        ProtocolGrantExemptionServiceTest.assertNotNull((Object)action);
        ProtocolGrantExemptionServiceTest.assertEquals((Object)APPROVAL_DATE, (Object)protocolDocument.getProtocol().getApprovalDate());
        ProtocolGrantExemptionServiceTest.assertEquals((Object)COMMENTS, (Object)action.getComments());
        ProtocolGrantExemptionServiceTest.assertEquals((Object)ACTION_DATE, (Object)action.getActionDate());
        ProtocolGrantExemptionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        ProtocolGrantExemptionServiceTest.assertNotNull((Object)submission);
        ProtocolGrantExemptionServiceTest.assertEquals((Object)"204", (Object)submission.getSubmissionStatusCode());
    }

    private ProtocolSubmitAction getMockSubmitAction() {
        final ProtocolSubmitAction action = (ProtocolSubmitAction)this.context.mock(ProtocolSubmitAction.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionTypeCode();
                this.will(2.returnValue((Object)"100"));
                ((ProtocolSubmitAction)this.allowing(action)).getProtocolReviewTypeCode();
                this.will(2.returnValue((Object)"3"));
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionQualifierTypeCode();
                this.will(2.returnValue((Object)"2"));
                ((ProtocolSubmitAction)this.allowing(action)).getNewCommitteeId();
                this.will(2.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getNewScheduleId();
                this.will(2.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getReviewers();
                this.will(2.returnValue(new ArrayList()));
                ((ProtocolSubmitAction)this.allowing(action)).getExemptStudiesCheckList();
                this.will(2.returnValue(Collections.singletonList(ProtocolGrantExemptionServiceTest.this.getMockExemptStudiesCheckListItem())));
            }
        });
        return action;
    }

    private ExemptStudiesCheckListItem getMockExemptStudiesCheckListItem() {
        final ExemptStudiesCheckListItem item = (ExemptStudiesCheckListItem)this.context.mock(ExemptStudiesCheckListItem.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ExemptStudiesCheckListItem)this.allowing(item)).getExemptStudiesCheckListCode();
                this.will(3.returnValue((Object)ProtocolGrantExemptionServiceTest.VALID_EXEMPT_STUDIES_ITEM_CODE));
                ((ExemptStudiesCheckListItem)this.allowing(item)).getChecked();
                this.will(3.returnValue((Object)true));
            }
        });
        return item;
    }

    private ProtocolGrantExemptionBean getMockGrantExemptionBean() {
        final ProtocolGrantExemptionBean bean = (ProtocolGrantExemptionBean)this.context.mock(ProtocolGrantExemptionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolGrantExemptionBean)this.allowing(bean)).getActionDate();
                this.will(4.returnValue((Object)ACTION_DATE));
                ((ProtocolGrantExemptionBean)this.allowing(bean)).getComments();
                this.will(4.returnValue((Object)ProtocolGrantExemptionServiceTest.COMMENTS));
                ((ProtocolGrantExemptionBean)this.allowing(bean)).getApprovalDate();
                this.will(4.returnValue((Object)APPROVAL_DATE));
                ((ProtocolGrantExemptionBean)this.allowing(bean)).getCorrespondence();
                this.will(4.returnValue((Object)new GrantExemptionCorrespondence()));
            }
        });
        return bean;
    }

    private DocumentService getMockDocumentService() {
        final DocumentService service = (DocumentService)this.context.mock(DocumentService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolActionCorrespondenceGenerationService getMockActionCorrespondenceGenerationService() {
        final ProtocolActionCorrespondenceGenerationService service = (ProtocolActionCorrespondenceGenerationService)this.context.mock(ProtocolActionCorrespondenceGenerationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }
}

