/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.history;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.junit.Test;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesEvent;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;

public class ProtocolHistoryFilterDatesRuleTest
extends ProtocolRuleTestBase {
    @Test
    public void testOK() {
        new TemplateRuleTest<ProtocolHistoryFilterDatesEvent, ProtocolHistoryFilterDatesRule>(){

            @Override
            protected void prerequisite() {
                Date startDate = new Date(System.currentTimeMillis());
                Date endDate = new Date(System.currentTimeMillis());
                this.event = new ProtocolHistoryFilterDatesEvent(null, startDate, endDate);
                this.rule = new ProtocolHistoryFilterDatesRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testStartDateNull() {
        new TemplateRuleTest<ProtocolHistoryFilterDatesEvent, ProtocolHistoryFilterDatesRule>(){

            @Override
            protected void prerequisite() {
                Date startDate = null;
                Date endDate = new Date(System.currentTimeMillis());
                this.event = new ProtocolHistoryFilterDatesEvent(null, startDate, endDate);
                this.rule = new ProtocolHistoryFilterDatesRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolHistoryFilterDatesRuleTest.this.assertError("actionHelper.filteredHistoryStartDate", "error.required");
            }
        };
    }

    @Test
    public void testEndDateNull() {
        new TemplateRuleTest<ProtocolHistoryFilterDatesEvent, ProtocolHistoryFilterDatesRule>(){

            @Override
            protected void prerequisite() {
                Date startDate = new Date(System.currentTimeMillis());
                Date endDate = null;
                this.event = new ProtocolHistoryFilterDatesEvent(null, startDate, endDate);
                this.rule = new ProtocolHistoryFilterDatesRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolHistoryFilterDatesRuleTest.this.assertError("actionHelper.filteredHistoryEndDate", "error.required");
            }
        };
    }

    @Test
    public void testEndDateBeforeStartDate() {
        new TemplateRuleTest<ProtocolHistoryFilterDatesEvent, ProtocolHistoryFilterDatesRule>(){

            @Override
            protected void prerequisite() {
                Date startDate = new Date(System.currentTimeMillis());
                Date endDate = DateUtils.addDays((Date)startDate, (int)-1);
                this.event = new ProtocolHistoryFilterDatesEvent(null, startDate, endDate);
                this.rule = new ProtocolHistoryFilterDatesRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolHistoryFilterDatesRuleTest.this.assertError("actionHelper.filteredHistoryStartDate", "error.start.date.after.end.date");
            }
        };
    }
}

