/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.modifysubmission;

import java.util.Collections;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionBean;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionRule;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolModifySubmissionRuleTest
extends KcUnitTestBase {
    private ProtocolModifySubmissionRule rule;
    ProtocolDocument document;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProtocolModifySubmissionRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.document = null;
        super.tearDown();
    }

    @Test
    public void testOK() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("100", "2", "1", false, false);
        ProtocolModifySubmissionRuleTest.assertTrue((boolean)this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean));
    }

    @Test
    public void testEmpty() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("", "", "", false, false);
        ProtocolModifySubmissionRuleTest.assertFalse((boolean)this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean));
        ProtocolModifySubmissionRuleTest.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testExpeditedOK() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("100", "2", "2", true, false);
        boolean result = this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean);
        ProtocolModifySubmissionRuleTest.assertTrue((boolean)result);
    }

    @Test
    public void testExpeditedNothingChecked() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("100", "2", "2", false, false);
        ProtocolModifySubmissionRuleTest.assertFalse((boolean)this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean));
        ProtocolModifySubmissionRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testExemptExpeditedChecked() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("100", "2", "3", true, false);
        ProtocolModifySubmissionRuleTest.assertFalse((boolean)this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean));
        ProtocolModifySubmissionRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testExemptOK() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("100", "2", "3", false, true);
        ProtocolModifySubmissionRuleTest.assertTrue((boolean)this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean));
    }

    @Test
    public void testExemptNothingChecked() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("100", "2", "3", false, false);
        ProtocolModifySubmissionRuleTest.assertFalse((boolean)this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean));
        ProtocolModifySubmissionRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testExpeditedExemptChecked() {
        ProtocolModifySubmissionBean protocolModifySubmissionBean = this.getMockProtocolModifySubmissionBean("100", "2", "2", false, true);
        ProtocolModifySubmissionRuleTest.assertFalse((boolean)this.rule.processModifySubmissionRule(this.document, protocolModifySubmissionBean));
        ProtocolModifySubmissionRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    private ProtocolModifySubmissionBean getMockProtocolModifySubmissionBean(final String protocolSubmissionTypeCode, final String protocolSubmissionQualifierTypeCode, final String protocolReviewTypeCode, final boolean expeditedChecklistChecked, final boolean exemptChecklistChecked) {
        final ProtocolModifySubmissionBean bean = (ProtocolModifySubmissionBean)this.context.mock(ProtocolModifySubmissionBean.class);
        final ExpeditedReviewCheckListItem expeditedItem = (ExpeditedReviewCheckListItem)this.context.mock(ExpeditedReviewCheckListItem.class);
        final ExemptStudiesCheckListItem exemptItem = (ExemptStudiesCheckListItem)this.context.mock(ExemptStudiesCheckListItem.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getSubmissionTypeCode();
                this.will(2.returnValue((Object)protocolSubmissionTypeCode));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getSubmissionQualifierTypeCode();
                this.will(2.returnValue((Object)protocolSubmissionQualifierTypeCode));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getProtocolReviewTypeCode();
                this.will(2.returnValue((Object)protocolReviewTypeCode));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).isBillable();
                this.will(2.returnValue((Object)true));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getExpeditedReviewCheckList();
                this.will(2.returnValue(Collections.singletonList(expeditedItem)));
                ((ExpeditedReviewCheckListItem)this.allowing(expeditedItem)).getChecked();
                this.will(2.returnValue((Object)expeditedChecklistChecked));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getExemptStudiesCheckList();
                this.will(2.returnValue(Collections.singletonList(exemptItem)));
                ((ExemptStudiesCheckListItem)this.allowing(exemptItem)).getChecked();
                this.will(2.returnValue((Object)exemptChecklistChecked));
            }
        });
        return bean;
    }
}

