/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.modifysubmission;

import java.sql.Date;
import java.util.Collections;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionBean;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolModifySubmissionServiceTest
extends KcUnitTestBase {
    private ProtocolModifySubmissionServiceImpl service;
    private BusinessObjectService businessObjectService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.service = new ProtocolModifySubmissionServiceImpl();
        this.service.setTaskAuthorizationService(this.getMockTaskAuthorizationService());
        this.service.setBusinessObjectService(this.businessObjectService);
        this.service.setDocumentService((DocumentService)KraServiceLocator.getService(DocumentService.class));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.businessObjectService = null;
        super.tearDown();
    }

    @Test
    public void testModifySubmissionFromFullReviewType() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission oldSubmission = this.createSubmission(protocolDocument.getProtocol(), "1");
        protocolDocument.getProtocol().getProtocolSubmissions().add(oldSubmission);
        this.service.modifySubmisison(protocolDocument, this.getMockProtocolModifySubmissionBean("2"));
        ProtocolSubmission newSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        ProtocolModifySubmissionServiceTest.assertEquals((Object)"2", (Object)newSubmission.getProtocolReviewTypeCode());
    }

    @Test
    public void testModifySubmissionFromExpeditedReviewType() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission oldSubmission = this.createSubmission(protocolDocument.getProtocol(), "2");
        protocolDocument.getProtocol().getProtocolSubmissions().add(oldSubmission);
        this.service.modifySubmisison(protocolDocument, this.getMockProtocolModifySubmissionBean("3"));
        ProtocolSubmission newSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        ProtocolModifySubmissionServiceTest.assertEquals((Object)"3", (Object)newSubmission.getProtocolReviewTypeCode());
    }

    @Test
    public void testModifySubmissionFromExemptReviewType() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmission oldSubmission = this.createSubmission(protocolDocument.getProtocol(), "3");
        protocolDocument.getProtocol().getProtocolSubmissions().add(oldSubmission);
        this.service.modifySubmisison(protocolDocument, this.getMockProtocolModifySubmissionBean("1"));
        ProtocolSubmission newSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        ProtocolModifySubmissionServiceTest.assertEquals((Object)"1", (Object)newSubmission.getProtocolReviewTypeCode());
    }

    private ProtocolSubmission createSubmission(Protocol protocol, String protocolReviewTypeCode) {
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setProtocol((ProtocolBase)protocol);
        submission.setProtocolId(protocol.getProtocolId());
        submission.setProtocolNumber(protocol.getProtocolNumber());
        submission.setSubmissionNumber(Integer.valueOf(1));
        submission.setSubmissionTypeCode("100");
        submission.setSubmissionStatusCode("100");
        submission.setProtocolReviewTypeCode(protocolReviewTypeCode);
        submission.setSubmissionDate(new Date(System.currentTimeMillis()));
        submission.setCommitteeId("1");
        return submission;
    }

    private TaskAuthorizationService getMockTaskAuthorizationService() {
        final TaskAuthorizationService service = (TaskAuthorizationService)this.context.mock(TaskAuthorizationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TaskAuthorizationService)this.allowing(service)).isAuthorized((String)this.with(2.any(String.class)), (Task)this.with(2.any(Task.class)));
                this.will(2.returnValue((Object)true));
            }
        });
        return service;
    }

    private ProtocolModifySubmissionBean getMockProtocolModifySubmissionBean(final String protocolReviewTypeCode) {
        final ProtocolModifySubmissionBean bean = (ProtocolModifySubmissionBean)this.context.mock(ProtocolModifySubmissionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getSubmissionTypeCode();
                this.will(3.returnValue((Object)"100"));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getSubmissionQualifierTypeCode();
                this.will(3.returnValue((Object)"2"));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getProtocolReviewTypeCode();
                this.will(3.returnValue((Object)protocolReviewTypeCode));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).isBillable();
                this.will(3.returnValue((Object)true));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getExpeditedReviewCheckList();
                this.will(3.returnValue(Collections.emptyList()));
                ((ProtocolModifySubmissionBean)this.allowing(bean)).getExemptStudiesCheckList();
                this.will(3.returnValue(Collections.emptyList()));
            }
        });
        return bean;
    }
}

