/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.noreview;

import java.sql.Date;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredBean;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredRule;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolReviewNotRequiredRuleTest
extends KcUnitTestBase {
    private static final String COMMENTS = "really cool comments";
    private static final Date ACTION_DATE = new Date(System.currentTimeMillis());
    private static final Date DECISION_DATE = new Date(System.currentTimeMillis());
    private ProtocolReviewNotRequiredRule rule;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProtocolReviewNotRequiredRule();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testOK() {
        ProtocolReviewNotRequiredBean protocolReviewNotRequredBean = this.getMockProtocolReviewNotRequiredBean(COMMENTS, ACTION_DATE, DECISION_DATE);
        ProtocolReviewNotRequiredRuleTest.assertTrue((boolean)this.rule.processReviewNotRequiredRule(null, protocolReviewNotRequredBean));
        ProtocolReviewNotRequiredRuleTest.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testNoComments() {
        ProtocolReviewNotRequiredBean protocolReviewNotRequredBean = this.getMockProtocolReviewNotRequiredBean(null, ACTION_DATE, DECISION_DATE);
        ProtocolReviewNotRequiredRuleTest.assertTrue((boolean)this.rule.processReviewNotRequiredRule(null, protocolReviewNotRequredBean));
        ProtocolReviewNotRequiredRuleTest.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testNoActionDate() {
        ProtocolReviewNotRequiredBean protocolReviewNotRequredBean = this.getMockProtocolReviewNotRequiredBean(COMMENTS, null, DECISION_DATE);
        ProtocolReviewNotRequiredRuleTest.assertFalse((boolean)this.rule.processReviewNotRequiredRule(null, protocolReviewNotRequredBean));
        ProtocolReviewNotRequiredRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testNoDecisionDate() {
        ProtocolReviewNotRequiredBean protocolReviewNotRequredBean = this.getMockProtocolReviewNotRequiredBean(COMMENTS, ACTION_DATE, null);
        ProtocolReviewNotRequiredRuleTest.assertFalse((boolean)this.rule.processReviewNotRequiredRule(null, protocolReviewNotRequredBean));
        ProtocolReviewNotRequiredRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    private ProtocolReviewNotRequiredBean getMockProtocolReviewNotRequiredBean(final String comments, final Date actionDate, final Date decisionDate) {
        final ProtocolReviewNotRequiredBean bean = (ProtocolReviewNotRequiredBean)this.context.mock(ProtocolReviewNotRequiredBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolReviewNotRequiredBean)this.allowing(bean)).getComments();
                this.will(2.returnValue((Object)comments));
                ((ProtocolReviewNotRequiredBean)this.allowing(bean)).getActionDate();
                this.will(2.returnValue((Object)actionDate));
                ((ProtocolReviewNotRequiredBean)this.allowing(bean)).getDecisionDate();
                this.will(2.returnValue((Object)decisionDate));
            }
        });
        return bean;
    }
}

