/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.noreview;

import java.sql.Date;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredBean;
import org.kuali.kra.irb.actions.noreview.ProtocolReviewNotRequiredServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolReviewNotRequiredServiceTest
extends KcUnitTestBase {
    private static final String COMMENTS = "really cool comments";
    private static final Date ACTION_DATE = new Date(System.currentTimeMillis());
    private static final Date DECISION_DATE = new Date(System.currentTimeMillis());
    private ProtocolReviewNotRequiredServiceImpl service;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolReviewNotRequiredServiceImpl();
        this.service.setProtocolActionService((ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setBusinessObjectService(this.getMockBusinessObjectService());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testReviewNotRequired() throws Exception {
        ProtocolReviewNotRequiredBean protocolReviewNotRequiredBean = this.getMockProtocolReviewNotRequiredBean();
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument("10101010");
        this.service.reviewNotRequired(protocolDocument, protocolReviewNotRequiredBean);
        ProtocolReviewNotRequiredServiceTest.assertEquals((Object)"310", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolReviewNotRequiredBean getMockProtocolReviewNotRequiredBean() {
        final ProtocolReviewNotRequiredBean bean = (ProtocolReviewNotRequiredBean)this.context.mock(ProtocolReviewNotRequiredBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolReviewNotRequiredBean)this.allowing(bean)).getComments();
                this.will(3.returnValue((Object)ProtocolReviewNotRequiredServiceTest.COMMENTS));
                ((ProtocolReviewNotRequiredBean)this.allowing(bean)).getActionDate();
                this.will(3.returnValue((Object)ACTION_DATE));
                ((ProtocolReviewNotRequiredBean)this.allowing(bean)).getDecisionDate();
                this.will(3.returnValue((Object)DECISION_DATE));
            }
        });
        return bean;
    }
}

