/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.notification;

import java.io.IOException;
import org.apache.struts.upload.FormFile;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplate;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationTemplateRule;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProtocolNotificationTemplateRuleTest {
    Mockery context = new JUnit4Mockery();
    FormFile mockedFile = null;

    @Before
    public void setUp() throws Exception {
        this.mockedFile = (FormFile)this.context.mock(FormFile.class);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        messageMap.clearErrorMessages();
    }

    @After
    public void tearDown() throws Exception {
        this.mockedFile = null;
    }

    @Test
    public void testReplaceNotificationTemplateOK() throws Exception {
        this.simulateValidMockedFileBehavior("text/xml");
        ProtocolNotificationTemplate template = new ProtocolNotificationTemplate();
        template.setActionTypeCode("116");
        template.setFileName("notifyirb.xsl");
        template.setNotificationTemplate(new byte[]{1, 2, 3});
        template.setTemplateFile(this.mockedFile);
        int index = 2;
        boolean rulePassed = new ProtocolNotificationTemplateRule().processReplaceProtocolNotificationTemplateRules(template, index);
        Assert.assertTrue((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)0L, (long)messageMap.getErrorCount());
    }

    @Test
    public void testReplaceNotificationTemplateNotOK() throws Exception {
        this.simulateValidMockedFileBehavior("pdf");
        ProtocolNotificationTemplate template = new ProtocolNotificationTemplate();
        template.setActionTypeCode("116");
        template.setFileName("test.pdf");
        template.setNotificationTemplate(new byte[0]);
        template.setTemplateFile(this.mockedFile);
        int index = 2;
        boolean rulePassed = new ProtocolNotificationTemplateRule().processReplaceProtocolNotificationTemplateRules(template, index);
        junit.framework.Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
    }

    private void simulateValidMockedFileBehavior(final String contentType) throws IOException {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolNotificationTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(1.returnValue((Object)contentType));
                ((FormFile)this.allowing(ProtocolNotificationTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(1.returnValue((Object)new byte[]{1, 2, 3}));
            }
        });
    }
}

