/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.notifyirb;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbBean;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbServiceImpl;
import org.kuali.kra.irb.actions.request.MockFormFile;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.questionnaire.IrbSubmissionQuestionnaireHelper;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolNotifyIrbServiceTest
extends KcUnitTestBase {
    private static final String COMMITTEE_ID = "913";
    private static final String COMMENT = "my test reason";
    private ProtocolNotifyIrbServiceImpl service;
    private BusinessObjectService businessObjectService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolNotifyIrbServiceImpl();
        this.service.setProtocolActionService((ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setDocumentService(this.getMockDocumentService());
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.service.setBusinessObjectService(this.businessObjectService);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.businessObjectService = null;
        super.tearDown();
    }

    @Test
    public void testRequestWithNoCommitteeNoFile() throws WorkflowException {
        this.runTest(this.getMockProtocolNotifyIrbBean("", new ProtocolActionAttachment[0]));
    }

    @Test
    public void testRequestWithCommitteeAndFile() throws WorkflowException {
        ProtocolActionAttachment attachment = new ProtocolActionAttachment();
        attachment.setFile((FormFile)new MockFormFile());
        ProtocolNotifyIrbBean notifyIrbBean = this.getMockProtocolNotifyIrbBean(COMMITTEE_ID, attachment);
        this.runTest(notifyIrbBean);
    }

    private void runTest(ProtocolNotifyIrbBean notifyIrbBean) throws WorkflowException {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        CommitteeDocument committeeDocument = null;
        if (!StringUtils.isBlank((String)notifyIrbBean.getCommitteeId())) {
            committeeDocument = this.createCommittee(notifyIrbBean.getCommitteeId());
        }
        this.service.submitIrbNotification(protocolDocument.getProtocol(), notifyIrbBean);
        ProtocolSubmission protocolSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        ProtocolNotifyIrbServiceTest.assertNotNull((Object)protocolSubmission);
        ProtocolAction protocolAction = protocolDocument.getProtocol().getLastProtocolAction();
        ProtocolNotifyIrbServiceTest.assertNotNull((Object)protocolAction);
        this.verifyAction(protocolAction, notifyIrbBean, protocolSubmission);
        this.verifySubmission(protocolSubmission, protocolDocument.getProtocol(), notifyIrbBean, committeeDocument);
        this.verifySubmissionDoc(protocolSubmission, notifyIrbBean);
    }

    private CommitteeDocument createCommittee(String committeeId) throws WorkflowException {
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument(committeeId);
        Committee committee = (Committee)committeeDocument.getCommittee();
        CommitteeSchedule schedule = new CommitteeSchedule();
        schedule.setScheduleId("1");
        schedule.setPlace("my office");
        schedule.setEndTime(new Timestamp(System.currentTimeMillis() + 100L));
        schedule.setScheduledDate(new Date(System.currentTimeMillis()));
        schedule.setStartTime(new Timestamp(System.currentTimeMillis() - 100L));
        schedule.setFilter(false);
        schedule.setMaxProtocols(committee.getMaxProtocols());
        schedule.setTime(new Timestamp(System.currentTimeMillis()));
        schedule.setViewTime(new Time12HrFmt(new Timestamp(System.currentTimeMillis())));
        schedule.setProtocolSubDeadline(new Date(System.currentTimeMillis() - 500L));
        schedule.setScheduleStatusCode(Integer.valueOf(1));
        committee.getCommitteeSchedules().add(schedule);
        this.businessObjectService.save((PersistableBusinessObject)committeeDocument);
        return committeeDocument;
    }

    private void verifySubmission(ProtocolSubmission submission, Protocol protocol, ProtocolNotifyIrbBean requestBean, CommitteeDocument committeeDocument) {
        ProtocolNotifyIrbServiceTest.assertEquals((Object)protocol.getProtocolNumber(), (Object)submission.getProtocolNumber());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)protocol.getSequenceNumber(), (Object)submission.getSequenceNumber());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)new Integer(1), (Object)submission.getSubmissionNumber());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)"112", (Object)submission.getSubmissionTypeCode());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)"7", (Object)submission.getProtocolReviewTypeCode());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)"100", (Object)submission.getSubmissionStatusCode());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)this.convert(requestBean.getCommitteeId()), (Object)this.convert(submission.getCommitteeId()));
        if (committeeDocument == null) {
            ProtocolNotifyIrbServiceTest.assertNull((Object)submission.getCommitteeIdFk());
        } else {
            ProtocolNotifyIrbServiceTest.assertEquals((Object)((Committee)committeeDocument.getCommittee()).getId(), (Object)submission.getCommitteeIdFk());
        }
    }

    private void verifySubmissionDoc(ProtocolSubmission protocolSubmission, ProtocolNotifyIrbBean requestBean) {
        ProtocolSubmissionDoc doc = this.findSubmissionDoc(protocolSubmission);
        if (requestBean.getActionAttachments().isEmpty()) {
            ProtocolNotifyIrbServiceTest.assertNull((Object)doc);
        } else {
            ProtocolNotifyIrbServiceTest.assertEquals((Object)((ProtocolActionAttachment)requestBean.getActionAttachments().get(0)).getFile().getFileName(), (Object)doc.getFileName());
            ProtocolNotifyIrbServiceTest.assertEquals((long)((ProtocolActionAttachment)requestBean.getActionAttachments().get(0)).getFile().getFileSize(), (long)doc.getDocument().length);
        }
    }

    private void verifyAction(ProtocolAction action, ProtocolNotifyIrbBean requestBean, ProtocolSubmission submission) {
        ProtocolNotifyIrbServiceTest.assertEquals((Object)"116", (Object)action.getProtocolActionTypeCode());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)submission.getSubmissionId(), (Object)action.getSubmissionIdFk());
        ProtocolNotifyIrbServiceTest.assertEquals((Object)COMMENT, (Object)action.getComments());
    }

    private String convert(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private ProtocolSubmissionDoc findSubmissionDoc(ProtocolSubmission protocolSubmission) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("submissionIdFk", protocolSubmission.getSubmissionId());
        List docs = (List)this.businessObjectService.findMatching(ProtocolSubmissionDoc.class, fieldValues);
        if (docs.size() == 0) {
            return null;
        }
        return (ProtocolSubmissionDoc)docs.get(0);
    }

    private DocumentService getMockDocumentService() {
        final DocumentService service = (DocumentService)this.context.mock(DocumentService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolNotifyIrbBean getMockProtocolNotifyIrbBean(final String committeeId, final ProtocolActionAttachment ... attachments) {
        final ProtocolNotifyIrbBean bean = (ProtocolNotifyIrbBean)this.context.mock(ProtocolNotifyIrbBean.class);
        final Protocol protocol = new Protocol();
        protocol.setProtocolNumber("13049581");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolNotifyIrbBean)this.allowing(bean)).getSubmissionQualifierTypeCode();
                this.will(3.returnValue((Object)"5"));
                ((ProtocolNotifyIrbBean)this.allowing(bean)).getReviewTypeCode();
                this.will(3.returnValue((Object)"7"));
                ((ProtocolNotifyIrbBean)this.allowing(bean)).getCommitteeId();
                this.will(3.returnValue((Object)committeeId));
                ((ProtocolNotifyIrbBean)this.allowing(bean)).getComment();
                this.will(3.returnValue((Object)ProtocolNotifyIrbServiceTest.COMMENT));
                ((ProtocolNotifyIrbBean)this.allowing(bean)).getActionAttachments();
                this.will(3.returnValue(Arrays.asList(attachments)));
                ((ProtocolNotifyIrbBean)this.allowing(bean)).getQuestionnaireHelper();
                this.will(3.returnValue((Object)new IrbSubmissionQuestionnaireHelper((ProtocolBase)protocol, "116", null, false)));
            }
        });
        return bean;
    }
}

