/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.request;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Test;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestEvent;
import org.kuali.kra.irb.actions.request.ProtocolRequestRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class ProtocolRequestRuleTest
extends ProtocolRuleTestBase {
    private static final String COMMITTEE_ID = "1";
    private static final String MANDATORY = "M";
    private static final String OPTIONAL = "O";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Test
    public void testOK() throws Exception {
        new TemplateRuleTest<ProtocolRequestEvent<ProtocolRequestRule>, ProtocolRequestRule>(){

            @Override
            protected void prerequisite() {
                ProtocolRequestBean requestBean = ProtocolRequestRuleTest.this.getMockProtocolRequestBean("105", "109", "", "protocolCloseRequestBean");
                this.event = new ProtocolRequestEvent(null, "actionHelper.protocolCloseReqeust", requestBean);
                this.rule = new ProtocolRequestRule();
                ((ProtocolRequestRule)this.rule).setParameterService(ProtocolRequestRuleTest.this.getMockParameterService(ProtocolRequestRuleTest.OPTIONAL));
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testMandatoryOK() throws WorkflowException {
        new TemplateRuleTest<ProtocolRequestEvent<ProtocolRequestRule>, ProtocolRequestRule>(){

            @Override
            protected void prerequisite() {
                ProtocolRequestBean requestBean = ProtocolRequestRuleTest.this.getMockProtocolRequestBean("105", "109", ProtocolRequestRuleTest.COMMITTEE_ID, "protocolCloseRequestBean");
                this.event = new ProtocolRequestEvent(null, "actionHelper.protocolCloseReqeust", requestBean);
                this.rule = new ProtocolRequestRule();
                ((ProtocolRequestRule)this.rule).setParameterService(ProtocolRequestRuleTest.this.getMockParameterService(ProtocolRequestRuleTest.MANDATORY));
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testMandatoryCommittee() throws WorkflowException {
        new TemplateRuleTest<ProtocolRequestEvent<ProtocolRequestRule>, ProtocolRequestRule>(){

            @Override
            protected void prerequisite() {
                ProtocolRequestBean requestBean = ProtocolRequestRuleTest.this.getMockProtocolRequestBean("105", "109", "", "protocolCloseRequestBean");
                this.event = new ProtocolRequestEvent(null, "actionHelper.protocolCloseReqeust", requestBean);
                this.rule = new ProtocolRequestRule();
                ((ProtocolRequestRule)this.rule).setParameterService(ProtocolRequestRuleTest.this.getMockParameterService(ProtocolRequestRuleTest.MANDATORY));
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolRequestRuleTest.this.assertError("actionHelper.protocolCloseReqeust.committeeId", "error.protocol.submission.committee.required");
            }
        };
    }

    private ParameterService getMockParameterService(final String committeeMandatoryCode) {
        final ParameterService service = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.allowing(service)).getParameterValueAsString(ProtocolDocument.class, "IRB_COMM_SELECTION_DURING_SUBMISSION");
                this.will(5.returnValue((Object)committeeMandatoryCode));
            }
        });
        return service;
    }

    private ProtocolRequestBean getMockProtocolRequestBean(final String protocolActionTypeCode, final String submissionTypeCode, final String committeeId, final String beanName) {
        final ProtocolRequestBean bean = (ProtocolRequestBean)this.context.mock(ProtocolRequestBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolRequestBean)this.allowing(bean)).getProtocolActionTypeCode();
                this.will(6.returnValue((Object)protocolActionTypeCode));
                ((ProtocolRequestBean)this.allowing(bean)).getSubmissionTypeCode();
                this.will(6.returnValue((Object)submissionTypeCode));
                ((ProtocolRequestBean)this.allowing(bean)).getCommitteeId();
                this.will(6.returnValue((Object)committeeId));
                ((ProtocolRequestBean)this.allowing(bean)).getBeanName();
                this.will(6.returnValue((Object)beanName));
            }
        });
        return bean;
    }
}

