/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.request;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.request.MockFormFile;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.questionnaire.IrbSubmissionQuestionnaireHelper;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolRequestServiceTest
extends KcUnitTestBase {
    private static final String COMMITTEE_ID = "925";
    private static final String REASON = "my test reason";
    private ProtocolRequestServiceImpl service;
    private BusinessObjectService businessObjectService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.service = new ProtocolRequestServiceImpl();
        this.service.setBusinessObjectService(this.businessObjectService);
        this.service.setProtocolActionService((ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setDocumentService((DocumentService)KraServiceLocator.getService(DocumentService.class));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.businessObjectService = null;
        super.tearDown();
    }

    @Test
    public void testDumbTest() {
        ProtocolRequestServiceTest.assertTrue((boolean)true);
    }

    @Test
    public void testRequestWithNoCommitteeNoFile() throws WorkflowException {
        ProtocolRequestBean closeRequest = this.getMockProtocolRequestBean("105", "109", "", "protocolCloseRequestBean", new ProtocolActionAttachment[0]);
        this.runTest("", null, closeRequest);
    }

    @Test
    public void testRequest() throws WorkflowException {
        ProtocolActionAttachment attachment = new ProtocolActionAttachment();
        attachment.setFile((FormFile)new MockFormFile());
        ProtocolRequestBean closeRequest = this.getMockProtocolRequestBean("105", "109", COMMITTEE_ID, "protocolCloseRequestBean", attachment);
        this.runTest(COMMITTEE_ID, null, closeRequest);
    }

    private void runTest(String committeeId, FormFile formFile, ProtocolRequestBean requestBean) throws WorkflowException {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ArrayList<DocumentNextvalue> documentNextvalues = new ArrayList<DocumentNextvalue>();
        DocumentNextvalue dnv1 = new DocumentNextvalue();
        dnv1.setDocumentKey("123456");
        dnv1.setPropertyName("submissionNumber");
        dnv1.setNextValue(new Integer(1));
        documentNextvalues.add(dnv1);
        DocumentNextvalue dnv2 = new DocumentNextvalue();
        dnv2.setDocumentKey("123456");
        dnv2.setPropertyName("submissionDocId");
        dnv2.setNextValue(new Integer(1));
        documentNextvalues.add(dnv2);
        DocumentNextvalue dnv3 = new DocumentNextvalue();
        dnv3.setDocumentKey("123456");
        dnv3.setPropertyName("actionId");
        dnv3.setNextValue(new Integer(1));
        documentNextvalues.add(dnv3);
        protocolDocument.setDocumentNextvalues(documentNextvalues);
        protocolDocument.getProtocol().setProtocolDocument((ProtocolDocumentBase)protocolDocument);
        CommitteeDocument committeeDocument = null;
        if (!StringUtils.isBlank((String)committeeId)) {
            committeeDocument = this.createCommittee(committeeId);
        }
        this.service.submitRequest(protocolDocument.getProtocol(), requestBean);
        ProtocolSubmission protocolSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        ProtocolRequestServiceTest.assertNotNull((Object)protocolSubmission);
        ProtocolAction protocolAction = protocolDocument.getProtocol().getLastProtocolAction();
        ProtocolRequestServiceTest.assertNotNull((Object)protocolAction);
        this.verifyAction(protocolAction, requestBean, protocolSubmission);
        this.verifySubmission(protocolSubmission, protocolDocument.getProtocol(), requestBean, committeeDocument);
        this.verifySubmissionDoc(protocolSubmission, requestBean);
    }

    private CommitteeDocument createCommittee(String committeeId) throws WorkflowException {
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument(committeeId);
        Committee committee = (Committee)committeeDocument.getCommittee();
        CommitteeSchedule schedule = new CommitteeSchedule();
        schedule.setScheduleId("1");
        schedule.setPlace("my office");
        schedule.setEndTime(new Timestamp(System.currentTimeMillis() + 100L));
        schedule.setScheduledDate(new Date(System.currentTimeMillis()));
        schedule.setStartTime(new Timestamp(System.currentTimeMillis() - 100L));
        schedule.setFilter(false);
        schedule.setMaxProtocols(committee.getMaxProtocols());
        schedule.setTime(new Timestamp(System.currentTimeMillis()));
        schedule.setViewTime(new Time12HrFmt(new Timestamp(System.currentTimeMillis())));
        schedule.setProtocolSubDeadline(new Date(System.currentTimeMillis() - 500L));
        schedule.setScheduleStatusCode(Integer.valueOf(1));
        committee.getCommitteeSchedules().add(schedule);
        this.businessObjectService.save((PersistableBusinessObject)committeeDocument);
        return committeeDocument;
    }

    private void verifySubmission(ProtocolSubmission submission, Protocol protocol, ProtocolRequestBean requestBean, CommitteeDocument committeeDocument) {
        ProtocolRequestServiceTest.assertEquals((Object)protocol.getProtocolNumber(), (Object)submission.getProtocolNumber());
        ProtocolRequestServiceTest.assertEquals((Object)protocol.getSequenceNumber(), (Object)submission.getSequenceNumber());
        ProtocolRequestServiceTest.assertEquals((Object)new Integer(1), (Object)submission.getSubmissionNumber());
        ProtocolRequestServiceTest.assertEquals((Object)requestBean.getSubmissionTypeCode(), (Object)submission.getSubmissionTypeCode());
        ProtocolRequestServiceTest.assertEquals((Object)"1", (Object)submission.getProtocolReviewTypeCode());
        ProtocolRequestServiceTest.assertEquals((Object)"102", (Object)submission.getSubmissionStatusCode());
        ProtocolRequestServiceTest.assertEquals((Object)this.convert(requestBean.getCommitteeId()), (Object)this.convert(submission.getCommitteeId()));
        if (committeeDocument == null) {
            ProtocolRequestServiceTest.assertNull((Object)submission.getCommitteeIdFk());
        } else {
            ProtocolRequestServiceTest.assertEquals((Object)((Committee)committeeDocument.getCommittee()).getId(), (Object)submission.getCommitteeIdFk());
        }
    }

    private void verifySubmissionDoc(ProtocolSubmission protocolSubmission, ProtocolRequestBean requestBean) {
        ProtocolSubmissionDoc doc = this.findSubmissionDoc(protocolSubmission);
        if (requestBean.getActionAttachments().isEmpty()) {
            ProtocolRequestServiceTest.assertNull((Object)doc);
        } else {
            ProtocolRequestServiceTest.assertEquals((Object)((ProtocolActionAttachment)requestBean.getActionAttachments().get(0)).getFile().getFileName(), (Object)doc.getFileName());
            ProtocolRequestServiceTest.assertEquals((long)((ProtocolActionAttachment)requestBean.getActionAttachments().get(0)).getFile().getFileSize(), (long)doc.getDocument().length);
        }
    }

    private void verifyAction(ProtocolAction action, ProtocolRequestBean requestBean, ProtocolSubmission submission) {
        ProtocolRequestServiceTest.assertEquals((Object)requestBean.getProtocolActionTypeCode(), (Object)action.getProtocolActionTypeCode());
        ProtocolRequestServiceTest.assertEquals((Object)submission.getSubmissionId(), (Object)action.getSubmissionIdFk());
        ProtocolRequestServiceTest.assertEquals((Object)REASON, (Object)action.getComments());
    }

    private String convert(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private ProtocolSubmissionDoc findSubmissionDoc(ProtocolSubmission protocolSubmission) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("submissionIdFk", protocolSubmission.getSubmissionId());
        List docs = (List)this.businessObjectService.findMatching(ProtocolSubmissionDoc.class, fieldValues);
        if (docs.size() == 0) {
            return null;
        }
        return (ProtocolSubmissionDoc)docs.get(0);
    }

    private ProtocolRequestBean getMockProtocolRequestBean(final String protocolActionTypeCode, final String submissionTypeCode, final String committeeId, final String beanName, final ProtocolActionAttachment ... attachments) {
        final ProtocolRequestBean bean = (ProtocolRequestBean)this.context.mock(ProtocolRequestBean.class);
        final Protocol protocol = new Protocol();
        protocol.setProtocolNumber("13049581");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolRequestBean)this.allowing(bean)).getProtocolActionTypeCode();
                this.will(2.returnValue((Object)protocolActionTypeCode));
                ((ProtocolRequestBean)this.allowing(bean)).getSubmissionTypeCode();
                this.will(2.returnValue((Object)submissionTypeCode));
                ((ProtocolRequestBean)this.allowing(bean)).getCommitteeId();
                this.will(2.returnValue((Object)committeeId));
                ((ProtocolRequestBean)this.allowing(bean)).getReason();
                this.will(2.returnValue((Object)ProtocolRequestServiceTest.REASON));
                ((ProtocolRequestBean)this.allowing(bean)).getBeanName();
                this.will(2.returnValue((Object)beanName));
                ((ProtocolRequestBean)this.allowing(bean)).getActionAttachments();
                this.will(2.returnValue(Arrays.asList(attachments)));
                ((ProtocolRequestBean)this.allowing(bean)).getQuestionnaireHelper();
                this.will(2.returnValue((Object)new IrbSubmissionQuestionnaireHelper((ProtocolBase)protocol, protocolActionTypeCode, null, false)));
            }
        });
        return bean;
    }
}

