/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.reviewcomments;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ReviewCommentsServiceTest
extends KcUnitTestBase {
    private static final String FIRST_COMMENT = "First Review Comment";
    private static final String SECOND_COMMENT = "Second Review Comment";
    private static final String THIRD_COMMENT = "Third Review Comment";
    private static final Long PROTOCOL_ONLINE_REVIEW_FK_ID = new Long("12514314361461436");
    private ReviewCommentsServiceImpl service;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ReviewCommentsServiceImpl();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testAddReviewComment() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ArrayList reviewComments = new ArrayList();
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute();
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        this.service.setDateTimeService(this.getMockDateTimeService());
        this.service.addReviewComment((CommitteeScheduleMinuteBase)firstNewReviewComment, reviewComments, (ProtocolBase)protocolDocument.getProtocol());
        ReviewCommentsServiceTest.assertEquals((long)1L, (long)reviewComments.size());
        CommitteeScheduleMinute firstReviewComment = (CommitteeScheduleMinute)reviewComments.get(0);
        ReviewCommentsServiceTest.assertNotNull((Object)firstReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)firstReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)0, (Object)firstReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)FIRST_COMMENT, (Object)firstReviewComment.getMinuteEntry());
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute();
        secondNewReviewComment.setMinuteEntryTypeCode("3");
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        this.service.addReviewComment((CommitteeScheduleMinuteBase)secondNewReviewComment, reviewComments, (ProtocolBase)protocolDocument.getProtocol());
        ReviewCommentsServiceTest.assertEquals((long)2L, (long)reviewComments.size());
        CommitteeScheduleMinute secondReviewComment = (CommitteeScheduleMinute)reviewComments.get(1);
        ReviewCommentsServiceTest.assertNotNull((Object)secondReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)secondReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)1, (Object)secondReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)SECOND_COMMENT, (Object)secondReviewComment.getMinuteEntry());
    }

    @Test
    public void testMoveUpReviewComment() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute();
        firstNewReviewComment.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setEntryNumber(Integer.valueOf(0));
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute();
        secondNewReviewComment.setMinuteEntryTypeCode("4");
        secondNewReviewComment.setEntryNumber(Integer.valueOf(1));
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        reviewComments.add(secondNewReviewComment);
        CommitteeScheduleMinute thirdNewReviewComment = new CommitteeScheduleMinute();
        thirdNewReviewComment.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        thirdNewReviewComment.setMinuteEntryTypeCode("3");
        thirdNewReviewComment.setEntryNumber(Integer.valueOf(2));
        thirdNewReviewComment.setMinuteEntry(THIRD_COMMENT);
        reviewComments.add(thirdNewReviewComment);
        this.service.moveUpReviewComment(reviewComments, (ProtocolBase)protocolDocument.getProtocol(), 2);
        ReviewCommentsServiceTest.assertEquals((long)3L, (long)reviewComments.size());
        CommitteeScheduleMinute thirdReviewComment = (CommitteeScheduleMinute)reviewComments.get(0);
        ReviewCommentsServiceTest.assertNotNull((Object)thirdReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)thirdReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)0, (Object)thirdReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)THIRD_COMMENT, (Object)thirdReviewComment.getMinuteEntry());
        CommitteeScheduleMinute firstReviewComment = (CommitteeScheduleMinute)reviewComments.get(1);
        ReviewCommentsServiceTest.assertNotNull((Object)firstReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)firstReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)1, (Object)firstReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)FIRST_COMMENT, (Object)firstReviewComment.getMinuteEntry());
        CommitteeScheduleMinute secondReviewComment = (CommitteeScheduleMinute)reviewComments.get(2);
        ReviewCommentsServiceTest.assertNotNull((Object)secondReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"4", (Object)secondReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)2, (Object)secondReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)SECOND_COMMENT, (Object)secondReviewComment.getMinuteEntry());
    }

    @Test
    public void testMoveDownReviewComment() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute();
        firstNewReviewComment.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setEntryNumber(Integer.valueOf(0));
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute();
        secondNewReviewComment.setMinuteEntryTypeCode("4");
        secondNewReviewComment.setEntryNumber(Integer.valueOf(1));
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        reviewComments.add(secondNewReviewComment);
        CommitteeScheduleMinute thirdNewReviewComment = new CommitteeScheduleMinute();
        thirdNewReviewComment.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        thirdNewReviewComment.setMinuteEntryTypeCode("3");
        thirdNewReviewComment.setEntryNumber(Integer.valueOf(2));
        thirdNewReviewComment.setMinuteEntry(THIRD_COMMENT);
        reviewComments.add(thirdNewReviewComment);
        this.service.moveDownReviewComment(reviewComments, (ProtocolBase)protocolDocument.getProtocol(), 0);
        ReviewCommentsServiceTest.assertEquals((long)3L, (long)reviewComments.size());
        CommitteeScheduleMinute secondReviewComment = (CommitteeScheduleMinute)reviewComments.get(0);
        ReviewCommentsServiceTest.assertNotNull((Object)secondReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"4", (Object)secondReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)0, (Object)secondReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)SECOND_COMMENT, (Object)secondReviewComment.getMinuteEntry());
        CommitteeScheduleMinute thirdReviewComment = (CommitteeScheduleMinute)reviewComments.get(1);
        ReviewCommentsServiceTest.assertNotNull((Object)thirdReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)thirdReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)1, (Object)thirdReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)THIRD_COMMENT, (Object)thirdReviewComment.getMinuteEntry());
        CommitteeScheduleMinute firstReviewComment = (CommitteeScheduleMinute)reviewComments.get(2);
        ReviewCommentsServiceTest.assertNotNull((Object)firstReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)firstReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)2, (Object)firstReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)FIRST_COMMENT, (Object)firstReviewComment.getMinuteEntry());
    }

    @Test
    public void testDeleteReviewComment() throws Exception {
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        ArrayList deletedReviewComments = new ArrayList();
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute();
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setEntryNumber(Integer.valueOf(0));
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute();
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("4");
        secondNewReviewComment.setEntryNumber(Integer.valueOf(1));
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        reviewComments.add(secondNewReviewComment);
        CommitteeScheduleMinute thirdNewReviewComment = new CommitteeScheduleMinute();
        thirdNewReviewComment.setCommScheduleMinutesId(Long.valueOf(3L));
        thirdNewReviewComment.setMinuteEntryTypeCode("3");
        thirdNewReviewComment.setEntryNumber(Integer.valueOf(2));
        thirdNewReviewComment.setMinuteEntry(THIRD_COMMENT);
        reviewComments.add(thirdNewReviewComment);
        this.service.deleteReviewComment(reviewComments, 0, deletedReviewComments);
        ReviewCommentsServiceTest.assertEquals((long)2L, (long)reviewComments.size());
        CommitteeScheduleMinute secondReviewComment = (CommitteeScheduleMinute)reviewComments.get(0);
        ReviewCommentsServiceTest.assertNotNull((Object)secondReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"4", (Object)secondReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)0, (Object)secondReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)SECOND_COMMENT, (Object)secondReviewComment.getMinuteEntry());
        CommitteeScheduleMinute thirdReviewComment = (CommitteeScheduleMinute)reviewComments.get(1);
        ReviewCommentsServiceTest.assertNotNull((Object)thirdReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)thirdReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)1, (Object)thirdReviewComment.getEntryNumber());
        ReviewCommentsServiceTest.assertEquals((Object)THIRD_COMMENT, (Object)thirdReviewComment.getMinuteEntry());
        ReviewCommentsServiceTest.assertEquals((long)1L, (long)deletedReviewComments.size());
        CommitteeScheduleMinute firstReviewComment = (CommitteeScheduleMinute)deletedReviewComments.get(0);
        ReviewCommentsServiceTest.assertNotNull((Object)firstReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)firstReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)FIRST_COMMENT, (Object)firstReviewComment.getMinuteEntry());
    }

    @Test
    public void testDeleteAllReviewComment() throws Exception {
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        ArrayList deletedReviewComments = new ArrayList();
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute();
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute();
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("4");
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        reviewComments.add(secondNewReviewComment);
        CommitteeScheduleMinute thirdNewReviewComment = new CommitteeScheduleMinute();
        thirdNewReviewComment.setCommScheduleMinutesId(Long.valueOf(3L));
        thirdNewReviewComment.setMinuteEntryTypeCode("3");
        thirdNewReviewComment.setMinuteEntry(THIRD_COMMENT);
        reviewComments.add(thirdNewReviewComment);
        this.service.deleteAllReviewComments(reviewComments, deletedReviewComments);
        ReviewCommentsServiceTest.assertEquals((long)0L, (long)reviewComments.size());
        ReviewCommentsServiceTest.assertEquals((long)3L, (long)deletedReviewComments.size());
        CommitteeScheduleMinute firstReviewComment = (CommitteeScheduleMinute)deletedReviewComments.get(0);
        ReviewCommentsServiceTest.assertNotNull((Object)firstReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)firstReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)FIRST_COMMENT, (Object)firstReviewComment.getMinuteEntry());
        CommitteeScheduleMinute secondReviewComment = (CommitteeScheduleMinute)deletedReviewComments.get(1);
        ReviewCommentsServiceTest.assertNotNull((Object)secondReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"4", (Object)secondReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)SECOND_COMMENT, (Object)secondReviewComment.getMinuteEntry());
        CommitteeScheduleMinute thirdReviewComment = (CommitteeScheduleMinute)deletedReviewComments.get(2);
        ReviewCommentsServiceTest.assertNotNull((Object)thirdReviewComment);
        ReviewCommentsServiceTest.assertEquals((Object)"3", (Object)thirdReviewComment.getMinuteEntryTypeCode());
        ReviewCommentsServiceTest.assertEquals((Object)THIRD_COMMENT, (Object)thirdReviewComment.getMinuteEntry());
    }

    @Test
    public void testHideReviewerNameProtocolFalse() throws Exception {
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeSchedule committeeSchedule = this.createCommitteeSchedule("10", this.createCommittee());
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        firstNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        firstNewReviewComment.setCreateUser("majors");
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        secondNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("3");
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        secondNewReviewComment.setCreateUser("quickstart");
        reviewComments.add(secondNewReviewComment);
        this.service.setParameterService(this.getMockParameterService());
        this.service.setRoleService(this.getMockRoleService());
        this.service.setCommitteeService((CommitteeServiceBase)this.getMockCommitteeService());
        this.service.setKcPersonService(this.getMockKcPersonService());
        Protocol protocol = new Protocol();
        protocol.setProtocolNumber("001");
        this.service.setProtocolFinderDao((org.kuali.kra.protocol.ProtocolFinderDao)this.getProtocolFinderDao(reviewComments));
        ReviewCommentsServiceTest.assertFalse((boolean)this.service.setHideReviewerName((ProtocolBase)protocol, 1));
        ReviewCommentsServiceTest.assertTrue((boolean)firstNewReviewComment.isDisplayReviewerName());
        ReviewCommentsServiceTest.assertTrue((boolean)secondNewReviewComment.isDisplayReviewerName());
    }

    @Test
    public void testHideReviewerNameProtocolTrue() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("jtester"));
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeSchedule committeeSchedule = this.createCommitteeSchedule("10", this.createCommittee());
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        firstNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        firstNewReviewComment.setCreateUser("majors");
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        secondNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("3");
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        secondNewReviewComment.setCreateUser("quickstart");
        reviewComments.add(secondNewReviewComment);
        this.service.setParameterService(this.getMockParameterService());
        this.service.setKimRoleManagementService(this.getMockRoleService1());
        this.service.setCommitteeService((CommitteeServiceBase)this.getMockCommitteeService());
        this.service.setKcPersonService(this.getMockKcPersonService());
        Protocol protocol = new Protocol();
        protocol.setProtocolNumber("001");
        this.service.setProtocolFinderDao((org.kuali.kra.protocol.ProtocolFinderDao)this.getProtocolFinderDao(reviewComments));
        ReviewCommentsServiceTest.assertTrue((boolean)this.service.setHideReviewerName((ProtocolBase)protocol, 1));
        ReviewCommentsServiceTest.assertFalse((boolean)firstNewReviewComment.isDisplayReviewerName());
        ReviewCommentsServiceTest.assertFalse((boolean)secondNewReviewComment.isDisplayReviewerName());
    }

    @Test
    public void testHideReviewerNameProtocolFalsePartial() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("majors"));
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeSchedule committeeSchedule = this.createCommitteeSchedule("10", this.createCommittee());
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }

            public boolean isAccepted() {
                return true;
            }
        };
        firstNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setProtocolOnlineReviewIdFk(PROTOCOL_ONLINE_REVIEW_FK_ID);
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        firstNewReviewComment.setCreateUser("majors");
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }

            public boolean isAccepted() {
                return true;
            }
        };
        secondNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("3");
        secondNewReviewComment.setProtocolOnlineReviewIdFk(PROTOCOL_ONLINE_REVIEW_FK_ID);
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        secondNewReviewComment.setCreateUser("quickstart");
        reviewComments.add(secondNewReviewComment);
        this.service.setParameterService(this.getMockParameterService());
        this.service.setKimRoleManagementService(this.getMockRoleService1());
        this.service.setCommitteeService((CommitteeServiceBase)this.getMockCommitteeService());
        this.service.setBusinessObjectService(this.getMockBusinessObjectService());
        this.service.setKcPersonService(this.getMockKcPersonService());
        Protocol protocol = new Protocol();
        protocol.setProtocolNumber("001");
        this.service.setProtocolFinderDao((org.kuali.kra.protocol.ProtocolFinderDao)this.getProtocolFinderDao(reviewComments));
        ReviewCommentsServiceTest.assertFalse((boolean)this.service.setHideReviewerName((ProtocolBase)protocol, 1));
        ReviewCommentsServiceTest.assertTrue((boolean)firstNewReviewComment.isDisplayReviewerName());
        ReviewCommentsServiceTest.assertFalse((boolean)secondNewReviewComment.isDisplayReviewerName());
    }

    @Test
    public void testHideReviewerNameFalse() throws Exception {
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeSchedule committeeSchedule = this.createCommitteeSchedule("10", this.createCommittee());
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        firstNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        firstNewReviewComment.setCreateUser("majors");
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        secondNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("4");
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        secondNewReviewComment.setCreateUser("quickstart");
        reviewComments.add(secondNewReviewComment);
        this.service.setParameterService(this.getMockParameterService());
        this.service.setKimRoleManagementService(this.getMockRoleService());
        this.service.setCommitteeService((CommitteeServiceBase)this.getMockCommitteeService());
        this.service.setKcPersonService(this.getMockKcPersonService());
        ReviewCommentsServiceTest.assertFalse((boolean)this.service.setHideReviewerName(reviewComments));
        ReviewCommentsServiceTest.assertTrue((boolean)firstNewReviewComment.isDisplayReviewerName());
        ReviewCommentsServiceTest.assertTrue((boolean)secondNewReviewComment.isDisplayReviewerName());
    }

    @Test
    public void testHideReviewerNameFalsePartial() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("majors"));
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeSchedule committeeSchedule = this.createCommitteeSchedule("10", this.createCommittee());
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        firstNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        firstNewReviewComment.setCreateUser("majors");
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        secondNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("4");
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        secondNewReviewComment.setCreateUser("quickstart");
        reviewComments.add(secondNewReviewComment);
        this.service.setParameterService(this.getMockParameterService());
        this.service.setKimRoleManagementService(this.getMockRoleService1());
        this.service.setCommitteeService((CommitteeServiceBase)this.getMockCommitteeService());
        this.service.setKcPersonService(this.getMockKcPersonService());
        ReviewCommentsServiceTest.assertFalse((boolean)this.service.setHideReviewerName(reviewComments));
        ReviewCommentsServiceTest.assertTrue((boolean)firstNewReviewComment.isDisplayReviewerName());
        ReviewCommentsServiceTest.assertFalse((boolean)secondNewReviewComment.isDisplayReviewerName());
    }

    @Test
    public void testHideReviewerNameTrue() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("jtester"));
        ArrayList<CommitteeScheduleMinute> reviewComments = new ArrayList<CommitteeScheduleMinute>();
        CommitteeSchedule committeeSchedule = this.createCommitteeSchedule("10", this.createCommittee());
        CommitteeScheduleMinute firstNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        firstNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        firstNewReviewComment.setCommScheduleMinutesId(Long.valueOf(1L));
        firstNewReviewComment.setMinuteEntryTypeCode("3");
        firstNewReviewComment.setMinuteEntry(FIRST_COMMENT);
        firstNewReviewComment.setCreateUser("majors");
        reviewComments.add(firstNewReviewComment);
        CommitteeScheduleMinute secondNewReviewComment = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        secondNewReviewComment.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        secondNewReviewComment.setCommScheduleMinutesId(Long.valueOf(2L));
        secondNewReviewComment.setMinuteEntryTypeCode("4");
        secondNewReviewComment.setMinuteEntry(SECOND_COMMENT);
        secondNewReviewComment.setCreateUser("quickstart");
        reviewComments.add(secondNewReviewComment);
        this.service.setParameterService(this.getMockParameterService());
        this.service.setKimRoleManagementService(this.getMockRoleService1());
        this.service.setCommitteeService((CommitteeServiceBase)this.getMockCommitteeService());
        this.service.setKcPersonService(this.getMockKcPersonService());
        ReviewCommentsServiceTest.assertTrue((boolean)this.service.setHideReviewerName(reviewComments));
        ReviewCommentsServiceTest.assertFalse((boolean)firstNewReviewComment.isDisplayReviewerName());
        ReviewCommentsServiceTest.assertFalse((boolean)secondNewReviewComment.isDisplayReviewerName());
    }

    private DateTimeService getMockDateTimeService() {
        final DateTimeService service = (DateTimeService)this.context.mock(DateTimeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DateTimeService)this.allowing(service)).getCurrentTimestamp();
                this.will(14.returnValue((Object)new Timestamp(System.currentTimeMillis())));
            }
        });
        return service;
    }

    private ParameterService getMockParameterService() {
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString(ProtocolDocument.class, "IRB_DISPLAY_REVIEWER_NAME_TO_PROTOCOL_PERSONNEL");
                this.will(15.returnValue((Object)"0"));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString(ProtocolDocument.class, "IRB_DISPLAY_REVIEWER_NAME_TO_REVIEWERS");
                this.will(15.returnValue((Object)"0"));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsString(ProtocolDocument.class, "IRB_DISPLAY_REVIEWER_NAME_TO_ACTIVE_COMMITTEE_MEMBERS");
                this.will(15.returnValue((Object)"0"));
            }
        });
        return parameterService;
    }

    private RoleService getMockRoleService() {
        final RoleService kimRoleManagementService = (RoleService)this.context.mock(RoleService.class);
        final HashSet<String> adminIds = new HashSet<String>();
        adminIds.add("10000000001");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RoleService)this.allowing(kimRoleManagementService)).getRoleMemberPrincipalIds("KC-UNT", "IRB Administrator", null);
                this.will(16.returnValue((Object)adminIds));
            }
        });
        return kimRoleManagementService;
    }

    private RoleService getMockRoleService1() {
        final RoleService kimRoleManagementService = (RoleService)this.context.mock(RoleService.class);
        final HashSet<String> adminIds = new HashSet<String>();
        adminIds.add("10000000001");
        final HashSet<String> aggregatorIds = new HashSet<String>();
        aggregatorIds.add("10000000002");
        final HashSet<String> viewerId = new HashSet<String>();
        viewerId.add("10000000003");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RoleService)this.allowing(kimRoleManagementService)).getRoleMemberPrincipalIds("KC-UNT", "IRB Administrator", null);
                this.will(17.returnValue((Object)adminIds));
                ((RoleService)this.allowing(kimRoleManagementService)).getRoleMemberPrincipalIds("KC-PROTOCOL", "Protocol Aggregator", null);
                this.will(17.returnValue((Object)aggregatorIds));
                ((RoleService)this.allowing(kimRoleManagementService)).getRoleMemberPrincipalIds("KC-PROTOCOL", "Protocol Viewer", null);
                this.will(17.returnValue((Object)viewerId));
            }
        });
        return kimRoleManagementService;
    }

    private KcPersonService getMockKcPersonService() {
        final KcPersonService kcPersonService = (KcPersonService)this.context.mock(KcPersonService.class);
        final KcPerson kcPerson = new KcPerson(){

            public String getUserName() {
                return "quickstart";
            }
        };
        kcPerson.setPersonId("10000000001");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KcPersonService)this.allowing(kcPersonService)).getKcPersonByPersonId("10000000001");
                this.will(19.returnValue((Object)kcPerson));
            }
        });
        return kcPersonService;
    }

    private ProtocolFinderDao getProtocolFinderDao(List<CommitteeScheduleMinute> reviewComments) {
        final ProtocolFinderDao protocolFinderDao = (ProtocolFinderDao)this.context.mock(ProtocolFinderDao.class);
        final ArrayList<20> submissions = new ArrayList<20>();
        ProtocolSubmission submission = new ProtocolSubmission(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        submission.setCommitteeScheduleMinutes(reviewComments);
        submission.setProtocolNumber("001");
        submission.setSubmissionNumber(Integer.valueOf(1));
        submissions.add(submission);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolFinderDao)this.allowing(protocolFinderDao)).findProtocolSubmissions("001", 1);
                this.will(21.returnValue((Object)submissions));
            }
        });
        return protocolFinderDao;
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ProtocolOnlineReview onlineReview = new ProtocolOnlineReview();
        onlineReview.setProtocolOnlineReviewId(PROTOCOL_ONLINE_REVIEW_FK_ID);
        onlineReview.setAdminAccepted(true);
        onlineReview.setReviewerApproved(true);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ProtocolOnlineReview.class, (Object)PROTOCOL_ONLINE_REVIEW_FK_ID);
                this.will(22.returnValue((Object)onlineReview));
            }
        });
        return businessObjectService;
    }

    private CommitteeService getMockCommitteeService() {
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        final ArrayList<CommitteeMembership> members = new ArrayList<CommitteeMembership>();
        CommitteeMembership member = new CommitteeMembership();
        member.setPersonId("10000000005");
        member.setPersonName("chew");
        members.add(member);
        final Committee committee = this.createCommittee();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(committeeService)).getAvailableMembers((String)this.with(23.any(String.class)), (String)this.with(23.any(String.class)));
                this.will(23.returnValue((Object)members));
                ((CommitteeService)this.allowing(committeeService)).getCommitteeById("KC001");
                this.will(23.returnValue((Object)committee));
            }
        });
        return committeeService;
    }

    private Committee createCommittee() {
        Committee committee = new Committee();
        committee.setId(new Long("11111111"));
        committee.setCommitteeId("KC001");
        committee.setCommitteeName("KC IRB 1");
        return committee;
    }

    private CommitteeSchedule createCommitteeSchedule(String id, Committee committee) {
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setCommittee(committee);
        committeeSchedule.setScheduleId(id);
        return committeeSchedule;
    }
}

