/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.risklevel;

import java.sql.Date;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.risklevel.ProtocolAddRiskLevelEvent;
import org.kuali.kra.irb.actions.risklevel.ProtocolAddRiskLevelRule;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.risklevel.ProtocolUpdateRiskLevelEvent;
import org.kuali.kra.irb.actions.risklevel.ProtocolUpdateRiskLevelRule;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolRiskLevelRuleTest
extends ProtocolRuleTestBase {
    private static final String RISK_LEVEL_PROPERTY_NAME = "actionHelper.protocolFullApprovalBean.protocolRiskLevelBean";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        GlobalVariables.clear();
    }

    @Test
    public void testAddOK() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        protocolRiskLevel.setRiskLevelCode("1");
        ProtocolAddRiskLevelEvent event = new ProtocolAddRiskLevelEvent(protocolDocument, RISK_LEVEL_PROPERTY_NAME, protocolRiskLevel);
        ProtocolAddRiskLevelRule rule = new ProtocolAddRiskLevelRule();
        ProtocolRiskLevelRuleTest.assertTrue((boolean)rule.processRules(event));
    }

    @Test
    public void testAddAbsentRiskLevel() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        ProtocolAddRiskLevelEvent event = new ProtocolAddRiskLevelEvent(protocolDocument, RISK_LEVEL_PROPERTY_NAME, protocolRiskLevel);
        ProtocolAddRiskLevelRule rule = new ProtocolAddRiskLevelRule();
        ProtocolRiskLevelRuleTest.assertFalse((boolean)rule.processRules(event));
        this.assertError("actionHelper.protocolFullApprovalBean.protocolRiskLevelBean.newProtocolRiskLevel.riskLevelCode", "error.required");
    }

    @Test
    public void testAddAbsentDateAssigned() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        protocolRiskLevel.setRiskLevelCode("1");
        protocolRiskLevel.setDateAssigned(null);
        ProtocolAddRiskLevelEvent event = new ProtocolAddRiskLevelEvent(protocolDocument, RISK_LEVEL_PROPERTY_NAME, protocolRiskLevel);
        ProtocolAddRiskLevelRule rule = new ProtocolAddRiskLevelRule();
        ProtocolRiskLevelRuleTest.assertFalse((boolean)rule.processRules(event));
        this.assertError("actionHelper.protocolFullApprovalBean.protocolRiskLevelBean.newProtocolRiskLevel.dateAssigned", "error.required");
    }

    @Test
    public void testAddDuplicateRiskLevels() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        protocolRiskLevel.setRiskLevelCode("1");
        protocolRiskLevel.setComments("Original");
        protocolDocument.getProtocol().getProtocolRiskLevels().add(protocolRiskLevel);
        ProtocolRiskLevel duplicateProtocolRiskLevel = new ProtocolRiskLevel();
        duplicateProtocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        duplicateProtocolRiskLevel.setRiskLevelCode("1");
        duplicateProtocolRiskLevel.setComments("Duplicate");
        ProtocolAddRiskLevelEvent event = new ProtocolAddRiskLevelEvent(protocolDocument, RISK_LEVEL_PROPERTY_NAME, duplicateProtocolRiskLevel);
        ProtocolAddRiskLevelRule rule = new ProtocolAddRiskLevelRule();
        ProtocolRiskLevelRuleTest.assertFalse((boolean)rule.processRules(event));
        this.assertError("actionHelper.protocolFullApprovalBean.protocolRiskLevelBean.newProtocolRiskLevel.riskLevelCode", "error.duplicate.risk.level");
    }

    @Test
    public void testAddActiveInactiveStatus() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        protocolRiskLevel.setRiskLevelCode("1");
        protocolRiskLevel.setStatus("A");
        protocolRiskLevel.setComments("Original");
        protocolDocument.getProtocol().getProtocolRiskLevels().add(protocolRiskLevel);
        ProtocolRiskLevel duplicateProtocolRiskLevel = new ProtocolRiskLevel();
        duplicateProtocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        duplicateProtocolRiskLevel.setRiskLevelCode("1");
        duplicateProtocolRiskLevel.setStatus("I");
        duplicateProtocolRiskLevel.setComments("Duplicate");
        ProtocolAddRiskLevelEvent event = new ProtocolAddRiskLevelEvent(protocolDocument, RISK_LEVEL_PROPERTY_NAME, duplicateProtocolRiskLevel);
        ProtocolAddRiskLevelRule rule = new ProtocolAddRiskLevelRule();
        ProtocolRiskLevelRuleTest.assertTrue((boolean)rule.processRules(event));
    }

    @Test
    public void testUpdateOK() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        protocolRiskLevel.setRiskLevelCode("1");
        protocolRiskLevel.setStatus("A");
        protocolRiskLevel.setComments("Original");
        protocolDocument.getProtocol().getProtocolRiskLevels().add(protocolRiskLevel);
        protocolRiskLevel.setStatus("I");
        protocolRiskLevel.setDateInactivated(new Date(System.currentTimeMillis()));
        ProtocolUpdateRiskLevelEvent event = new ProtocolUpdateRiskLevelEvent(protocolDocument, 0);
        ProtocolUpdateRiskLevelRule rule = new ProtocolUpdateRiskLevelRule();
        ProtocolRiskLevelRuleTest.assertTrue((boolean)rule.processRules(event));
    }

    @Test
    public void testUpdateAbsentDateUpdated() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setProtocol((ProtocolBase)protocolDocument.getProtocol());
        protocolRiskLevel.setRiskLevelCode("1");
        protocolRiskLevel.setStatus("A");
        protocolRiskLevel.setComments("Original");
        protocolDocument.getProtocol().getProtocolRiskLevels().add(protocolRiskLevel);
        protocolRiskLevel.setStatus("I");
        ProtocolUpdateRiskLevelEvent event = new ProtocolUpdateRiskLevelEvent(protocolDocument, 0);
        ProtocolUpdateRiskLevelRule rule = new ProtocolUpdateRiskLevelRule();
        ProtocolRiskLevelRuleTest.assertFalse((boolean)rule.processRules(event));
        this.assertError("document.protocol.protocolRiskLevels[" + event.getIndex() + "].dateInactivated", "error.date.inactivated.required");
    }
}

