/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.risklevel;

import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevelServiceImpl;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.util.DateUtils;

public class ProtocolRiskLevelServiceTest
extends KcUnitTestBase {
    private static final String LOW_RISK_CODE = "1";
    private static final String HIGH_RISK_CODE = "5";
    private static final String LOW_RISK_LEVEL_COMMENTS = "Very low risk.";
    private static final String HIGH_RISK_LEVEL_COMMENTS = "Very high risk.";
    private static final String ACTIVE_STATUS = "A";
    private static final String INACTIVE_STATUS = "I";
    private static final java.sql.Date ASSIGNED_DATE = DateUtils.convertToSqlDate((Date)DateUtils.addDays((Date)new java.sql.Date(System.currentTimeMillis()), (int)-1));
    private static final java.sql.Date INACTIVATED_DATE = new java.sql.Date(System.currentTimeMillis());
    private ProtocolRiskLevelServiceImpl service;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolRiskLevelServiceImpl();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        super.tearDown();
    }

    @Test
    public void testAddRiskLevel() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.service.addRiskLevel(this.getLowProtocolRiskLevel(), protocolDocument.getProtocol());
        this.service.addRiskLevel(this.getHighProtocolRiskLevel(), protocolDocument.getProtocol());
        this.verifyPersistRiskLevel(protocolDocument.getProtocol(), 0, LOW_RISK_CODE, ASSIGNED_DATE, LOW_RISK_LEVEL_COMMENTS, ACTIVE_STATUS);
        this.verifyPersistRiskLevel(protocolDocument.getProtocol(), 1, HIGH_RISK_CODE, ASSIGNED_DATE, HIGH_RISK_LEVEL_COMMENTS, INACTIVE_STATUS, INACTIVATED_DATE);
    }

    @Test
    public void testUpdateRiskLevel() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolRiskLevel currentRiskLevel = this.getLowProtocolRiskLevel();
        ProtocolRiskLevel newProtocolRiskLevel = new ProtocolRiskLevel();
        this.service.addRiskLevel(currentRiskLevel, protocolDocument.getProtocol());
        currentRiskLevel.setDateInactivated(INACTIVATED_DATE);
        this.service.updateRiskLevel(currentRiskLevel, newProtocolRiskLevel);
        this.service.addRiskLevel(newProtocolRiskLevel, protocolDocument.getProtocol());
        this.verifyPersistRiskLevel(protocolDocument.getProtocol(), 0, LOW_RISK_CODE, ASSIGNED_DATE, LOW_RISK_LEVEL_COMMENTS, INACTIVE_STATUS, INACTIVATED_DATE);
        this.verifyPersistRiskLevel(protocolDocument.getProtocol(), 1, LOW_RISK_CODE, ASSIGNED_DATE, LOW_RISK_LEVEL_COMMENTS, ACTIVE_STATUS);
    }

    @Test
    public void testDeleteRiskLevel() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.service.addRiskLevel(this.getLowProtocolRiskLevel(), protocolDocument.getProtocol());
        this.service.deleteRiskLevel(0, protocolDocument.getProtocol());
        ProtocolRiskLevelServiceTest.assertEquals((long)0L, (long)protocolDocument.getProtocol().getProtocolRiskLevels().size());
    }

    private ProtocolRiskLevel getLowProtocolRiskLevel() {
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setRiskLevelCode(LOW_RISK_CODE);
        protocolRiskLevel.setDateAssigned(ASSIGNED_DATE);
        protocolRiskLevel.setComments(LOW_RISK_LEVEL_COMMENTS);
        protocolRiskLevel.setStatus(ACTIVE_STATUS);
        return protocolRiskLevel;
    }

    private ProtocolRiskLevel getHighProtocolRiskLevel() {
        ProtocolRiskLevel protocolRiskLevel = new ProtocolRiskLevel();
        protocolRiskLevel.setRiskLevelCode(HIGH_RISK_CODE);
        protocolRiskLevel.setDateAssigned(ASSIGNED_DATE);
        protocolRiskLevel.setComments(HIGH_RISK_LEVEL_COMMENTS);
        protocolRiskLevel.setStatus(INACTIVE_STATUS);
        protocolRiskLevel.setDateInactivated(INACTIVATED_DATE);
        return protocolRiskLevel;
    }

    private void verifyPersistRiskLevel(Protocol protocol, int index, String expectedRiskLevelCode, java.sql.Date expectedDateAssigned, String expectedComments, String expectedStatus) {
        this.verifyPersistRiskLevel(protocol, index, expectedRiskLevelCode, expectedDateAssigned, expectedComments, expectedStatus, null);
    }

    private void verifyPersistRiskLevel(Protocol protocol, int index, String expectedRiskLevelCode, java.sql.Date expectedDateAssigned, String expectedComments, String expectedStatus, java.sql.Date expectedDateUpdated) {
        ProtocolRiskLevel protocolRiskLevel = this.findProtocolRiskLevel(protocol, index);
        ProtocolRiskLevelServiceTest.assertEquals((Object)protocolRiskLevel.getProtocolId(), (Object)protocol.getProtocolId());
        ProtocolRiskLevelServiceTest.assertEquals((Object)expectedRiskLevelCode, (Object)protocolRiskLevel.getRiskLevelCode());
        ProtocolRiskLevelServiceTest.assertEquals((Object)expectedDateAssigned, (Object)protocolRiskLevel.getDateAssigned());
        ProtocolRiskLevelServiceTest.assertEquals((Object)expectedComments, (Object)protocolRiskLevel.getComments());
        ProtocolRiskLevelServiceTest.assertEquals((Object)expectedStatus, (Object)protocolRiskLevel.getStatus());
        ProtocolRiskLevelServiceTest.assertEquals((Object)expectedDateUpdated, (Object)protocolRiskLevel.getDateInactivated());
    }

    private ProtocolRiskLevel findProtocolRiskLevel(Protocol protocol, int index) {
        List riskLevels = protocol.getProtocolRiskLevels();
        ProtocolRiskLevelServiceTest.assertTrue((index + 1 <= riskLevels.size() ? 1 : 0) != 0);
        return (ProtocolRiskLevel)riskLevels.get(index);
    }
}

