/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.irb.actions.submit.CheckListServiceImpl;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class CheckListServiceTest {
    private CheckListServiceImpl checkListService;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() {
        this.checkListService = new CheckListServiceImpl();
    }

    @Test
    public void testExpeditedReviews() {
        final ArrayList<ExpeditedReviewCheckListItem> list = new ArrayList<ExpeditedReviewCheckListItem>();
        list.add(new ExpeditedReviewCheckListItem());
        list.add(new ExpeditedReviewCheckListItem());
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findAll(ExpeditedReviewCheckListItem.class);
                this.will(1.returnValue((Object)list));
            }
        });
        this.checkListService.setBusinessObjectService(businessObjectService);
        List items = this.checkListService.getExpeditedReviewCheckList();
        Assert.assertEquals((long)list.size(), (long)items.size());
        for (ExpeditedReviewCheckListItem item : items) {
            Assert.assertTrue((boolean)list.contains(item));
        }
    }

    @Test
    public void testExemptStudies() {
        final ArrayList<ExemptStudiesCheckListItem> list = new ArrayList<ExemptStudiesCheckListItem>();
        list.add(new ExemptStudiesCheckListItem());
        list.add(new ExemptStudiesCheckListItem());
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findAll(ExemptStudiesCheckListItem.class);
                this.will(2.returnValue((Object)list));
            }
        });
        this.checkListService.setBusinessObjectService(businessObjectService);
        List items = this.checkListService.getExemptStudiesCheckList();
        Assert.assertEquals((long)list.size(), (long)items.size());
        for (ExemptStudiesCheckListItem item : items) {
            Assert.assertTrue((boolean)list.contains(item));
        }
    }
}

