/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.submit.ProtocolActionAjaxServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerType;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolActionAjaxServiceTest
extends KcUnitTestBase {
    private ProtocolActionAjaxServiceImpl protocolActionAjaxService;
    private Mockery context = new JUnit4Mockery();
    private static final String DOC_FORM_KEY = "1";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.protocolActionAjaxService = new ProtocolActionAjaxServiceImpl();
        ProtocolForm protocolForm = new ProtocolForm(){
            ActionHelper actionHelper1 = new ActionHelper(this){

                public boolean getCanSubmitProtocol() {
                    return true;
                }
            };

            public ActionHelper getActionHelper() {
                return this.actionHelper1;
            }
        };
        GlobalVariables.getUserSession().addObject(DOC_FORM_KEY, (Object)protocolForm);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        GlobalVariables.getUserSession().removeObject(DOC_FORM_KEY);
    }

    @Test
    public void testValidCommitteeDates() throws Exception {
        final ArrayList<ConcreteKeyValue> list = new ArrayList<ConcreteKeyValue>();
        list.add(new ConcreteKeyValue("0", "dog"));
        list.add(new ConcreteKeyValue(DOC_FORM_KEY, "cat"));
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.one(committeeService)).getAvailableCommitteeDates("foo");
                this.will(2.returnValue((Object)list));
            }
        });
        this.protocolActionAjaxService.setCommitteeService((CommitteeServiceBase)committeeService);
        String s = "0;dog;1;cat";
        ProtocolActionAjaxServiceTest.assertEquals((Object)"0;dog;1;cat", (Object)s);
    }

    @Test
    public void testReviewers() {
        final ArrayList<CommitteeMembership> members = new ArrayList<CommitteeMembership>();
        members.add(this.createMember("dn", "Don", null));
        members.add(this.createMember("nncy", "Nancy", 1));
        members.add(this.createMember(null, "Joe", 2));
        members.add(this.createMember(null, "Joanna", 5));
        final HashMap<String, String> hm1 = new HashMap<String, String>();
        hm1.put("protocolId", "p1");
        final HashMap<String, String> hm2 = new HashMap<String, String>();
        hm2.put("protocolId", "p2");
        Protocol protocol1 = new Protocol(){
            private static final long serialVersionUID = -1273061983131550371L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        final List<Protocol> l1 = Arrays.asList(protocol1);
        Protocol protocol2 = new Protocol(){
            private static final long serialVersionUID = -1273061983131550372L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        final List<Protocol> l2 = Arrays.asList(protocol2);
        ProtocolPerson pp1 = this.createProtocolPerson("dn", 10);
        ProtocolPerson pp2 = this.createProtocolPerson("nncy", null);
        ProtocolPerson pp3 = this.createProtocolPerson(null, 1);
        ProtocolPerson pp4 = this.createProtocolPerson("", 2);
        ProtocolPerson pp5 = this.createProtocolPerson(null, 5);
        protocol1.getProtocolPersons().add(pp1);
        protocol1.getProtocolPersons().add(pp2);
        protocol2.getProtocolPersons().add(pp3);
        protocol2.getProtocolPersons().add(pp4);
        protocol2.getProtocolPersons().add(pp5);
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(committeeService)).getAvailableMembers("foo", "0");
                this.will(5.returnValue((Object)members));
            }
        });
        final BusinessObjectService businessObjectService1 = (BusinessObjectService)this.context.mock(BusinessObjectService.class, "name1");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService1)).findMatching(Protocol.class, (Map)hm1);
                this.will(6.returnValue((Object)l1));
            }
        });
        final BusinessObjectService businessObjectService2 = (BusinessObjectService)this.context.mock(BusinessObjectService.class, "name2");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.allowing(businessObjectService2)).findMatching(Protocol.class, (Map)hm2);
                this.will(7.returnValue((Object)l2));
            }
        });
        this.protocolActionAjaxService.setCommitteeService((CommitteeServiceBase)committeeService);
        this.protocolActionAjaxService.setBusinessObjectService(businessObjectService1);
        String s = "2;Joe;Y;5;Joanna;Y";
        ProtocolActionAjaxServiceTest.assertEquals((Object)"2;Joe;Y;5;Joanna;Y", (Object)s);
        this.protocolActionAjaxService.setBusinessObjectService(businessObjectService2);
        s = "dn;Don;N;nncy;Nancy;N";
        ProtocolActionAjaxServiceTest.assertEquals((Object)"dn;Don;N;nncy;Nancy;N", (Object)s);
        protocol2.getProtocolPersons().clear();
        s = "dn;Don;N;nncy;Nancy;N;2;Joe;Y;5;Joanna;Y";
        ProtocolActionAjaxServiceTest.assertEquals((Object)"dn;Don;N;nncy;Nancy;N;2;Joe;Y;5;Joanna;Y", (Object)s);
    }

    @Test
    public void testReviewerTypes() {
        final ArrayList<ProtocolReviewerType> reviewerTypes = new ArrayList<ProtocolReviewerType>();
        reviewerTypes.add(this.createReviewerType(DOC_FORM_KEY, "primary"));
        reviewerTypes.add(this.createReviewerType("2", "secondary"));
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findAll(ProtocolReviewerType.class);
                this.will(8.returnValue((Object)reviewerTypes));
            }
        });
        this.protocolActionAjaxService.setBusinessObjectService(businessObjectService);
        String s = this.protocolActionAjaxService.getReviewerTypes();
        ProtocolActionAjaxServiceTest.assertEquals((Object)"1;primary;2;secondary", (Object)s);
    }

    private ProtocolReviewerType createReviewerType(String typeCode, String description) {
        ProtocolReviewerType reviewerType = new ProtocolReviewerType();
        reviewerType.setReviewerTypeCode(typeCode);
        reviewerType.setDescription(description);
        return reviewerType;
    }

    private CommitteeMembership createMember(String personId, String personName, Integer rolodexId) {
        CommitteeMembership member = new CommitteeMembership();
        member.setPersonId(personId);
        member.setPersonName(personName);
        member.setRolodexId(rolodexId);
        return member;
    }

    private ProtocolPerson createProtocolPerson(String personId, Integer rolodexId) {
        ProtocolPerson pp = new ProtocolPerson();
        pp.setPersonId(personId);
        pp.setRolodexId(rolodexId);
        return pp;
    }
}

