/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDao;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.submit.ProtocolActionServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolActionServiceTestBase;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReview;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.followup.FollowupActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolActionServiceTest
extends ProtocolActionServiceTestBase {
    private Mockery context;
    private Protocol protocol;
    private ProtocolActionServiceImpl protocolActionService;
    private BusinessObjectService businessObjectService;
    private ProtocolDao dao;

    @Override
    @Before
    public void setUp() {
        this.context = new JUnit4Mockery();
        this.protocol = ProtocolActionServiceTest.getProtocol(this.context);
        this.protocolActionService = new ProtocolActionServiceImpl();
        this.businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.protocolActionService.setBusinessObjectService(this.businessObjectService);
        this.protocolActionService.setFollowupActionService((FollowupActionService)KraServiceLocator.getService(org.kuali.kra.irb.actions.followup.FollowupActionService.class));
        this.dao = (ProtocolDao)this.context.mock(ProtocolDao.class);
        this.protocolActionService.setProtocolDao((org.kuali.kra.protocol.ProtocolDao)this.dao);
        try {
            this.protocolActionService.setRuleFiles(this.getRuleFiles());
        }
        catch (Exception e) {
            // empty catch block
        }
        ProtocolSubmission protocolSubmission = this.getProtocolSubmission();
        protocolSubmission.setScheduleIdFk(Long.valueOf(1L));
        this.protocol.setProtocolSubmission((ProtocolSubmissionBase)protocolSubmission);
        this.protocol.getProtocolSubmissions().add(protocolSubmission);
        this.protocol.setProtocolNumber("001Z");
    }

    private ProtocolSubmission getProtocolSubmission() {
        ProtocolSubmission protocolSubmission = new ProtocolSubmission(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        return protocolSubmission;
    }

    private ProtocolAction getProtocolAction() {
        ProtocolAction protocolAction = new ProtocolAction(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        return protocolAction;
    }

    private void mockMinutes() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                fieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                fieldValues.put("submissionNumber", ProtocolActionServiceTest.this.protocol.getProtocolSubmission().getSubmissionNumber());
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).countMatching(CommitteeScheduleMinute.class, fieldValues);
                this.will(3.returnValue((Object)1));
            }
        });
    }

    private void mockSubmissionTrue(final String submissionTypeCode) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionStatusCode", ProtocolActionServiceTest.this.getPendingSubmissionStatusCodes());
                HashMap<String, String> negativeFieldValues = new HashMap<String, String>();
                negativeFieldValues.put("submissionTypeCode", submissionTypeCode);
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).countMatching(ProtocolSubmission.class, positiveFieldValues, negativeFieldValues);
                this.will(4.returnValue((Object)0));
            }
        });
    }

    private void mockSubmissionFalse(final String submissionTypeCode) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionStatusCode", ProtocolActionServiceTest.this.getPendingSubmissionStatusCodes());
                HashMap<String, String> negativeFieldValues = new HashMap<String, String>();
                negativeFieldValues.put("submissionTypeCode", submissionTypeCode);
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).countMatching(ProtocolSubmission.class, positiveFieldValues, negativeFieldValues);
                this.will(5.returnValue((Object)0));
            }
        });
    }

    private void mockSubmissionTrueCondt1() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionStatusCode", ProtocolActionServiceTest.this.getPendingSubmissionStatusCodes());
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).countMatching(ProtocolSubmission.class, positiveFieldValues);
                this.will(6.returnValue((Object)0));
            }
        });
    }

    private void mockSubmissionTrueCondt2(final String submissionTypeCode) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionStatusCode", ProtocolActionServiceTest.this.getPendingSubmissionStatusCodes());
                positiveFieldValues.put("submissionTypeCode", submissionTypeCode);
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).countMatching(ProtocolSubmission.class, positiveFieldValues);
                this.will(7.returnValue((Object)0));
            }
        });
    }

    private void mockSubmissionFalseCondt2(final String submissionTypeCode) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionStatusCode", ProtocolActionServiceTest.this.getPendingSubmissionStatusCodes());
                positiveFieldValues.put("submissionTypeCode", submissionTypeCode);
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).countMatching(ProtocolSubmission.class, positiveFieldValues);
                this.will(8.returnValue((Object)1));
            }
        });
    }

    private void mockSubmissionCondt3(final boolean cond) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionStatusCode", ProtocolActionServiceTest.this.getPendingSubmissionStatusCodes());
                positiveFieldValues.put("submissionTypeCode", Arrays.asList("113", "110", "108", "109", "111", "114"));
                ArrayList list = new ArrayList();
                int retVal = 0;
                if (!cond) {
                    retVal = 1;
                }
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).countMatching(ProtocolSubmission.class, positiveFieldValues);
                this.will(9.returnValue((Object)retVal));
            }
        });
    }

    private void mockSubmissionCondt5() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                ProtocolSubmission protocolSubmission = ProtocolActionServiceTest.this.getProtocolSubmission();
                protocolSubmission.setSubmissionStatusCode("200");
                ArrayList<ProtocolSubmission> submissions = new ArrayList<ProtocolSubmission>();
                submissions.add(protocolSubmission);
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).findMatchingOrderBy(ProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
                this.will(10.returnValue(submissions));
            }
        });
    }

    private void mockSubmissionForWithdraw() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                ProtocolSubmission protocolSubmission = ProtocolActionServiceTest.this.getProtocolSubmission();
                protocolSubmission.setSubmissionStatusCode("201");
                ArrayList<ProtocolSubmission> submissions = new ArrayList<ProtocolSubmission>();
                submissions.add(protocolSubmission);
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).findMatchingOrderBy(ProtocolSubmission.class, positiveFieldValues, "submissionNumber", false);
                this.will(11.returnValue(submissions));
            }
        });
    }

    private void mockSubmissionCondt4(final boolean flag) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionNumber", ProtocolActionServiceTest.this.protocol.getProtocolSubmission().getSubmissionNumber());
                ArrayList<ProtocolSubmission> list = new ArrayList<ProtocolSubmission>();
                if (flag) {
                    ProtocolSubmission ps = new ProtocolSubmission();
                    ps.setScheduleId("123");
                    list.add(ps);
                }
                ((BusinessObjectService)this.allowing(ProtocolActionServiceTest.this.businessObjectService)).findMatching(ProtocolSubmission.class, positiveFieldValues);
                this.will(12.returnValue(list));
            }
        });
    }

    private void mockProtocolDaoCondt1() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> positiveFieldValues = new HashMap<String, Object>();
                positiveFieldValues.put("protocolNumber", ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                positiveFieldValues.put("sequenceNumber", ProtocolActionServiceTest.this.protocol.getSequenceNumber());
                positiveFieldValues.put("submissionStatusCode", ProtocolActionServiceTest.this.getPendingSubmissionStatusCodes());
                ((ProtocolDao)this.allowing(ProtocolActionServiceTest.this.dao)).getProtocolSubmissionCountFromProtocol(ProtocolActionServiceTest.this.protocol.getProtocolNumber());
                this.will(13.returnValue((Object)true));
            }
        });
    }

    private List<String> getPendingSubmissionStatusCodes() {
        ArrayList<String> submissionStatusCodes = new ArrayList<String>();
        submissionStatusCodes.add("100");
        submissionStatusCodes.add("101");
        submissionStatusCodes.add("102");
        return submissionStatusCodes;
    }

    @Test
    public void testActionTypeCode200() {
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        this.protocol.getProtocolSubmission().setScheduleId("NotNULL");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("200", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode201() {
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("201", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode202() {
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("102");
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("2");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("202", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("2");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("202", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode202ReviewTypeCodeNot1or2() {
        this.mockMinutes();
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("0");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("202", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode204() {
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("204", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode203() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("2");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("203", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("3");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("203", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode203ReviewTypeCodeNot1or2() {
        this.mockMinutes();
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("0");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("203", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode300Contd1() {
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("109");
        this.mockSubmissionTrue("109");
        this.protocol.setProtocolStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("102");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("104");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("105");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("106");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("304");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode300Contd2() {
        this.mockSubmissionFalse("109");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("Not102");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("109");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("102");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("104");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("304");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("300", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode301Contd1() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.mockSubmissionTrue("108");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("108");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("305");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode301Contd2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.mockSubmissionFalse("108");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("Not102");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("108");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("305");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("301", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode305() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.mockSubmissionTrueCondt1();
        this.mockProtocolDaoCondt1();
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("304");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("310");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("305", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode302Contd1() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("Not102");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("110");
        this.mockSubmissionTrue("110");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("302", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("302", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("302", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("302", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode302Contd2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.protocol.setProtocolStatusCode("201");
        this.mockSubmissionTrue("110");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("110");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("302", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode306Contd1() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("Not102");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("110");
        this.mockSubmissionTrue("110");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("306", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("306", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("306", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("306", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode306Contd2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.mockSubmissionTrue("110");
        this.protocol.setProtocolStatusCode("201");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("110");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("306", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode303Cond1() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("303", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("303", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("102");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("303", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("303", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("303", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode303Cond2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.mockSubmissionForWithdraw();
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("303", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode304ReviewTypeCodeNot2or3() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("0");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("304", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode304ReviewTypeCode2or3() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("2");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("304", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("304", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("102");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("304", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("3");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("304", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("304", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("102");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("304", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode103() {
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("103", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode102() {
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("305");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("102", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode205ReviewTypeCode2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        ArrayList<ProtocolOnlineReview> reviews = new ArrayList<ProtocolOnlineReview>();
        ProtocolOnlineReview review = new ProtocolOnlineReview();
        ProtocolReviewer reviewer = new ProtocolReviewer();
        review.setProtocolReviewer((org.kuali.kra.protocol.actions.submit.ProtocolReviewer)reviewer);
        reviews.add(review);
        this.protocol.getProtocolSubmission().setProtocolOnlineReviews(reviews);
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("2");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("205", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("205", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode208ReviewTypeCode6() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        ArrayList<ProtocolOnlineReview> reviews = new ArrayList<ProtocolOnlineReview>();
        ProtocolOnlineReview review = new ProtocolOnlineReview();
        ProtocolReviewer reviewer = new ProtocolReviewer();
        review.setProtocolReviewer((org.kuali.kra.protocol.actions.submit.ProtocolReviewer)reviewer);
        reviews.add(review);
        this.protocol.getProtocolSubmission().setProtocolOnlineReviews(reviews);
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("6");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("208", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("208", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode209ReviewTypeCode6() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("112");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("209", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("209", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode206ReviewTypeCode3() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("3");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("206", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("206", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode210ReviewTypeCode5() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(1));
        this.protocol.getProtocolSubmission().setProtocolReviewTypeCode("5");
        this.protocol.setProtocolStatusCode("101");
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("210", (ProtocolBase)this.protocol));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("210", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode104True() {
        this.mockSubmissionCondt3(true);
        this.mockSubmissionCondt5();
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode104False() {
        this.mockSubmissionCondt3(false);
        this.mockSubmissionCondt5();
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("104", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode105True() {
        this.mockSubmissionCondt3(true);
        this.mockSubmissionCondt5();
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode105False() {
        this.mockSubmissionCondt3(false);
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("105", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode106True() {
        this.mockSubmissionCondt3(true);
        this.mockSubmissionCondt5();
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode106False() {
        this.mockSubmissionCondt3(false);
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("106", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode108True() {
        this.mockSubmissionCondt3(true);
        this.mockSubmissionCondt5();
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("108", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode108False() {
        this.mockSubmissionCondt3(false);
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("108", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode207Cond1True() {
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("111");
        this.mockSubmissionTrue("111");
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("207", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode207Cond2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("NOT210");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("111");
        this.mockSubmissionTrue("111");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("207", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode109Cond2() {
        this.protocol.setSequenceNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.mockSubmissionCondt4(false);
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("100");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("109", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode999() {
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("101");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("999", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode114True() {
        this.mockSubmissionCondt3(true);
        this.mockSubmissionCondt5();
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("114", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("114", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode114False() {
        this.mockSubmissionCondt3(false);
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("114", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("114", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode115True() {
        this.mockSubmissionCondt3(true);
        this.mockSubmissionCondt5();
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("115", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode115False() {
        this.mockSubmissionCondt3(false);
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertFalse((boolean)this.protocolActionService.canPerformAction("115", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode211Cond1() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("NOT210");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("113");
        this.mockSubmissionTrue("113");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("211", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("211", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode211Cond2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.protocol.setSequenceNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("113");
        this.mockSubmissionTrue("113");
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("211", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("211", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode212Cond1() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("NOT210");
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("114");
        this.mockSubmissionTrue("114");
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("212", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode212Cond2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(null);
        this.protocol.setProtocolStatusCode("201");
        this.protocol.setSequenceNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionTypeCode("114");
        this.mockSubmissionTrue("114");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("212", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode116() {
        this.protocol.setProtocolStatusCode("200");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("201");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("202");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("203");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("300");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("301");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("302");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("304");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("305");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("306");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("307");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("308");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
        this.protocol.setProtocolStatusCode("311");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("116", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode119Cond1() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("202");
        this.protocol.setProtocolStatusCode("102");
        ProtocolPerson person = new ProtocolPerson();
        person.setPersonId("10000000001");
        person.setProtocolPersonRoleId("PI");
        this.protocol.getProtocolPersons().add(person);
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("119", (ProtocolBase)this.protocol));
    }

    @Test
    public void testActionTypeCode119Cond2() {
        this.protocol.getProtocolSubmission().setSubmissionNumber(Integer.valueOf(123));
        this.protocol.getProtocolSubmission().setSubmissionStatusCode("201");
        this.protocol.setProtocolStatusCode("104");
        ProtocolPerson person = new ProtocolPerson();
        person.setPersonId("10000000001");
        person.setProtocolPersonRoleId("PI");
        this.protocol.getProtocolPersons().add(person);
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.canPerformAction("119", (ProtocolBase)this.protocol));
    }

    private void createNewDefaultProtocolAction(String protocolActionTypeCode, String committeeDecisionMotionTypeCode) {
        ProtocolAction protocolAction = this.getProtocolAction();
        protocolAction.setActionId(Integer.valueOf(1));
        protocolAction.setActionDate(new Timestamp(System.currentTimeMillis()));
        protocolAction.setActualActionDate(new Timestamp(System.currentTimeMillis()));
        protocolAction.setProtocol((ProtocolBase)this.protocol);
        protocolAction.setSubmissionNumber(this.protocol.getProtocolSubmission().getSequenceNumber());
        protocolAction.setProtocolActionTypeCode(protocolActionTypeCode);
        this.protocol.getProtocolSubmission().setSubmissionId(Long.valueOf(1L));
        protocolAction.setSubmissionIdFk(this.protocol.getProtocolSubmission().getSubmissionId());
        protocolAction.setProtocolSubmission((ProtocolSubmissionBase)this.protocol.getProtocolSubmission());
        protocolAction.getProtocolSubmission().setCommitteeDecisionMotionTypeCode(committeeDecisionMotionTypeCode);
        this.protocol.getProtocolActions().add(protocolAction);
        protocolAction.setActionDate(new Timestamp(new Date().getTime()));
    }

    @Test
    public void testIsApproveActionOpenForFollowup() {
        this.createNewDefaultProtocolAction("308", "1");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.isActionOpenForFollowup("204", (ProtocolBase)this.protocol));
    }

    @Test
    public void testIsDisapproveActionOpenForFollowup() {
        this.createNewDefaultProtocolAction("308", "2");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.isActionOpenForFollowup("304", (ProtocolBase)this.protocol));
    }

    @Test
    public void testIsReturnForSMRActionOpenForFollowup() {
        this.createNewDefaultProtocolAction("308", "3");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.isActionOpenForFollowup("203", (ProtocolBase)this.protocol));
    }

    @Test
    public void testIsReturnForSRRActionOpenForFollowup() {
        this.createNewDefaultProtocolAction("308", "4");
        ProtocolActionServiceTest.assertTrue((boolean)this.protocolActionService.isActionOpenForFollowup("202", (ProtocolBase)this.protocol));
    }

    private List<String> getRuleFiles() {
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionForLeadUnitRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionToSubmitRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionToCommitteeMemberRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionForSpecialRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/canPerformProtocolActionRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/updateProtocolRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/undoProtocolUpdateRules.drl");
        return ruleFiles;
    }
}

