/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolRouteTest
extends KcUnitTestBase {
    private static final String SUMMARY = "my test summary";
    private ProtocolSubmitActionService protocolSubmitActionService;
    private DocumentService documentService;
    private ProtocolAmendRenewService protocolAmendRenewService;
    private ProtocolFinderDao protocolFinder;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.protocolSubmitActionService = (ProtocolSubmitActionService)KraServiceLocator.getService(ProtocolSubmitActionService.class);
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.protocolAmendRenewService = (ProtocolAmendRenewService)KraServiceLocator.getService(ProtocolAmendRenewService.class);
        this.protocolFinder = (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.protocolSubmitActionService = null;
        this.documentService = null;
        this.protocolAmendRenewService = null;
        this.protocolFinder = null;
        super.tearDown();
    }

    @Test
    public void runApprovedTest() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), this.getMockSubmitAction());
        this.documentService.routeDocument((Document)protocolDocument, null, null);
        this.documentService.blanketApproveDocument((Document)protocolDocument, null, null);
        WorkflowDocument workflowDoc = this.getWorkflowDocument((Document)protocolDocument);
        WorkflowDocumentActionsService info = (WorkflowDocumentActionsService)GlobalResourceLoader.getService((String)"rice.kew.workflowDocumentActionsService");
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
        DocumentDetail results1 = info.executeSimulation(reportCriteriaBuilder.build());
        for (ActionRequest actionRequest : results1.getActionRequests()) {
            if (!actionRequest.isPending() || !actionRequest.getActionRequested().getCode().equalsIgnoreCase("K")) continue;
            System.out.println(actionRequest.getPrincipalId() + " | " + actionRequest.getGroupId());
            System.out.println(actionRequest.getNodeName());
        }
        ProtocolRouteTest.assertTrue((boolean)workflowDoc.isFinal());
        ProtocolRouteTest.assertTrue((boolean)protocolDocument.getProtocol().isActive());
    }

    @Test
    public void runDisapprovedTest() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument("0906000002");
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), this.getMockSubmitAction());
        this.documentService.routeDocument((Document)protocolDocument, null, null);
        this.documentService.disapproveDocument((Document)protocolDocument, null);
        ProtocolRouteTest.assertTrue((boolean)this.getWorkflowDocument((Document)protocolDocument).isDisapproved());
    }

    @Test
    public void runAmendmentTest() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument("0906000003");
        ProtocolSubmitAction submitAction = this.getMockSubmitAction();
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), submitAction);
        this.documentService.routeDocument((Document)protocolDocument, null, null);
        this.documentService.blanketApproveDocument((Document)protocolDocument, null, null);
        String docNbr = this.protocolAmendRenewService.createAmendment((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean)this.getMockProtocolAmendmentBean());
        ProtocolDocument amendmentDocument = (ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(docNbr);
        this.protocolSubmitActionService.submitToIrbForReview(amendmentDocument.getProtocol(), submitAction);
        this.documentService.routeDocument((Document)amendmentDocument, null, null);
        this.documentService.blanketApproveDocument((Document)amendmentDocument, null, null);
        ProtocolRouteTest.assertTrue((boolean)this.getWorkflowDocument((Document)amendmentDocument).isFinal());
        Protocol newProtocol = this.protocolFinder.findCurrentProtocolByNumber(protocolDocument.getProtocol().getProtocolNumber());
        ProtocolRouteTest.assertTrue((newProtocol.getSequenceNumber() == protocolDocument.getProtocol().getSequenceNumber() + 1 ? 1 : 0) != 0);
        protocolDocument = (ProtocolDocument)this.documentService.getByDocumentHeaderId(protocolDocument.getDocumentNumber());
        ProtocolRouteTest.assertFalse((boolean)protocolDocument.getProtocol().isActive());
        ProtocolRouteTest.assertFalse((boolean)amendmentDocument.getProtocol().isActive());
        ProtocolRouteTest.assertTrue((boolean)newProtocol.isActive());
        this.verifyProtocolAction(newProtocol, "204");
    }

    private void verifyProtocolAction(Protocol protocol, String actionTypeCode) {
        List actions = protocol.getProtocolActions();
        for (ProtocolAction action : actions) {
            if (!StringUtils.equals((String)actionTypeCode, (String)action.getProtocolActionTypeCode())) continue;
            return;
        }
        ProtocolRouteTest.assertTrue((String)(actionTypeCode + " not found"), (boolean)false);
    }

    private WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                ProtocolRouteTest.assertTrue((String)"workflow document not found", (boolean)false);
            }
        }
        return workflowDocument;
    }

    private ProtocolSubmitAction getMockSubmitAction() {
        final ProtocolSubmitAction action = (ProtocolSubmitAction)this.context.mock(ProtocolSubmitAction.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionTypeCode();
                this.will(2.returnValue((Object)"100"));
                ((ProtocolSubmitAction)this.allowing(action)).getProtocolReviewTypeCode();
                this.will(2.returnValue((Object)"1"));
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionQualifierTypeCode();
                this.will(2.returnValue((Object)"2"));
                ((ProtocolSubmitAction)this.allowing(action)).getNewCommitteeId();
                this.will(2.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getNewScheduleId();
                this.will(2.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getReviewers();
                this.will(2.returnValue(new ArrayList()));
            }
        });
        return action;
    }

    private ProtocolAmendmentBean getMockProtocolAmendmentBean() {
        final ProtocolAmendmentBean bean = (ProtocolAmendmentBean)this.context.mock(ProtocolAmendmentBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAmendmentBean)this.allowing(bean)).getSummary();
                this.will(3.returnValue((Object)ProtocolRouteTest.SUMMARY));
                ((ProtocolAmendmentBean)this.allowing(bean)).getGeneralInfo();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getFundingSource();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolReferencesAndOtherIdentifiers();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolOrganizations();
                this.will(3.returnValue((Object)true));
                ((ProtocolAmendmentBean)this.allowing(bean)).getSubjects();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getAddModifyAttachments();
                this.will(3.returnValue((Object)true));
                ((ProtocolAmendmentBean)this.allowing(bean)).getAreasOfResearch();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getSpecialReview();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolPersonnel();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getOthers();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getProtocolPermissions();
                this.will(3.returnValue((Object)false));
                ((ProtocolAmendmentBean)this.allowing(bean)).getQuestionnaire();
                this.will(3.returnValue((Object)false));
            }
        });
        return bean;
    }
}

