/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionRule;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolSubmitActionRuleTest
extends ProtocolRuleTestBase {
    private Mockery context = new JUnit4Mockery();
    private ProtocolSubmitActionRule rule = null;
    private static final String VALID_SUBMISSION_TYPE = "100";
    private static final String VALID_REVIEW_TYPE = "1";
    private static final String INVALID_SUBMISSION_TYPE = "ahfgdfsgr#%$#$%#$%";
    private static final String INVALID_REVIEW_TYPE = "ahfgdfsgr#%$#$%#$%";
    private static final String COMMITTEE_ID = "1";
    private static final String SCHEDULE_ID = "1";
    private static final String MANDATORY = "M";
    private static final String OPTIONAL = "O";
    private ParameterService parameterService;

    @Before
    public void setUpServices() {
        this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProtocolSubmitActionRule(){

            public boolean checkNoSpoofing(ProtocolSubmitAction submitAction) {
                return true;
            }
        };
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Ignore
    @Test
    public void testSubmitOK() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("1");
        ProtocolSubmitActionRuleTest.assertTrue((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        ProtocolSubmitActionRuleTest.assertEquals((long)GlobalVariables.getMessageMap().getErrorMessages().size(), (long)0L);
    }

    @Test
    public void testSubmissionTypeEmpty() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode("");
        submitAction.setProtocolReviewTypeCode("1");
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction.submissionTypeCode", "error.protocol.submissionTypeCode.notFound");
    }

    @Test
    public void testReviewTypeEmpty() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("");
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.notFound");
    }

    @Test
    public void testReviewTypeInvalid() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("ahfgdfsgr#%$#$%#$%");
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.invalid");
    }

    @Ignore
    @Test
    public void testExemptCheckListOK() throws WorkflowException {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        ArrayList<ExemptStudiesCheckListItem> checkList = new ArrayList<ExemptStudiesCheckListItem>();
        ExemptStudiesCheckListItem item = new ExemptStudiesCheckListItem();
        item.setChecked(true);
        checkList.add(item);
        submitAction.setExemptStudiesCheckList(checkList);
        submitAction.setProtocolReviewTypeCode("3");
        ProtocolSubmitActionRuleTest.assertTrue((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        ProtocolSubmitActionRuleTest.assertEquals((long)GlobalVariables.getMessageMap().getErrorMessages().size(), (long)0L);
    }

    @Test
    public void testExemptCheckListNone() throws WorkflowException {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("3");
        ArrayList checkList = new ArrayList();
        ExemptStudiesCheckListItem item = new ExemptStudiesCheckListItem();
        item.setChecked(false);
        submitAction.setExemptStudiesCheckList(checkList);
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction", "error.protocol.checkList.one");
    }

    @Ignore
    @Test
    public void testExpeditedCheckListOK() throws WorkflowException {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        ArrayList<ExpeditedReviewCheckListItem> checkList = new ArrayList<ExpeditedReviewCheckListItem>();
        ExpeditedReviewCheckListItem item = new ExpeditedReviewCheckListItem();
        item.setChecked(true);
        checkList.add(item);
        submitAction.setExpeditedReviewCheckList(checkList);
        submitAction.setProtocolReviewTypeCode("2");
        ProtocolSubmitActionRuleTest.assertTrue((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        ProtocolSubmitActionRuleTest.assertEquals((long)GlobalVariables.getMessageMap().getErrorMessages().size(), (long)0L);
    }

    @Test
    public void testExpeditedCheckListNone() throws WorkflowException {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("2");
        ArrayList checkList = new ArrayList();
        ExpeditedReviewCheckListItem item = new ExpeditedReviewCheckListItem();
        item.setChecked(false);
        submitAction.setExpeditedReviewCheckList(checkList);
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction", "error.protocol.checkList.one");
    }

    @Ignore
    @Test
    public void testOKReviewers() throws WorkflowException {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("1");
        ProtocolReviewerBean reviewer = new ProtocolReviewerBean();
        reviewer.setReviewerTypeCode("");
        submitAction.getReviewers().add(reviewer);
        reviewer = new ProtocolReviewerBean();
        reviewer.setReviewerTypeCode("1");
        submitAction.getReviewers().add(reviewer);
        ProtocolSubmitActionRuleTest.assertTrue((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        ProtocolSubmitActionRuleTest.assertEquals((long)GlobalVariables.getMessageMap().getErrorMessages().size(), (long)0L);
    }

    @Test
    public void testInvalidReviewerType() throws WorkflowException {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("1");
        ProtocolReviewerBean reviewer = new ProtocolReviewerBean();
        reviewer.setReviewerTypeCode("xx");
        submitAction.getReviewers().add(reviewer);
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction.reviewer[0].reviewerTypeCode", "error.protocol.reviewerTypeCode.invalid");
    }

    @Test
    public void testNoSpoofing() throws WorkflowException {
        this.rule = new ProtocolSubmitActionRule();
        final ArrayList<CommitteeMembership> members = new ArrayList<CommitteeMembership>();
        members.add(this.createMember("dn", "Don", null));
        members.add(this.createMember("nncy", "Nancy", 1));
        members.add(this.createMember(null, "Joe", 2));
        members.add(this.createMember(null, "Joanna", 5));
        final CommitteeService committeeService = (CommitteeService)this.context.mock(CommitteeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CommitteeService)this.allowing(committeeService)).getAvailableMembers("1", "1");
                this.will(2.returnValue((Object)members));
            }
        });
        this.rule.setCommitteeService(committeeService);
        final Protocol protocol = new Protocol(){
            private static final long serialVersionUID = -1273061983131550371L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol.getProtocolPersons().add(this.createProtocolPerson("dn", 10));
        protocol.getProtocolPersons().add(this.createProtocolPerson("nncy", null));
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null){

            public Protocol getProtocol() {
                return protocol;
            }
        };
        submitAction.getReviewers().add(new ProtocolReviewerBean(this.createMember(null, "Joe", 2)));
        submitAction.getReviewers().add(new ProtocolReviewerBean(this.createMember(null, "Joanna", 5)));
        submitAction.setCommitteeId("1");
        submitAction.setScheduleId("1");
        ProtocolSubmitActionRuleTest.assertTrue((boolean)this.rule.checkNoSpoofing(submitAction));
        protocol.getProtocolPersons().add(this.createProtocolPerson("", 2));
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.checkNoSpoofing(submitAction));
        this.assertError("actionHelper.protocolSubmitAction.reviewer[0].reviewerUnavailable", "error.protocol.reviewer.unavailable");
        protocol.getProtocolPersons().add(this.createProtocolPerson(null, 5));
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.checkNoSpoofing(submitAction));
        this.assertError("actionHelper.protocolSubmitAction.reviewer[1].reviewerUnavailable", "error.protocol.reviewer.unavailable");
    }

    private CommitteeMembership createMember(String personId, String personName, Integer rolodexId) {
        CommitteeMembership member = new CommitteeMembership();
        member.setPersonId(personId);
        member.setPersonName(personName);
        member.setRolodexId(rolodexId);
        return member;
    }

    private ProtocolPerson createProtocolPerson(String personId, Integer rolodexId) {
        ProtocolPerson pp = new ProtocolPerson();
        pp.setPersonId(personId);
        pp.setRolodexId(rolodexId);
        return pp;
    }

    @Test
    public void testMandatoryOK() throws WorkflowException {
        this.setParameter(MANDATORY);
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("1");
        submitAction.setCommitteeId("1");
        submitAction.setScheduleId("1");
        ProtocolSubmitActionRuleTest.assertTrue((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        ProtocolSubmitActionRuleTest.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        this.setParameter(OPTIONAL);
    }

    @Test
    public void testMandatoryCommittee() throws WorkflowException {
        this.setParameter(MANDATORY);
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("1");
        submitAction.setScheduleId("1");
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction.committeeId", "error.protocol.submission.committee.required");
        this.setParameter(OPTIONAL);
    }

    @Test
    public void testMandatorySchedule() throws WorkflowException {
        this.setParameter(MANDATORY);
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode("1");
        submitAction.setCommitteeId("1");
        ProtocolSubmitActionRuleTest.assertFalse((boolean)this.rule.processSubmitAction((ProtocolDocumentBase)document, (org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction)submitAction));
        this.assertError("actionHelper.protocolSubmitAction.scheduleId", "error.protocol.submission.schedule.required");
        this.setParameter(OPTIONAL);
    }

    private void setParameter(String value) {
        this.updateParameterForTesting(ProtocolDocument.class, "IRB_COMM_SELECTION_DURING_SUBMISSION", value);
    }
}

