/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeMembershipExpertise;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.committee.test.CommitteeFactory;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolReviewer;
import org.kuali.kra.irb.actions.submit.ProtocolReviewerBean;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewerBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.service.RolodexService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProtocolSubmitActionServiceTest
extends KcUnitTestBase {
    private static final String VALID_SUBMISSION_TYPE = "100";
    private static final String VALID_REVIEW_TYPE = "1";
    private static final String MEMBER_EXPERTISE_CODE = "05.0125";
    private ProtocolSubmitActionService protocolSubmitActionService;
    private BusinessObjectService businessObjectService;
    private PersonService personService;
    private RolodexService rolodexService;
    private DocumentService documentService;
    private IdentityService identityManagementService;
    private List<ProtocolReviewerBean> defaultReviewers;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.protocolSubmitActionService = (ProtocolSubmitActionService)KraServiceLocator.getService(ProtocolSubmitActionService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.personService = (PersonService)KraServiceLocator.getService(PersonService.class);
        this.rolodexService = (RolodexService)KraServiceLocator.getService(RolodexService.class);
        this.documentService = (DocumentService)KraServiceLocator.getService((String)"kraDocumentService");
        this.identityManagementService = (IdentityService)KraServiceLocator.getService(IdentityService.class);
        this.defaultReviewers = this.getDefaultReviewers();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        GlobalVariables.setMessageMap(null);
        KNSGlobalVariables.setAuditErrorMap(null);
        super.tearDown();
    }

    @Test
    public void testSubmissionWithNoCommittee() throws Exception {
        this.runTest("", "", VALID_REVIEW_TYPE, null, null, null);
    }

    @Test
    public void testSubmissionWithNoSchedule() throws Exception {
        this.runTest("666", "", VALID_REVIEW_TYPE, null, null, null);
    }

    @Test
    public void testSubmissionWithNoReviewers() throws Exception {
        this.runTest("667", VALID_REVIEW_TYPE, VALID_REVIEW_TYPE, null, null, null);
    }

    @Test
    public void testSubmissionWithReviewers() throws Exception {
        this.runTest("668", VALID_REVIEW_TYPE, VALID_REVIEW_TYPE, this.defaultReviewers, null, null);
    }

    @Test
    public void testExemptCheckList() throws Exception {
        this.runTest("669", VALID_REVIEW_TYPE, "3", null, this.getExemptCheckList(), null);
    }

    @Test
    public void testExpeditedCheckList() throws Exception {
        this.runTest("670", VALID_REVIEW_TYPE, "2", null, null, this.getExpeditedCheckList());
    }

    private void runTest(String committeeId, String scheduleId, String protocolReviewTypeCode, List<ProtocolReviewerBean> reviewers, List<ExemptStudiesCheckListItem> exemptStudiesCheckList, List<ExpeditedReviewCheckListItem> expeditedReviewCheckList) throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolSubmitAction submitAction = this.createSubmitAction(committeeId, scheduleId, protocolReviewTypeCode);
        submitAction.setExemptStudiesCheckList(exemptStudiesCheckList);
        submitAction.setExpeditedReviewCheckList(expeditedReviewCheckList);
        submitAction.setSubmissionQualifierTypeCode("2");
        Committee committee = null;
        if (!StringUtils.isEmpty((String)committeeId)) {
            HashMap<String, String> keymap = new HashMap<String, String>();
            keymap.put("committeeId", committeeId);
            List comms = (List)this.businessObjectService.findMatching(Committee.class, keymap);
            if (comms.size() == 1) {
                committee = (Committee)comms.get(0);
            }
            if (committee == null) {
                committee = (Committee)this.createCommittee(committeeId).getCommittee();
            }
            committee.refreshReferenceObject("committeeType");
            submitAction.setCommitteeId(committee.getCommitteeId());
        }
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), submitAction);
        ProtocolSubmission protocolSubmission = this.findSubmission(protocolDocument.getProtocol().getProtocolId());
        ProtocolSubmitActionServiceTest.assertNotNull((Object)protocolSubmission);
        ProtocolAction protocolAction = this.findProtocolAction(protocolDocument.getProtocol().getProtocolId());
        ProtocolSubmitActionServiceTest.assertNotNull((Object)protocolAction);
        ProtocolSubmitActionServiceTest.assertEquals((Object)protocolDocument.getProtocol().getProtocolStatusCode(), (Object)"101");
        this.verifyAction(protocolAction, protocolSubmission);
        List protocolSubmissions = protocolDocument.getProtocol().getProtocolSubmissions();
        protocolSubmissions.add(protocolSubmission);
        protocolDocument.getProtocol().setProtocolSubmissions(protocolSubmissions);
        protocolDocument.getProtocol().setProtocolSubmission((ProtocolSubmissionBase)protocolSubmission);
        this.verifySubmission(protocolSubmission, protocolDocument.getProtocol(), submitAction);
    }

    private List<ExemptStudiesCheckListItem> getExemptCheckList() {
        ArrayList<ExemptStudiesCheckListItem> list = new ArrayList<ExemptStudiesCheckListItem>();
        ExemptStudiesCheckListItem item = new ExemptStudiesCheckListItem();
        item.setExemptStudiesCheckListCode(VALID_REVIEW_TYPE);
        item.setChecked(true);
        list.add(item);
        item = new ExemptStudiesCheckListItem();
        item.setExemptStudiesCheckListCode("2");
        item.setChecked(false);
        list.add(item);
        return list;
    }

    private List<ExpeditedReviewCheckListItem> getExpeditedCheckList() {
        ArrayList<ExpeditedReviewCheckListItem> list = new ArrayList<ExpeditedReviewCheckListItem>();
        ExpeditedReviewCheckListItem item = new ExpeditedReviewCheckListItem();
        item.setExpeditedReviewCheckListCode(VALID_REVIEW_TYPE);
        item.setChecked(true);
        list.add(item);
        item = new ExpeditedReviewCheckListItem();
        item.setExpeditedReviewCheckListCode("2");
        item.setChecked(false);
        list.add(item);
        return list;
    }

    private List<ProtocolReviewerBean> getDefaultReviewers() {
        ArrayList<ProtocolReviewerBean> reviewers = new ArrayList<ProtocolReviewerBean>();
        ProtocolReviewerBean reviewer = new ProtocolReviewerBean();
        Principal prncpl = this.identityManagementService.getPrincipalByPrincipalName("quickstart");
        reviewer.setPersonId(prncpl.getPrincipalId());
        reviewer.setNonEmployeeFlag(false);
        reviewer.setReviewerTypeCode(VALID_REVIEW_TYPE);
        reviewer.setFullName(prncpl.getPrincipalName());
        reviewers.add(reviewer);
        reviewer = new ProtocolReviewerBean();
        prncpl = this.identityManagementService.getPrincipalByPrincipalName("majors");
        reviewer.setPersonId(prncpl.getPrincipalId());
        reviewer.setNonEmployeeFlag(false);
        reviewer.setReviewerTypeCode(VALID_REVIEW_TYPE);
        reviewer.setFullName(prncpl.getPrincipalName());
        reviewers.add(reviewer);
        reviewer = new ProtocolReviewerBean();
        Rolodex rolodex = this.rolodexService.getRolodex(253);
        reviewer = new ProtocolReviewerBean();
        reviewer.setNonEmployeeFlag(true);
        reviewer.setPersonId("253");
        reviewer.setReviewerTypeCode(VALID_REVIEW_TYPE);
        reviewer.setFullName(rolodex.getFullName());
        return reviewers;
    }

    private CommitteeDocument createCommittee(String committeeId) throws WorkflowException {
        CommitteeDocument committeeDocument = CommitteeFactory.createCommitteeDocument(committeeId);
        Committee committee = (Committee)committeeDocument.getCommittee();
        CommitteeSchedule schedule = new CommitteeSchedule();
        schedule.setScheduleId(VALID_REVIEW_TYPE);
        schedule.setPlace("my office");
        schedule.setEndTime(new Timestamp(System.currentTimeMillis() + 100L));
        schedule.setScheduledDate(new Date(System.currentTimeMillis()));
        schedule.setStartTime(new Timestamp(System.currentTimeMillis() - 100L));
        schedule.setFilter(false);
        schedule.setMaxProtocols(committee.getMaxProtocols());
        schedule.setTime(new Timestamp(System.currentTimeMillis()));
        schedule.setViewTime(new Time12HrFmt(new Timestamp(System.currentTimeMillis())));
        schedule.setProtocolSubDeadline(new Date(System.currentTimeMillis() - 500L));
        schedule.setScheduleStatusCode(Integer.valueOf(1));
        committee.getCommitteeSchedules().add(schedule);
        this.addMembers(committee);
        this.documentService.saveDocument((Document)committeeDocument);
        this.documentService.routeDocument((Document)committeeDocument, "Test Routing", new ArrayList());
        return committeeDocument;
    }

    private void addMember(String personId, Integer rolodexId, String personName, String membershipTypeCode, String membershipRoleCode, Committee committee) {
        CommitteeMembership member = new CommitteeMembership();
        member.setCommitteeIdFk(committee.getId());
        member.setPersonId(personId);
        member.setRolodexId(rolodexId);
        member.setPaidMember(true);
        member.setPersonName(personName);
        member.setTermStartDate(new Date(System.currentTimeMillis() - 10000L));
        member.setTermEndDate(new Date(System.currentTimeMillis() + 10000L));
        member.setMembershipTypeCode(membershipTypeCode);
        CommitteeMembershipExpertise expertise = new CommitteeMembershipExpertise();
        expertise.getResearchArea().setActive(true);
        expertise.setResearchAreaCode(MEMBER_EXPERTISE_CODE);
        member.getMembershipExpertise().add(expertise);
        member.setMembershipId("0");
        ArrayList<CommitteeMembershipRole> roles = new ArrayList<CommitteeMembershipRole>();
        CommitteeMembershipRole role = new CommitteeMembershipRole();
        role.setStartDate(member.getTermStartDate());
        role.setEndDate(member.getTermEndDate());
        role.setMembershipRoleCode(membershipRoleCode);
        roles.add(role);
        member.setMembershipRoles(roles);
        committee.getCommitteeMemberships().add(member);
    }

    private void addMembers(Committee committee) {
        for (ProtocolReviewerBean reviewer : this.defaultReviewers) {
            this.addMember(reviewer.getNonEmployeeFlag() ? null : reviewer.getPersonId(), reviewer.getNonEmployeeFlag() ? new Integer(Integer.parseInt(reviewer.getPersonId())) : null, reviewer.getFullName(), VALID_REVIEW_TYPE, VALID_REVIEW_TYPE, committee);
        }
    }

    private ProtocolSubmitAction createSubmitAction(String committeeId, String scheduleId, String protocolReviewTypeCode) {
        ProtocolSubmitAction submitAction = new ProtocolSubmitAction(null);
        submitAction.setSubmissionTypeCode(VALID_SUBMISSION_TYPE);
        submitAction.setProtocolReviewTypeCode(protocolReviewTypeCode);
        submitAction.setCommitteeId(committeeId);
        submitAction.setScheduleId(scheduleId);
        return submitAction;
    }

    private void verifySubmission(ProtocolSubmission submission, Protocol protocol, ProtocolSubmitAction submitAction) {
        ProtocolSubmitActionServiceTest.assertEquals((Object)protocol.getProtocolNumber(), (Object)submission.getProtocolNumber());
        ProtocolSubmitActionServiceTest.assertEquals((Object)protocol.getSequenceNumber(), (Object)submission.getSequenceNumber());
        ProtocolSubmitActionServiceTest.assertEquals((Object)new Integer(1), (Object)submission.getSubmissionNumber());
        if (StringUtils.isBlank((String)submitAction.getNewCommitteeId())) {
            ProtocolSubmitActionServiceTest.assertEquals((Object)"102", (Object)submission.getSubmissionStatusCode());
        } else {
            ProtocolSubmitActionServiceTest.assertEquals((Object)VALID_SUBMISSION_TYPE, (Object)submission.getSubmissionStatusCode());
        }
        ProtocolSubmitActionServiceTest.assertTrue((submission.getSubmissionDate() != null ? 1 : 0) != 0);
        ProtocolSubmitActionServiceTest.assertEquals((Object)submission.getSubmissionDate(), (Object)protocol.getSubmissionDate());
        ProtocolSubmitActionServiceTest.assertEquals((Object)submitAction.getSubmissionTypeCode(), (Object)submission.getSubmissionTypeCode());
        ProtocolSubmitActionServiceTest.assertEquals((Object)submitAction.getSubmissionQualifierTypeCode(), (Object)submission.getSubmissionTypeQualifierCode());
        ProtocolSubmitActionServiceTest.assertEquals((Object)submitAction.getProtocolReviewTypeCode(), (Object)submission.getProtocolReviewTypeCode());
        ProtocolSubmitActionServiceTest.assertEquals((Object)this.convert(submitAction.getNewCommitteeId()), (Object)this.convert(submission.getCommitteeId()));
        ProtocolSubmitActionServiceTest.assertEquals((Object)this.convert(submitAction.getNewScheduleId()), (Object)this.convert(submission.getScheduleId()));
        ProtocolSubmitActionServiceTest.assertEquals((Object)this.getReviewCount(submitAction.getReviewers()), (Object)this.getCount(submission.getProtocolReviewers()));
        ProtocolSubmitActionServiceTest.assertEquals((long)this.getExemptStudiesCount(submitAction.getExemptStudiesCheckList()), (long)this.getCount(submission.getExemptStudiesCheckList()));
        ProtocolSubmitActionServiceTest.assertEquals((long)this.getExpeditedReviewCount(submitAction.getExpeditedReviewCheckList()), (long)this.getCount(submission.getExpeditedReviewCheckList()));
        int index = 0;
        if (submitAction.getReviewers() != null) {
            for (ProtocolReviewerBeanBase reviewerBean : submitAction.getReviewers()) {
                if (!StringUtils.isNotBlank((String)reviewerBean.getReviewerTypeCode())) continue;
                this.verifyReviewer((ProtocolReviewerBean)reviewerBean, (ProtocolReviewer)submission.getProtocolReviewers().get(index++));
            }
        }
        index = 0;
        if (submitAction.getExemptStudiesCheckList() != null) {
            for (ExemptStudiesCheckListItem item : submitAction.getExemptStudiesCheckList()) {
                if (!item.getChecked()) continue;
                this.verifyExemptStudies(item, (ProtocolExemptStudiesCheckListItem)submission.getExemptStudiesCheckList().get(index++));
            }
        }
        index = 0;
        if (submitAction.getExpeditedReviewCheckList() != null) {
            for (ExemptStudiesCheckListItem item : submitAction.getExpeditedReviewCheckList()) {
                if (!item.getChecked()) continue;
                this.verifyExpeditedReview((ExpeditedReviewCheckListItem)item, (ProtocolExpeditedReviewCheckListItem)submission.getExpeditedReviewCheckList().get(index++));
            }
        }
    }

    private Object getReviewCount(List<ProtocolReviewerBean> reviewers) {
        int count = 0;
        if (reviewers != null) {
            for (ProtocolReviewerBean reviewerBean : reviewers) {
                if (!StringUtils.isNotBlank((String)reviewerBean.getReviewerTypeCode())) continue;
                ++count;
            }
        }
        return count;
    }

    private int getExemptStudiesCount(List<ExemptStudiesCheckListItem> exemptStudiesCheckList) {
        int count = 0;
        if (exemptStudiesCheckList != null) {
            for (ExemptStudiesCheckListItem item : exemptStudiesCheckList) {
                if (!item.getChecked()) continue;
                ++count;
            }
        }
        return count;
    }

    private int getExpeditedReviewCount(List<ExpeditedReviewCheckListItem> expeditedReviewCheckList) {
        int count = 0;
        if (expeditedReviewCheckList != null) {
            for (ExpeditedReviewCheckListItem item : expeditedReviewCheckList) {
                if (!item.getChecked()) continue;
                ++count;
            }
        }
        return count;
    }

    private void verifyExemptStudies(ExemptStudiesCheckListItem exemptStudiesCheckListItem, ProtocolExemptStudiesCheckListItem protocolExemptStudiesCheckListItem) {
        ProtocolSubmitActionServiceTest.assertEquals((Object)exemptStudiesCheckListItem.getExemptStudiesCheckListCode(), (Object)protocolExemptStudiesCheckListItem.getExemptStudiesCheckListCode());
    }

    private void verifyExpeditedReview(ExpeditedReviewCheckListItem expeditedReviewCheckListItem, ProtocolExpeditedReviewCheckListItem protocolExpeditedReviewCheckListItem) {
        ProtocolSubmitActionServiceTest.assertEquals((Object)expeditedReviewCheckListItem.getExpeditedReviewCheckListCode(), (Object)protocolExpeditedReviewCheckListItem.getExpeditedReviewCheckListCode());
    }

    private void verifyReviewer(ProtocolReviewerBean protocolReviewerBean, ProtocolReviewer protocolReviewer) {
        ProtocolSubmitActionServiceTest.assertTrue((boolean)protocolReviewerBean.isProtocolReviewerBeanForReviewer((org.kuali.kra.protocol.actions.submit.ProtocolReviewer)protocolReviewer));
    }

    private void verifyAction(ProtocolAction action, ProtocolSubmission submission) {
        ProtocolSubmitActionServiceTest.assertEquals((Object)"101", (Object)action.getProtocolActionTypeCode());
        ProtocolSubmitActionServiceTest.assertEquals((Object)submission.getSubmissionId(), (Object)action.getSubmissionIdFk());
    }

    private String convert(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private int getCount(List<?> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    private ProtocolAction findProtocolAction(Long protocolId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("protocolId", protocolId);
        List actions = (List)this.businessObjectService.findMatching(ProtocolAction.class, fieldValues);
        ProtocolSubmitActionServiceTest.assertEquals((long)1L, (long)actions.size());
        ProtocolAction action = (ProtocolAction)actions.get(0);
        return action;
    }

    private ProtocolSubmission findSubmission(Long protocolId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("protocolId", protocolId);
        List submissions = (List)this.businessObjectService.findMatching(ProtocolSubmission.class, fieldValues);
        ProtocolSubmitActionServiceTest.assertEquals((long)1L, (long)submissions.size());
        ProtocolSubmission submission = (ProtocolSubmission)submissions.get(0);
        return submission;
    }
}

