/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.submit.ProtocolActionServiceImpl;
import org.kuali.kra.irb.actions.submit.ProtocolActionServiceTestBase;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionStatus;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolUpdateActionServiceTest
extends ProtocolActionServiceTestBase {
    public static final String ATC200 = "200";
    public static final String ATC201 = "201";
    public static final String ATC202 = "202";
    public static final String ATC204 = "204";
    public static final String ATC203 = "203";
    public static final String ATC300 = "300";
    public static final String ATC301 = "301";
    public static final String ATC302 = "302";
    public static final String ATC306 = "306";
    public static final String ATC305 = "305";
    public static final String ATC303 = "303";
    public static final String ATC304 = "304";
    public static final String ATC205 = "205";
    public static final String ATC206 = "206";
    public static final String ATC210 = "210";
    public static final String ATC207 = "207";
    public static final String ATC104 = "104";
    public static final String ATC106 = "106";
    public static final String ATC105 = "105";
    public static final String ATC108 = "108";
    public static final String ATC208 = "208";
    public static final String ATC209 = "209";
    public static final String ATC114 = "114";
    public static final String ATC115 = "115";
    public static final String ATC116 = "116";
    public static final String ATC211 = "211";
    public static final String ATC212 = "212";
    public static final String ATC119 = "119";
    private Mockery context;
    private Protocol protocol;
    private ProtocolAction action;
    private ProtocolActionServiceImpl protocolActionService;
    private BusinessObjectService businessObjectService;

    @Override
    @Before
    public void setUp() {
        this.context = new JUnit4Mockery();
        this.protocol = ProtocolUpdateActionServiceTest.getProtocol(this.context);
        this.protocolActionService = new ProtocolActionServiceImpl();
        this.businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.allowing(ProtocolUpdateActionServiceTest.this.businessObjectService)).save((PersistableBusinessObject)ProtocolUpdateActionServiceTest.this.protocol);
            }
        });
        this.protocolActionService.setBusinessObjectService(this.businessObjectService);
        try {
            this.protocolActionService.setRuleFiles(this.getRuleFiles());
        }
        catch (Exception e) {
            // empty catch block
        }
        ProtocolSubmissionStatus protocolSubmissionStatus = new ProtocolSubmissionStatus();
        protocolSubmissionStatus.setProtocolSubmissionStatusCode("xyz");
        ProtocolSubmission protocolSubmission = new ProtocolSubmission(){

            public void refreshReferenceObject(String referenceObjectName) {
                if (referenceObjectName.equals("submissionStatus")) {
                    ProtocolSubmissionStatus protocolSubmission = new ProtocolSubmissionStatus();
                    protocolSubmission.setProtocolSubmissionStatusCode(this.getSubmissionStatusCode());
                }
            }
        };
        protocolSubmission.setSubmissionStatus((ProtocolSubmissionStatusBase)protocolSubmissionStatus);
        ProtocolSubmissionType protocolSubmissionType = new ProtocolSubmissionType();
        protocolSubmission.setProtocolSubmissionType((ProtocolSubmissionTypeBase)protocolSubmissionType);
        protocolSubmission.setSubmissionNumber(Integer.valueOf(1));
        this.protocol.setProtocolSubmission((ProtocolSubmissionBase)protocolSubmission);
        this.protocol.getProtocolSubmissions().add(protocolSubmission);
        this.protocol.setProtocolNumber("001Z");
        this.action = new ProtocolAction(){

            public void refreshReferenceObject(String referenceObjectName) {
                if (referenceObjectName.equals("protocolActionType")) {
                    ProtocolActionType protocolActionType = new ProtocolActionType();
                    protocolActionType.setProtocolActionTypeCode(this.getProtocolActionTypeCode());
                    protocolActionType.setDescription(this.getProtocolActionTypeCode() + " description");
                    this.setProtocolActionType((ProtocolActionTypeBase)protocolActionType);
                }
            }
        };
    }

    @Test
    public void testActionTypeCode200() {
        this.action.setProtocolActionTypeCode(ATC200);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)"101", (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
    }

    @Test
    public void testActionTypeCode201() {
        this.action.setProtocolActionTypeCode(ATC201);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC206, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)"103", (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode202() {
        this.action.setProtocolActionTypeCode(ATC202);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC201, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC104, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode204ProtocolARNumber() {
        this.action.setProtocolActionTypeCode(ATC204);
        this.protocol.setProtocolNumber("001A");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC203, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
    }

    @Test
    public void testActionTypeCode204ProtocolARNumberNOTIN() {
        this.action.setProtocolActionTypeCode(ATC204);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC203, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC200, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode203() {
        this.action.setProtocolActionTypeCode(ATC203);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC202, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)"102", (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode300SubmissionTypeCode109() {
        this.action.setProtocolActionTypeCode(ATC300);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("109");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC207, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC301, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode300SubmissionTypeCodeNOT109() {
        this.action.setProtocolActionTypeCode(ATC300);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC300, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode301SubmissionTypeCode108() {
        this.action.setProtocolActionTypeCode(ATC301);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode(ATC108);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC208, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC303, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode301SubmissionTypeCodeNOT108() {
        this.action.setProtocolActionTypeCode(ATC301);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)"307", (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode302SubmissionTypeCode110() {
        this.action.setProtocolActionTypeCode(ATC302);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("110");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC209, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC302, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode302SubmissionTypeCodeNOT110() {
        this.action.setProtocolActionTypeCode(ATC302);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)"308", (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode306SubmissionTypeCode110() {
        this.action.setProtocolActionTypeCode(ATC306);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("110");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC209, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)"311", (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode306SubmissionTypeCodeNOT110() {
        this.action.setProtocolActionTypeCode(ATC306);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)"311", (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode305() {
        this.action.setProtocolActionTypeCode(ATC305);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC305, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode303() {
        this.action.setProtocolActionTypeCode(ATC303);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC210, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
    }

    @Test
    public void testActionTypeCode303ProtcolStatusCode101() {
        this.action.setProtocolActionTypeCode(ATC303);
        this.protocol.setProtocolStatusCode("101");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC304, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode304() {
        this.action.setProtocolActionTypeCode(ATC304);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC205, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC306, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode205ProtocolARNumber() {
        this.action.setProtocolActionTypeCode(ATC205);
        this.protocol.setProtocolNumber("001A");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC203, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
    }

    @Test
    public void testActionTypeCode205ProtocolARNumberNOTIN() {
        this.action.setProtocolActionTypeCode(ATC205);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC203, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC200, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode206() {
        this.action.setProtocolActionTypeCode(ATC206);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC204, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC203, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode210() {
        this.action.setProtocolActionTypeCode(ATC210);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC104, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)"310", (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode207SubmissionTypeCode111() {
        this.action.setProtocolActionTypeCode(ATC207);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("111");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC211, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC201, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode207SubmissionTypeCodeNOT111() {
        this.action.setProtocolActionTypeCode(ATC207);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC201, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode104() {
        this.action.setProtocolActionTypeCode(ATC104);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
    }

    @Test
    public void testActionTypeCode106() {
        this.action.setProtocolActionTypeCode(ATC106);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
    }

    @Test
    public void testActionTypeCode105() {
        this.action.setProtocolActionTypeCode(ATC105);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
    }

    @Test
    public void testActionTypeCode108() {
        this.action.setProtocolActionTypeCode(ATC108);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
    }

    @Test
    public void testActionTypeCode208ProtocolARNumber() {
        this.action.setProtocolActionTypeCode(ATC208);
        this.protocol.setProtocolNumber("001A");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC203, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
    }

    @Test
    public void testActionTypeCode208ProtocolARNumberNOTIN() {
        this.action.setProtocolActionTypeCode(ATC208);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC203, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC200, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode209() {
        this.action.setProtocolActionTypeCode(ATC209);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC212, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
    }

    @Test
    public void testActionTypeCode114() {
        this.action.setProtocolActionTypeCode(ATC114);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
    }

    @Test
    public void testActionTypeCode115() {
        this.action.setProtocolActionTypeCode(ATC115);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
    }

    @Test
    public void testActionTypeCode116() {
        this.action.setProtocolActionTypeCode(ATC116);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
    }

    @Test
    public void testActionTypeCode211SubmissionTypeCode111() {
        this.action.setProtocolActionTypeCode(ATC211);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("111");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC211, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC202, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode211SubmissionTypeCodeNOT111() {
        this.action.setProtocolActionTypeCode(ATC211);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC202, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode212SubmissionTypeCode111() {
        this.action.setProtocolActionTypeCode(ATC212);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode(ATC115);
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC211, (Object)this.protocol.getProtocolSubmission().getSubmissionStatusCode());
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC200, (Object)this.protocol.getProtocolStatusCode());
    }

    @Test
    public void testActionTypeCode212SubmissionTypeCodeNOT111() {
        this.action.setProtocolActionTypeCode(ATC212);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)ATC200, (Object)this.protocol.getProtocolStatusCode());
    }

    private List<String> getRuleFiles() {
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionForLeadUnitRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionToSubmitRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionToCommitteeMemberRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/permissionForSpecialRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/canPerformProtocolActionRules.drl");
        ruleFiles.add("org/kuali/kra/irb/drools/rules/updateProtocolRules.drl");
        return ruleFiles;
    }

    @Test
    public void testActionTypeCode119() {
        this.action.setProtocolActionTypeCode(ATC119);
        this.protocol.getProtocolSubmission().getProtocolSubmissionType().setSubmissionTypeCode("XXX");
        this.protocolActionService.updateProtocolStatus((ProtocolActionBase)this.action, (ProtocolBase)this.protocol);
        ProtocolUpdateActionServiceTest.assertEquals((Object)"313", (Object)this.protocol.getProtocolStatusCode());
    }
}

