/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.undo;

import java.sql.Date;
import java.util.ArrayList;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.approve.ProtocolApproveBean;
import org.kuali.kra.irb.actions.approve.ProtocolApproveService;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.actions.undo.UndoLastActionBean;
import org.kuali.kra.irb.actions.undo.UndoLastActionServiceImpl;
import org.kuali.kra.irb.questionnaire.IrbSubmissionQuestionnaireHelper;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.util.DateUtils;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class UndoLastActionServiceTest
extends KcUnitTestBase {
    private static final String COMMENTS = "something silly";
    private static final String ASSIGN_TO_AGENDA_COMMENTS = "assigning to agenda";
    private static final Date ASSIGN_TO_AGENDA_ACTION_DATE = new Date(System.currentTimeMillis());
    private static final Date APPROVAL_ACTION_DATE = new Date(System.currentTimeMillis());
    private static final Date APPROVAL_APPROVAL_DATE = DateUtils.convertToSqlDate((java.util.Date)DateUtils.addWeeks((java.util.Date)APPROVAL_ACTION_DATE, (int)-1));
    private static final Date APPROVAL_EXPIRATION_DATE = DateUtils.convertToSqlDate((java.util.Date)DateUtils.addYears((java.util.Date)APPROVAL_ACTION_DATE, (int)1));
    private static final String APPROVAL_COMMENTS = "approving";
    private static final String CLOSE_COMMENTS = "closing administratively";
    private static final String CLOSE_ENROLLMENT_COMMENTS = "closing enrollment";
    private static final Date CLOSE_ACTION_DATE = new Date(System.currentTimeMillis());
    private UndoLastActionServiceImpl service;
    private ProtocolSubmitActionService protocolSubmitActionService;
    private ProtocolAssignToAgendaService protocolAssignToAgendaService;
    private ProtocolApproveService protocolApproveService;
    private ProtocolRequestService protocolRequestService;
    private ProtocolGenericActionService protocolGenericActionService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new UndoLastActionServiceImpl();
        this.service.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setBusinessObjectService(this.getMockBusinessObjectService());
        this.service.setDocumentService(this.getMockDocumentService());
        this.protocolSubmitActionService = (ProtocolSubmitActionService)KraServiceLocator.getService(ProtocolSubmitActionService.class);
        this.protocolAssignToAgendaService = (ProtocolAssignToAgendaService)KraServiceLocator.getService(ProtocolAssignToAgendaService.class);
        this.protocolApproveService = (ProtocolApproveService)KraServiceLocator.getService(ProtocolApproveService.class);
        this.protocolRequestService = (ProtocolRequestService)KraServiceLocator.getService(ProtocolRequestService.class);
        this.protocolGenericActionService = (ProtocolGenericActionService)KraServiceLocator.getService(ProtocolGenericActionService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.protocolSubmitActionService = null;
        this.protocolAssignToAgendaService = null;
        this.protocolApproveService = null;
        this.protocolRequestService = null;
        this.protocolGenericActionService = null;
        super.tearDown();
    }

    @Test
    public void testUndoApproveAction() throws Exception {
        ProtocolDocument protocolDocument = this.getApprovedProtocolDocument();
        this.service.undoLastAction((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.undo.UndoLastActionBean)this.getMockUndoLastActionBean(protocolDocument.getProtocol()));
        UndoLastActionServiceTest.assertEquals((Object)"101", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)submission);
        UndoLastActionServiceTest.assertEquals((Object)"101", (Object)submission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)action);
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)action.getProtocolActionTypeCode());
        UndoLastActionServiceTest.assertEquals((Object)ASSIGN_TO_AGENDA_COMMENTS, (Object)action.getComments());
    }

    @Test
    public void testUndoRequestToCloseAction() throws Exception {
        ProtocolDocument protocolDocument = this.getApprovedProtocolDocument();
        ProtocolRequestBean requestToCloseBean = this.getMockProtocolRequestBean("105", "109", "protocolCloseRequestBean");
        this.protocolRequestService.submitRequest(protocolDocument.getProtocol(), requestToCloseBean);
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)submission);
        UndoLastActionServiceTest.assertEquals((Object)"102", (Object)submission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)action);
        UndoLastActionServiceTest.assertEquals((Object)"105", (Object)action.getProtocolActionTypeCode());
        this.service.undoLastAction((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.undo.UndoLastActionBean)this.getMockUndoLastActionBean(protocolDocument.getProtocol()));
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission lastSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)lastSubmission);
        UndoLastActionServiceTest.assertEquals((Object)"203", (Object)lastSubmission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction lastAction = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)lastAction);
        UndoLastActionServiceTest.assertEquals((Object)"204", (Object)lastAction.getProtocolActionTypeCode());
        UndoLastActionServiceTest.assertEquals((Object)APPROVAL_COMMENTS, (Object)lastAction.getComments());
    }

    @Test
    public void testUndoCloseAction() throws Exception {
        ProtocolDocument protocolDocument = this.getApprovedProtocolDocument();
        ProtocolRequestBean requestToCloseBean = this.getMockProtocolRequestBean("105", "109", "protocolCloseRequestBean");
        this.protocolRequestService.submitRequest(protocolDocument.getProtocol(), requestToCloseBean);
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)submission);
        UndoLastActionServiceTest.assertEquals((Object)"102", (Object)submission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)action);
        UndoLastActionServiceTest.assertEquals((Object)"105", (Object)action.getProtocolActionTypeCode());
        this.protocolGenericActionService.close(protocolDocument.getProtocol(), this.getMockGenericActionBean(CLOSE_COMMENTS));
        UndoLastActionServiceTest.assertTrue(("300".equals(protocolDocument.getProtocol().getProtocolStatusCode()) || "301".equals(protocolDocument.getProtocol().getProtocolStatusCode()) ? 1 : 0) != 0);
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission lastSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)lastSubmission);
        UndoLastActionServiceTest.assertEquals((Object)"207", (Object)lastSubmission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction lastAction = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)lastAction);
        UndoLastActionServiceTest.assertEquals((Object)"300", (Object)lastAction.getProtocolActionTypeCode());
        UndoLastActionServiceTest.assertEquals((Object)CLOSE_COMMENTS, (Object)lastAction.getComments());
        this.service.undoLastAction((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.undo.UndoLastActionBean)this.getMockUndoLastActionBean(protocolDocument.getProtocol()));
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission lastLastSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)lastLastSubmission);
        UndoLastActionServiceTest.assertEquals((Object)"102", (Object)lastLastSubmission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction lastLastAction = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)lastLastAction);
        UndoLastActionServiceTest.assertEquals((Object)"105", (Object)lastLastAction.getProtocolActionTypeCode());
    }

    @Test
    public void testUndoRequestForSuspensionAction() throws Exception {
        ProtocolDocument protocolDocument = this.getApprovedProtocolDocument();
        ProtocolRequestBean requestForSuspensionBean = this.getMockProtocolRequestBean("106", "110", "protocolSuspendRequestBean");
        this.protocolRequestService.submitRequest(protocolDocument.getProtocol(), requestForSuspensionBean);
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)submission);
        UndoLastActionServiceTest.assertEquals((Object)"102", (Object)submission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)action);
        UndoLastActionServiceTest.assertEquals((Object)"106", (Object)action.getProtocolActionTypeCode());
        this.service.undoLastAction((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.undo.UndoLastActionBean)this.getMockUndoLastActionBean(protocolDocument.getProtocol()));
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission lastSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)lastSubmission);
        UndoLastActionServiceTest.assertEquals((Object)"203", (Object)lastSubmission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction lastAction = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)lastAction);
        UndoLastActionServiceTest.assertEquals((Object)"204", (Object)lastAction.getProtocolActionTypeCode());
        UndoLastActionServiceTest.assertEquals((Object)APPROVAL_COMMENTS, (Object)lastAction.getComments());
    }

    @Test
    public void testUndoEnrollmentActions() throws Exception {
        ProtocolDocument protocolDocument = this.getApprovedProtocolDocument();
        ProtocolRequestBean requestToCloseBean = this.getMockProtocolRequestBean("108", "111", "protocolCloseEnrollmentRequestBean");
        this.protocolRequestService.submitRequest(protocolDocument.getProtocol(), requestToCloseBean);
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)submission);
        UndoLastActionServiceTest.assertEquals((Object)"102", (Object)submission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)action);
        UndoLastActionServiceTest.assertEquals((Object)"108", (Object)action.getProtocolActionTypeCode());
        this.protocolGenericActionService.closeEnrollment(protocolDocument.getProtocol(), this.getMockGenericActionBean(CLOSE_ENROLLMENT_COMMENTS));
        UndoLastActionServiceTest.assertEquals((Object)"201", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission lastSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)lastSubmission);
        UndoLastActionServiceTest.assertEquals((Object)"211", (Object)lastSubmission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction lastAction = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)lastAction);
        UndoLastActionServiceTest.assertEquals((Object)"207", (Object)lastAction.getProtocolActionTypeCode());
        UndoLastActionServiceTest.assertEquals((Object)CLOSE_ENROLLMENT_COMMENTS, (Object)lastAction.getComments());
        this.service.undoLastAction((ProtocolDocumentBase)protocolDocument, (org.kuali.kra.protocol.actions.undo.UndoLastActionBean)this.getMockUndoLastActionBean(protocolDocument.getProtocol()));
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission lastLastSubmission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)lastLastSubmission);
        UndoLastActionServiceTest.assertEquals((Object)"102", (Object)lastLastSubmission.getSubmissionStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction lastLastAction = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)lastLastAction);
        UndoLastActionServiceTest.assertEquals((Object)"108", (Object)lastLastAction.getProtocolActionTypeCode());
    }

    private ProtocolDocument getApprovedProtocolDocument() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        this.protocolSubmitActionService.submitToIrbForReview(protocolDocument.getProtocol(), this.getMockSubmitAction());
        UndoLastActionServiceTest.assertEquals((Object)"101", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        this.protocolAssignToAgendaService.assignToAgenda((ProtocolBase)protocolDocument.getProtocol(), (ProtocolAssignToAgendaBean)this.getMockAssignToAgendaBean());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        ProtocolSubmission submission = protocolDocument.getProtocol().getProtocolSubmission();
        UndoLastActionServiceTest.assertNotNull((Object)submission);
        UndoLastActionServiceTest.assertEquals((Object)"101", (Object)submission.getSubmissionStatusCode());
        this.protocolApproveService.grantFullApproval((ProtocolBase)protocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.approve.ProtocolApproveBean)this.getMockApproveBean());
        UndoLastActionServiceTest.assertEquals((Object)"200", (Object)protocolDocument.getProtocol().getProtocolStatusCode());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolActions().isEmpty() ? 1 : 0) != 0);
        ProtocolAction action = protocolDocument.getProtocol().getLastProtocolAction();
        UndoLastActionServiceTest.assertNotNull((Object)action);
        UndoLastActionServiceTest.assertEquals((Object)APPROVAL_APPROVAL_DATE, (Object)protocolDocument.getProtocol().getApprovalDate());
        UndoLastActionServiceTest.assertEquals((Object)APPROVAL_EXPIRATION_DATE, (Object)protocolDocument.getProtocol().getExpirationDate());
        UndoLastActionServiceTest.assertEquals((Object)APPROVAL_COMMENTS, (Object)action.getComments());
        UndoLastActionServiceTest.assertEquals((Object)APPROVAL_ACTION_DATE, (Object)action.getActionDate());
        UndoLastActionServiceTest.assertTrue((!protocolDocument.getProtocol().getProtocolSubmissions().isEmpty() ? 1 : 0) != 0);
        UndoLastActionServiceTest.assertEquals((Object)"203", (Object)submission.getSubmissionStatusCode());
        return protocolDocument;
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private DocumentService getMockDocumentService() {
        final DocumentService service = (DocumentService)this.context.mock(DocumentService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolSubmitAction getMockSubmitAction() {
        final ProtocolSubmitAction action = (ProtocolSubmitAction)this.context.mock(ProtocolSubmitAction.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionTypeCode();
                this.will(4.returnValue((Object)"100"));
                ((ProtocolSubmitAction)this.allowing(action)).getProtocolReviewTypeCode();
                this.will(4.returnValue((Object)"1"));
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionQualifierTypeCode();
                this.will(4.returnValue((Object)"2"));
                ((ProtocolSubmitAction)this.allowing(action)).getNewCommitteeId();
                this.will(4.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getNewScheduleId();
                this.will(4.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getReviewers();
                this.will(4.returnValue(new ArrayList()));
            }
        });
        return action;
    }

    private org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean getMockAssignToAgendaBean() {
        final org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean bean = (org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean)this.context.mock(org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean)this.allowing(bean)).isProtocolAssigned();
                this.will(5.returnValue((Object)true));
                ((org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean)this.allowing(bean)).getActionDate();
                this.will(5.returnValue((Object)ASSIGN_TO_AGENDA_ACTION_DATE));
                ((org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean)this.allowing(bean)).getComments();
                this.will(5.returnValue((Object)UndoLastActionServiceTest.ASSIGN_TO_AGENDA_COMMENTS));
            }
        });
        return bean;
    }

    private ProtocolApproveBean getMockApproveBean() {
        final ProtocolApproveBean bean = (ProtocolApproveBean)this.context.mock(ProtocolApproveBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolApproveBean)this.allowing(bean)).getActionDate();
                this.will(6.returnValue((Object)APPROVAL_ACTION_DATE));
                ((ProtocolApproveBean)this.allowing(bean)).getComments();
                this.will(6.returnValue((Object)UndoLastActionServiceTest.APPROVAL_COMMENTS));
                ((ProtocolApproveBean)this.allowing(bean)).getApprovalDate();
                this.will(6.returnValue((Object)APPROVAL_APPROVAL_DATE));
                ((ProtocolApproveBean)this.allowing(bean)).getExpirationDate();
                this.will(6.returnValue((Object)APPROVAL_EXPIRATION_DATE));
            }
        });
        return bean;
    }

    private UndoLastActionBean getMockUndoLastActionBean(final Protocol protocol) {
        final UndoLastActionBean bean = (UndoLastActionBean)this.context.mock(UndoLastActionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((UndoLastActionBean)this.allowing(bean)).getComments();
                this.will(7.returnValue((Object)UndoLastActionServiceTest.COMMENTS));
                ((UndoLastActionBean)this.allowing(bean)).setActionsPerformed(protocol.getProtocolActions());
                ((UndoLastActionBean)this.allowing(bean)).getLastAction();
                this.will(7.returnValue((Object)protocol.getLastProtocolAction()));
            }
        });
        return bean;
    }

    private ProtocolGenericActionBean getMockGenericActionBean(final String comments) {
        final ProtocolGenericActionBean bean = (ProtocolGenericActionBean)this.context.mock(ProtocolGenericActionBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolGenericActionBean)this.allowing(bean)).getComments();
                this.will(8.returnValue((Object)comments));
                ((ProtocolGenericActionBean)this.allowing(bean)).getActionDate();
                this.will(8.returnValue((Object)CLOSE_ACTION_DATE));
            }
        });
        return bean;
    }

    private ProtocolRequestBean getMockProtocolRequestBean(final String protocolActionTypeCode, final String submissionTypeCode, final String beanName) {
        final ProtocolRequestBean bean = (ProtocolRequestBean)this.context.mock(ProtocolRequestBean.class);
        final Protocol protocol = new Protocol();
        protocol.setProtocolNumber("13049581");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolRequestBean)this.allowing(bean)).getProtocolActionTypeCode();
                this.will(9.returnValue((Object)protocolActionTypeCode));
                ((ProtocolRequestBean)this.allowing(bean)).getSubmissionTypeCode();
                this.will(9.returnValue((Object)submissionTypeCode));
                ((ProtocolRequestBean)this.allowing(bean)).getCommitteeId();
                this.will(9.returnValue((Object)""));
                ((ProtocolRequestBean)this.allowing(bean)).getReason();
                this.will(9.returnValue((Object)""));
                ((ProtocolRequestBean)this.allowing(bean)).getBeanName();
                this.will(9.returnValue((Object)beanName));
                ((ProtocolRequestBean)this.allowing(bean)).getActionAttachments();
                this.will(9.returnValue(new ArrayList()));
                ((ProtocolRequestBean)this.allowing(bean)).getQuestionnaireHelper();
                this.will(9.returnValue((Object)new IrbSubmissionQuestionnaireHelper((ProtocolBase)protocol, protocolActionTypeCode, null, false)));
            }
        });
        return bean;
    }
}

