/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.withdraw;

import java.util.ArrayList;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolVersionService;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.irb.actions.withdraw.ProtocolWithdrawBean;
import org.kuali.kra.irb.actions.withdraw.ProtocolWithdrawServiceImpl;
import org.kuali.kra.irb.actions.withdraw.WithdrawCorrespondence;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolWithdrawServiceTest
extends KcUnitTestBase {
    private static final String REASON = "my test reason";
    private ProtocolWithdrawServiceImpl service;
    private ProtocolSubmitActionService protocolSubmitActionService;
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new ProtocolWithdrawServiceImpl();
        this.service.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        this.service.setProtocolOnlineReviewService((org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService)this.getMockOnlineReviewService());
        this.service.setBusinessObjectService(this.getMockBusinessObjectService());
        this.service.setDocumentService((DocumentService)KraServiceLocator.getService(DocumentService.class));
        this.service.setProtocolVersionService((org.kuali.kra.protocol.ProtocolVersionService)KraServiceLocator.getService(ProtocolVersionService.class));
        this.service.setProtocolAssignToAgendaService(this.getMockProtocolAssignToAgendaService());
        this.service.setProtocolActionCorrespondenceGenerationService((org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService)this.getMockActionCorrespondenceGenerationService());
        this.service.setKcNotificationService(this.getMockKcNotificationService());
        this.protocolSubmitActionService = (ProtocolSubmitActionService)KraServiceLocator.getService(ProtocolSubmitActionService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.protocolSubmitActionService = null;
        super.tearDown();
    }

    @Test
    public void testWithdrawal() throws Exception {
        ProtocolDocument oldProtocolDocument = ProtocolFactory.createProtocolDocument();
        this.protocolSubmitActionService.submitToIrbForReview(oldProtocolDocument.getProtocol(), this.getMockSubmitAction());
        ProtocolWithdrawServiceTest.assertEquals((Object)"101", (Object)oldProtocolDocument.getProtocol().getProtocolStatusCode());
        ProtocolDocument newProtocolDocument = (ProtocolDocument)this.service.withdraw((ProtocolBase)oldProtocolDocument.getProtocol(), (org.kuali.kra.protocol.actions.withdraw.ProtocolWithdrawBean)this.getMockProtocolWithdrawBean());
        ProtocolWithdrawServiceTest.assertTrue((boolean)oldProtocolDocument.getDocumentHeader().getWorkflowDocument().isCanceled());
        ProtocolWithdrawServiceTest.assertEquals((Object)"304", (Object)newProtocolDocument.getProtocol().getProtocolStatusCode());
        ProtocolAction protocolAction = oldProtocolDocument.getProtocol().getLastProtocolAction();
        ProtocolWithdrawServiceTest.assertNotNull((Object)protocolAction);
        ProtocolWithdrawServiceTest.assertEquals((Object)REASON, (Object)protocolAction.getComments());
        ProtocolSubmission submission = oldProtocolDocument.getProtocol().getProtocolSubmission();
        ProtocolWithdrawServiceTest.assertEquals((Object)"210", (Object)submission.getSubmissionStatusCode());
    }

    private ProtocolOnlineReviewService getMockOnlineReviewService() {
        final ProtocolOnlineReviewService service = (ProtocolOnlineReviewService)this.context.mock(ProtocolOnlineReviewService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private BusinessObjectService getMockBusinessObjectService() {
        final BusinessObjectService service = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolAssignToAgendaService getMockProtocolAssignToAgendaService() {
        final ProtocolAssignToAgendaService service = (ProtocolAssignToAgendaService)this.context.mock(ProtocolAssignToAgendaService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAssignToAgendaService)this.allowing(service)).getAssignedToAgendaProtocolAction((ProtocolBase)this.with(4.any(Protocol.class)));
                this.will(4.returnValue(null));
            }
        });
        return service;
    }

    private ProtocolActionCorrespondenceGenerationService getMockActionCorrespondenceGenerationService() {
        final ProtocolActionCorrespondenceGenerationService service = (ProtocolActionCorrespondenceGenerationService)this.context.mock(ProtocolActionCorrespondenceGenerationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }

    private ProtocolSubmitAction getMockSubmitAction() {
        final ProtocolSubmitAction action = (ProtocolSubmitAction)this.context.mock(ProtocolSubmitAction.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionTypeCode();
                this.will(6.returnValue((Object)"100"));
                ((ProtocolSubmitAction)this.allowing(action)).getProtocolReviewTypeCode();
                this.will(6.returnValue((Object)"1"));
                ((ProtocolSubmitAction)this.allowing(action)).getSubmissionQualifierTypeCode();
                this.will(6.returnValue((Object)"2"));
                ((ProtocolSubmitAction)this.allowing(action)).getNewCommitteeId();
                this.will(6.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getNewScheduleId();
                this.will(6.returnValue((Object)""));
                ((ProtocolSubmitAction)this.allowing(action)).getReviewers();
                this.will(6.returnValue(new ArrayList()));
            }
        });
        return action;
    }

    private ProtocolWithdrawBean getMockProtocolWithdrawBean() {
        final ProtocolWithdrawBean bean = (ProtocolWithdrawBean)this.context.mock(ProtocolWithdrawBean.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolWithdrawBean)this.allowing(bean)).getReason();
                this.will(7.returnValue((Object)ProtocolWithdrawServiceTest.REASON));
                ((ProtocolWithdrawBean)this.allowing(bean)).getCorrespondence();
                this.will(7.returnValue((Object)new WithdrawCorrespondence()));
            }
        });
        return bean;
    }

    private KcNotificationService getMockKcNotificationService() {
        final KcNotificationService service = (KcNotificationService)this.context.mock(KcNotificationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(service);
            }
        });
        return service;
    }
}

