/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.auth.GenericProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class GenericProtocolAuthorizerTest
extends KcUnitTestBase {
    private static final String VALID_TASK_NAME = "protocolTerminate";
    private static final String INVALID_TASK_NAME = "foobar";
    private KraAuthorizationService kraAuthorizationService;
    private ProtocolActionService protocolActionService;
    private GenericProtocolAuthorizer auth;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.auth = new GenericProtocolAuthorizer();
        this.kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        this.protocolActionService = (ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class);
        this.auth.setKraAuthorizationService(this.kraAuthorizationService);
        this.auth.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)this.protocolActionService);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.auth = null;
        this.kraAuthorizationService = null;
        this.protocolActionService = null;
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testValidCloseEnrollment() throws Exception {
        Protocol prot = this.getBaseProtocol("200", "111");
        ProtocolTask task = new ProtocolTask("genericProtocolAction", prot);
        this.auth.setGenericTaskName("protocolCloseEnrollment");
        GenericProtocolAuthorizerTest.assertTrue((boolean)this.auth.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task));
    }

    @Test
    public void testValidDataAnalysisOnly() throws Exception {
        Protocol prot = this.getBaseProtocol("200", "113");
        ProtocolTask task = new ProtocolTask("genericProtocolAction", prot);
        this.auth.setGenericTaskName("protocolPermitDataAnalysis");
        GenericProtocolAuthorizerTest.assertTrue((boolean)this.auth.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task));
    }

    @Test
    public void testValidSuspend() throws Exception {
        Protocol prot = this.getBaseProtocol("200", "110");
        ProtocolTask task = new ProtocolTask("genericProtocolAction", prot);
        this.auth.setGenericTaskName("protocolSuspend");
        GenericProtocolAuthorizerTest.assertTrue((boolean)this.auth.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task));
    }

    @Test
    public void testValidClose() throws Exception {
        Protocol prot = this.getBaseProtocol("200", "109");
        ProtocolTask task = new ProtocolTask("genericProtocolAction", prot);
        this.auth.setGenericTaskName("protocolClose");
        GenericProtocolAuthorizerTest.assertTrue((boolean)this.auth.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task));
    }

    @Test
    public void testValidReOpen() throws Exception {
        Protocol prot = this.getBaseProtocol("201", "114");
        ProtocolTask task = new ProtocolTask("genericProtocolAction", prot);
        this.auth.setGenericTaskName("protocolReopen");
        GenericProtocolAuthorizerTest.assertTrue((boolean)this.auth.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task));
    }

    @Test
    public void testInValidReOpen() throws Exception {
        Protocol prot = this.getBaseProtocol("201", "114");
        ProtocolTask task = new ProtocolTask("genericProtocolAction", prot);
        this.auth.setGenericTaskName("protocolReopen");
        GenericProtocolAuthorizerTest.assertFalse((boolean)this.auth.isAuthorized(GlobalVariables.getUserSession().getPrincipalId() + "xyz", task));
    }

    @Test
    public void testValidTerminate() throws Exception {
        Protocol prot = this.getBaseProtocol("200", "108");
        ProtocolTask task = new ProtocolTask("genericProtocolAction", prot);
        this.auth.setGenericTaskName(VALID_TASK_NAME);
        GenericProtocolAuthorizerTest.assertTrue((boolean)this.auth.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task));
    }

    private Protocol getBaseProtocol(String protocolStatusCode, String submissionType) throws Exception {
        ProtocolDocument pd = ProtocolFactory.createProtocolDocument("123", new Integer(1));
        pd.getProtocol().setProtocolStatusCode(protocolStatusCode);
        ProtocolSubmission ps = new ProtocolSubmission();
        ps.setProtocol((ProtocolBase)pd.getProtocol());
        ps.setCommitteeId("789");
        ps.setScheduleId("456");
        ps.setSubmissionStatusCode(submissionType);
        ArrayList<ProtocolSubmission> protocolSubmissions = new ArrayList<ProtocolSubmission>();
        protocolSubmissions.add(ps);
        pd.getProtocol().setProtocolSubmission((ProtocolSubmissionBase)ps);
        pd.getProtocol().setProtocolSubmissions(protocolSubmissions);
        pd.getProtocol().setLeadUnitNumber("000001");
        return pd.getProtocol();
    }

    @Test
    public void testValidSetGenericTaskName() {
        boolean validTest = true;
        try {
            this.auth.setGenericTaskName(VALID_TASK_NAME);
        }
        catch (IllegalArgumentException iae) {
            validTest = false;
        }
        GenericProtocolAuthorizerTest.assertTrue((boolean)validTest);
    }

    @Test
    public void testInValidSetGenericTaskName() {
        boolean validTest = true;
        try {
            this.auth.setGenericTaskName(INVALID_TASK_NAME);
        }
        catch (IllegalArgumentException iae) {
            validTest = false;
        }
        GenericProtocolAuthorizerTest.assertFalse((boolean)validTest);
    }
}

