/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewModule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.auth.ModifyAmendmentAuthorizer;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.service.KraAuthorizationService;

@Ignore
@RunWith(value=JMock.class)
public abstract class ModifyProtocolModuleAuthorizerTest {
    private static final String USERNAME = "quickstart";
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };

    protected abstract String getTaskName();

    protected abstract String getTestModuleTypeCode();

    protected abstract String getFalseModuleTypeCode();

    protected abstract ModifyAmendmentAuthorizer createAuthorizer();

    @Test
    public void testHasModulePermission() {
    }

    @Test
    public void testHasNoModulePermission() {
    }

    @Test
    public void testHasProtocolPermission() {
    }

    @Test
    public void testHasNoProtocolPermission() {
    }

    protected Protocol createProtocol() {
        final Protocol protocol = (Protocol)this.context.mock(Protocol.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Protocol)this.one(protocol)).getProtocolId();
                this.will(2.returnValue((Object)1L));
                ((Protocol)this.atLeast(0).of((Object)protocol)).getProtocolNumber();
                this.will(2.returnValue((Object)"0906000001"));
            }
        });
        return protocol;
    }

    protected Protocol createAmendment(String moduleTypeCode) {
        final Protocol protocol = (Protocol)this.context.mock(Protocol.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Protocol)this.one(protocol)).getProtocolId();
                this.will(3.returnValue((Object)1L));
                ((Protocol)this.atLeast(0).of((Object)protocol)).getProtocolNumber();
                this.will(3.returnValue((Object)"0906000001A001"));
            }
        });
        this.addModule(protocol, moduleTypeCode);
        return protocol;
    }

    protected void addModule(final Protocol protocol, String moduleTypeCode) {
        final ProtocolAmendRenewal amendRenewal = new ProtocolAmendRenewal();
        ProtocolAmendRenewModule module = new ProtocolAmendRenewModule();
        module.setProtocolModuleTypeCode(moduleTypeCode);
        amendRenewal.addModule((ProtocolAmendRenewModuleBase)module);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Protocol)this.one(protocol)).getProtocolAmendRenewal();
                this.will(4.returnValue((Object)amendRenewal));
            }
        });
    }

    protected void addMockProtocolAuthorizationService(final Protocol protocol, ModifyAmendmentAuthorizer authorizer, final boolean value) {
        final KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)this.context.mock(KraAuthorizationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraAuthorizationService)this.one(kraAuthorizationService)).hasPermission(ModifyProtocolModuleAuthorizerTest.USERNAME, (Permissionable)protocol, "Modify Protocol");
                this.will(5.returnValue((Object)value));
            }
        });
        authorizer.setKraAuthorizationService(kraAuthorizationService);
    }
}

