/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.Collections;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewModule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.auth.ModifyAmendmentAuthorizer;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolAuthorizerTestBase;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;

public abstract class ModifyProtocolModuleAuthorizerTestBase
extends ProtocolAuthorizerTestBase {
    protected void runModifyProtocolTest(String protocolNumber, boolean hasPermission, boolean expected) throws Exception {
        ProtocolDocument document = ProtocolFactory.createProtocolDocument(protocolNumber);
        document.getProtocol().setCorrectionMode(true);
        ProtocolAuthorizer authorizer = this.createProtocolAuthorizer(document, hasPermission, false, true);
        this.runTest(document, authorizer, expected);
    }

    protected void runModifyProtocolAmendmentTest(String protocolNumber, String moduleTypeCode, boolean hasPermission, boolean expected) throws Exception {
        ProtocolDocument document = ProtocolFactory.createProtocolDocument(protocolNumber);
        ProtocolAmendRenewal amendRenewal = new ProtocolAmendRenewal();
        ProtocolAmendRenewModule module = new ProtocolAmendRenewModule();
        module.setProtocolModuleTypeCode(moduleTypeCode);
        amendRenewal.addModule((ProtocolAmendRenewModuleBase)module);
        document.getProtocol().setProtocolAmendRenewal((ProtocolAmendRenewalBase)amendRenewal);
        document.getProtocol().setCorrectionMode(true);
        ProtocolAuthorizer authorizer = this.createProtocolAuthorizer(document, hasPermission, false, true);
        this.runTest(document, authorizer, expected);
    }

    protected abstract String getModuleTypeCode();

    protected abstract ModifyAmendmentAuthorizer createModifyAmendmentAuthorizer();

    @Override
    protected ProtocolAuthorizer createProtocolAuthorizer(ProtocolDocument protocolDocument, boolean hasPermission, boolean isActionAllowed, boolean isInWorkflow) throws Exception {
        ModifyAmendmentAuthorizer authorizer = this.createModifyAmendmentAuthorizer();
        authorizer.setKraAuthorizationService(this.buildKraAuthorizationService(protocolDocument, "Modify Protocol", hasPermission));
        authorizer.setKraWorkflowService(this.buildKraWorkflowService(protocolDocument, isInWorkflow));
        authorizer.setProtocolAmendRenewService(this.buildProtocolAmendRenewService(protocolDocument, Collections.singletonList(this.getModuleTypeCode())));
        return authorizer;
    }
}

