/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.auth.ProtocolAssignCmtSchedAuthorizer;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolAuthorizerTestBase;

public class ProtocolAssignCmtSchedAuthorizerTest
extends ProtocolAuthorizerTestBase {
    @Test
    public void testPending() throws Exception {
        this.runSubmissionStatusTest("0906000001", "102", true, true, true);
    }

    @Test
    public void testSubmittedToCommittee() throws Exception {
        this.runSubmissionStatusTest("0906000001", "100", true, true, true);
    }

    @Test
    public void testNotInWorkflow() throws Exception {
        this.runSubmissionStatusTest("0906000001", "102", true, false, false);
    }

    @Test
    public void testNoPermission() throws Exception {
        this.runSubmissionStatusTest("0906000001", "102", false, true, false);
    }

    @Test
    public void testInvalidSubmissionStatus() throws Exception {
        this.runSubmissionStatusTest("0906000001", "203", true, true, false);
    }

    @Override
    protected ProtocolAuthorizer createProtocolAuthorizer(ProtocolDocument protocolDocument, boolean hasPermission, boolean isActionAllowed, boolean isInWorkflow) {
        ProtocolAssignCmtSchedAuthorizer authorizer = new ProtocolAssignCmtSchedAuthorizer();
        authorizer.setProtocolActionService((org.kuali.kra.protocol.actions.submit.ProtocolActionService)KraServiceLocator.getService(ProtocolActionService.class));
        authorizer.setKraAuthorizationService(this.buildKraAuthorizationService(protocolDocument, "Perform IRB Actions on a Protocol", hasPermission));
        authorizer.setKraWorkflowService(this.buildKraWorkflowService(protocolDocument, isInWorkflow));
        return authorizer;
    }

    @Override
    protected String getTaskName() {
        return "protocolAssignToCmtSched";
    }
}

