/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.document.Document;

public abstract class ProtocolAuthorizerTestBase
extends KcUnitTestBase {
    protected static final String PROTOCOL_NUMBER = "0906000001";
    private static final String USERNAME = "quickstart";
    private Mockery context;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context = new JUnit4Mockery();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.context = null;
    }

    protected void runModifyProtocolAuthorizerTest(String protocolNumber, boolean isProtocolNew, boolean isProtocolViewOnly, boolean hasPermission, boolean isInWorkflow, boolean expected) throws Exception {
        ProtocolDocument document = ProtocolFactory.createProtocolDocument(protocolNumber);
        if (isProtocolNew) {
            document.getProtocol().setProtocolId(null);
        }
        document.setViewOnly(isProtocolViewOnly);
        ProtocolAuthorizer authorizer = this.createProtocolAuthorizer(document, hasPermission, false, isInWorkflow);
        this.runTest(document, authorizer, expected);
    }

    protected void runActionAuthorizerTest(String protocolNumber, boolean hasPermission, boolean isActionAllowed, boolean expected) throws Exception {
        ProtocolDocument document = ProtocolFactory.createProtocolDocument(protocolNumber);
        ProtocolAuthorizer authorizer = this.createProtocolAuthorizer(document, hasPermission, isActionAllowed, true);
        this.runTest(document, authorizer, expected);
    }

    protected void runStatusAuthorizerTest(String protocolNumber, String protocolStatusCode, boolean hasPermission, boolean expected) throws Exception {
        ProtocolDocument document = ProtocolFactory.createProtocolDocument(protocolNumber);
        document.getProtocol().setProtocolStatusCode(protocolStatusCode);
        ProtocolAuthorizer authorizer = this.createProtocolAuthorizer(document, hasPermission, false, true);
        this.runTest(document, authorizer, expected);
    }

    protected void runSubmissionStatusTest(String protocolNumber, String submissionStatusCode, boolean hasPermission, boolean isInWorkflow, boolean expected) throws Exception {
        ProtocolDocument document = ProtocolFactory.createProtocolDocument(protocolNumber);
        ArrayList<ProtocolSubmission> submissions = new ArrayList<ProtocolSubmission>();
        ProtocolSubmission submission = new ProtocolSubmission();
        submission.setSubmissionStatusCode(submissionStatusCode);
        submissions.add(submission);
        document.getProtocol().setProtocolSubmissions(submissions);
        ProtocolAuthorizer authorizer = this.createProtocolAuthorizer(document, hasPermission, false, isInWorkflow);
        this.runTest(document, authorizer, expected);
    }

    protected void runTest(ProtocolDocument protocolDocument, ProtocolAuthorizer authorizer, boolean expected) {
        ProtocolTask task = new ProtocolTask(this.getTaskName(), protocolDocument.getProtocol());
        ProtocolAuthorizerTestBase.assertEquals((Object)expected, (Object)authorizer.isAuthorized(USERNAME, task));
    }

    protected abstract ProtocolAuthorizer createProtocolAuthorizer(ProtocolDocument var1, boolean var2, boolean var3, boolean var4) throws Exception;

    protected abstract String getTaskName();

    protected UnitAuthorizationService buildUnitAuthorizationService(final String permissionConstant, final boolean hasPermission) {
        final UnitAuthorizationService service = (UnitAuthorizationService)this.context.mock(UnitAuthorizationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((UnitAuthorizationService)this.allowing(service)).hasPermission(ProtocolAuthorizerTestBase.USERNAME, "KC-PROTOCOL", permissionConstant);
                this.will(1.returnValue((Object)hasPermission));
            }
        });
        return service;
    }

    protected KraAuthorizationService buildKraAuthorizationService(final ProtocolDocument protocolDocument, final String permissionConstant, final boolean hasPermission) {
        final KraAuthorizationService service = (KraAuthorizationService)this.context.mock(KraAuthorizationService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraAuthorizationService)this.allowing(service)).hasPermission(ProtocolAuthorizerTestBase.USERNAME, (Permissionable)protocolDocument.getProtocol(), permissionConstant);
                this.will(2.returnValue((Object)hasPermission));
                if ("Create Ammendment".equals(permissionConstant) && !hasPermission) {
                    ((KraAuthorizationService)this.allowing(service)).hasPermission(ProtocolAuthorizerTestBase.USERNAME, (Permissionable)protocolDocument.getProtocol(), "Create Any Amendment");
                    this.will(2.returnValue((Object)hasPermission));
                } else if ("Create Renewal".equals(permissionConstant) && !hasPermission) {
                    ((KraAuthorizationService)this.allowing(service)).hasPermission(ProtocolAuthorizerTestBase.USERNAME, (Permissionable)protocolDocument.getProtocol(), "Create Any Renewal");
                    this.will(2.returnValue((Object)hasPermission));
                }
            }
        });
        return service;
    }

    protected KraWorkflowService buildKraWorkflowService(final ProtocolDocument protocolDocument, final boolean isInWorkflow) {
        final KraWorkflowService service = (KraWorkflowService)this.context.mock(KraWorkflowService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraWorkflowService)this.allowing(service)).isInWorkflow((Document)protocolDocument);
                this.will(3.returnValue((Object)isInWorkflow));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraWorkflowService)this.allowing(service)).hasWorkflowPermission(ProtocolAuthorizerTestBase.USERNAME, (Document)protocolDocument);
                this.will(4.returnValue((Object)isInWorkflow));
            }
        });
        return service;
    }

    protected KraWorkflowService buildKraWorkflowNodeService(final ProtocolDocument protocolDocument, final boolean isInWorkflow) {
        final KraWorkflowService service = (KraWorkflowService)this.context.mock(KraWorkflowService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraWorkflowService)this.allowing(service)).isInWorkflow((Document)protocolDocument);
                this.will(5.returnValue((Object)isInWorkflow));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraWorkflowService)this.allowing(service)).isDocumentOnNode((Document)protocolDocument, "IRBReview");
                this.will(6.returnValue((Object)isInWorkflow));
            }
        });
        return service;
    }

    protected ProtocolActionService buildProtocolActionService(final String protocolActionTypeCode, final ProtocolDocument protocolDocument, final boolean isActionAllowed) {
        final ProtocolActionService service = (ProtocolActionService)this.context.mock(ProtocolActionService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolActionService)this.allowing(service)).isActionAllowed(protocolActionTypeCode, (ProtocolBase)protocolDocument.getProtocol());
                this.will(7.returnValue((Object)isActionAllowed));
            }
        });
        return service;
    }

    protected ProtocolAmendRenewService buildProtocolAmendRenewService(final ProtocolDocument protocolDocument, final List<String> availableModules) throws Exception {
        final ProtocolAmendRenewService service = (ProtocolAmendRenewService)this.context.mock(ProtocolAmendRenewService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolAmendRenewService)this.allowing(service)).getAvailableModules(protocolDocument.getProtocol().getProtocolNumber());
                this.will(8.returnValue((Object)availableModules));
            }
        });
        return service;
    }
}

