/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import org.junit.Test;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.auth.ProtocolAuthorizer;
import org.kuali.kra.irb.auth.ProtocolAuthorizerTestBase;
import org.kuali.kra.irb.auth.ProtocolWithdrawAuthorizer;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;

public class ProtocolWithdrawAuthorizerTest
extends ProtocolAuthorizerTestBase {
    @Test
    public void testHasPermission() throws Exception {
        this.runActionAuthorizerTest("0906000001", true, true, true);
    }

    @Test
    public void testNotAProtocol() throws Exception {
        this.runActionAuthorizerTest("0906000001A001", true, true, true);
    }

    @Test
    public void testNoPermission() throws Exception {
        this.runActionAuthorizerTest("0906000001", false, true, false);
    }

    @Test
    public void testActionNotAllowed() throws Exception {
        this.runActionAuthorizerTest("0906000001", true, false, false);
    }

    @Override
    protected ProtocolAuthorizer createProtocolAuthorizer(ProtocolDocument protocolDocument, boolean hasPermission, boolean isActionAllowed, boolean isInWorkflow) {
        ProtocolWithdrawAuthorizer authorizer = new ProtocolWithdrawAuthorizer();
        authorizer.setKraAuthorizationService(this.buildKraAuthorizationService(protocolDocument, "Submit Protocol", hasPermission));
        authorizer.setProtocolActionService((ProtocolActionService)this.buildProtocolActionService("303", protocolDocument, isActionAllowed));
        authorizer.setKraWorkflowService(this.buildKraWorkflowNodeService(protocolDocument, isInWorkflow));
        return authorizer;
    }

    @Override
    protected String getTaskName() {
        return "protocolWithdraw";
    }
}

