/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.correspondence;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.correspondence.BatchCorrespondence;
import org.kuali.kra.irb.correspondence.BatchCorrespondenceDetail;
import org.kuali.kra.irb.correspondence.BatchCorrespondenceDetailRule;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceBase;
import org.kuali.kra.protocol.correspondence.BatchCorrespondenceDetailBase;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class BatchCorrespondenceDetailRuleTest {
    @Before
    public void setUp() throws Exception {
        MessageMap messageMap = GlobalVariables.getMessageMap();
        messageMap.clearErrorMessages();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAddBatchCorrespondenceDetail() throws Exception {
        BatchCorrespondence batchCorrespondence = this.getBatchCorrespondenceAfter();
        BatchCorrespondenceDetail newBatchCorrespondenceDetail = this.getBachCorrespondenceDetail();
        boolean rulePassed = new BatchCorrespondenceDetailRule().processAddBatchCorrespondenceDetailRules((BatchCorrespondenceBase)batchCorrespondence, (BatchCorrespondenceDetailBase)newBatchCorrespondenceDetail);
        Assert.assertTrue((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)0L, (long)messageMap.getErrorCount());
    }

    @Test
    public void testAddBatchCorrespondenceDetailWithMissingData() throws Exception {
        BatchCorrespondence batchCorrespondence = this.getBatchCorrespondenceAfter();
        BatchCorrespondenceDetail newBatchCorrespondenceDetail = new BatchCorrespondenceDetail();
        boolean rulePassed = new BatchCorrespondenceDetailRule().processAddBatchCorrespondenceDetailRules((BatchCorrespondenceBase)batchCorrespondence, (BatchCorrespondenceDetailBase)newBatchCorrespondenceDetail);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)2L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newBatchCorrespondenceDetail.daysToEvent"));
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newBatchCorrespondenceDetail.protoCorrespTypeCode"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newBatchCorrespondenceDetail.daysToEvent");
        Assert.assertEquals((Object)"error.batch.correspondence.days.to.event.not.specified", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
        errorMessages = messageMap.getErrorMessagesForProperty("newBatchCorrespondenceDetail.protoCorrespTypeCode");
        Assert.assertEquals((Object)"error.batch.correspondence.proto.corresp.type.code.not.specified", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddBatchCorrespondenceDetailInvalidDaysToEvent() throws Exception {
        BatchCorrespondence batchCorrespondence = this.getBatchCorrespondenceAfter();
        BatchCorrespondenceDetail newBatchCorrespondenceDetail = this.getBachCorrespondenceDetail();
        newBatchCorrespondenceDetail.setDaysToEvent(Integer.valueOf(80));
        boolean rulePassed = new BatchCorrespondenceDetailRule().processAddBatchCorrespondenceDetailRules((BatchCorrespondenceBase)batchCorrespondence, (BatchCorrespondenceDetailBase)newBatchCorrespondenceDetail);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newBatchCorrespondenceDetail.daysToEvent"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newBatchCorrespondenceDetail.daysToEvent");
        Assert.assertEquals((Object)"error.batch.correspondence.days.to.event.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddBatchCorrespondenceDetailDuplicateDaysToEvent() throws Exception {
        BatchCorrespondence batchCorrespondence = this.getBatchCorrespondenceAfter();
        BatchCorrespondenceDetail newBatchCorrespondenceDetail = this.getBachCorrespondenceDetail();
        newBatchCorrespondenceDetail.setDaysToEvent(Integer.valueOf(15));
        boolean rulePassed = new BatchCorrespondenceDetailRule().processAddBatchCorrespondenceDetailRules((BatchCorrespondenceBase)batchCorrespondence, (BatchCorrespondenceDetailBase)newBatchCorrespondenceDetail);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newBatchCorrespondenceDetail.daysToEvent"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newBatchCorrespondenceDetail.daysToEvent");
        Assert.assertEquals((Object)"error.batch.correspondence.days.to.event.duplicate", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveBatchCorrespondenceTemplate() throws Exception {
        BatchCorrespondence batchCorrespondence = this.getBatchCorrespondenceAfter();
        boolean rulePassed = new BatchCorrespondenceDetailRule().processSaveBatchCorrespondenceDetailRules((BatchCorrespondenceBase)batchCorrespondence);
        Assert.assertTrue((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)0L, (long)messageMap.getErrorCount());
    }

    @Test
    public void testSaveBatchCorrespondenceDetailFinalActionDay() throws Exception {
        BatchCorrespondence batchCorrespondence = this.getBatchCorrespondenceAfter();
        batchCorrespondence.setFinalActionDay(Integer.valueOf(5));
        boolean rulePassed = new BatchCorrespondenceDetailRule().processSaveBatchCorrespondenceDetailRules((BatchCorrespondenceBase)batchCorrespondence);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("batchCorrespondence.finalActionDay"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("batchCorrespondence.finalActionDay");
        Assert.assertEquals((Object)"error.batch.correspondence.final.action.day.invalid", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    private BatchCorrespondence getBatchCorrespondenceAfter() {
        BatchCorrespondence batchCorrespondence = new BatchCorrespondence();
        batchCorrespondence.setSendCorrespondence("AFTER");
        batchCorrespondence.setFinalActionDay(Integer.valueOf(30));
        batchCorrespondence.setFinalActionCorrespType("26");
        batchCorrespondence.setFinalActionTypeCode("300");
        BatchCorrespondenceDetail batchCorrespondenceDetail = new BatchCorrespondenceDetail();
        batchCorrespondenceDetail.setProtoCorrespTypeCode("15");
        batchCorrespondenceDetail.setDaysToEvent(Integer.valueOf(15));
        batchCorrespondence.getBatchCorrespondenceDetails().add(batchCorrespondenceDetail);
        return batchCorrespondence;
    }

    private BatchCorrespondenceDetail getBachCorrespondenceDetail() {
        BatchCorrespondenceDetail batchCorrespondenceDetail = new BatchCorrespondenceDetail();
        batchCorrespondenceDetail.setProtoCorrespTypeCode("10");
        batchCorrespondenceDetail.setDaysToEvent(Integer.valueOf(20));
        return batchCorrespondenceDetail;
    }
}

