/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.correspondence;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.struts.upload.FormFile;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplate;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceType;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateRule;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class ProtocolCorrespondenceTemplateRuleTest {
    Mockery context = new JUnit4Mockery();
    FormFile mockedFile = null;

    @Before
    public void setUp() throws Exception {
        this.mockedFile = (FormFile)this.context.mock(FormFile.class);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        messageMap.clearErrorMessages();
    }

    @After
    public void tearDown() throws Exception {
        this.mockedFile = null;
    }

    @Test
    public void testAddCorrespondenceTemplateMissingCommittee() throws Exception {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType correspondenceType = new ProtocolCorrespondenceType();
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate(null);
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newCorrespondenceTemplates[2].committeeId"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newCorrespondenceTemplates[2].committeeId");
        Assert.assertEquals((Object)"error.correspondence.template.committee.not.specified", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddCorrespondenceTemplateDuplicateCommittee() throws Exception {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("12");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newCorrespondenceTemplates[2].committeeId"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newCorrespondenceTemplates[2].committeeId");
        Assert.assertEquals((Object)"error.correspondence.template.committee.duplicate", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddCorrespondenceTemplateMissingFile() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(1.returnValue((Object)"text/xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(1.returnValue(null));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newCorrespondenceTemplates[2].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newCorrespondenceTemplates[2].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.empty.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddCorrespondenceTemplateEmptyFile() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(2.returnValue((Object)"text/xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(2.returnValue((Object)new byte[0]));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newCorrespondenceTemplates[2].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newCorrespondenceTemplates[2].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.empty.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddCorrespondenceTemplateInvalidFileType() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(3.returnValue((Object)"bad/content-type"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(3.returnValue((Object)new byte[]{1, 2, 3}));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newCorrespondenceTemplates[2].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newCorrespondenceTemplates[2].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.invalid.file.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddCorrespondenceTemplate() throws Exception {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertTrue((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)0L, (long)messageMap.getErrorCount());
    }

    @Test
    public void testReplaceCorrespondenceTemplateMissingFile() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(4.returnValue((Object)"text/xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(4.returnValue(null));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int typeIndex = 2;
        int templateIndex = 3;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processReplaceProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, typeIndex, templateIndex);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("replaceCorrespondenceTemplates[" + typeIndex + "].list[" + templateIndex + "].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("replaceCorrespondenceTemplates[" + typeIndex + "].list[" + templateIndex + "].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.empty.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testReplaceCorrespondenceTemplateEmptyFile() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(5.returnValue((Object)"text/xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(5.returnValue((Object)new byte[0]));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int typeIndex = 2;
        int templateIndex = 3;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processReplaceProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, typeIndex, templateIndex);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("replaceCorrespondenceTemplates[" + typeIndex + "].list[" + templateIndex + "].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("replaceCorrespondenceTemplates[" + typeIndex + "].list[" + templateIndex + "].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.empty.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testReplaceCorrespondenceTemplateInvalidFileType() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(6.returnValue((Object)"bad/content-type"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(6.returnValue((Object)new byte[]{1, 2, 3}));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("12");
        int typeIndex = 2;
        int templateIndex = 3;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processReplaceProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, typeIndex, templateIndex);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("replaceCorrespondenceTemplates[" + typeIndex + "].list[" + templateIndex + "].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("replaceCorrespondenceTemplates[" + typeIndex + "].list[" + templateIndex + "].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.invalid.file.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testReplaceCorrespondenceTemplate() throws Exception {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("12");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processReplaceProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index, index);
        Assert.assertTrue((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)0L, (long)messageMap.getErrorCount());
    }

    @Test
    public void testAddDefaultCorrespondenceTemplateMissingFile() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(7.returnValue((Object)"text/xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(7.returnValue(null));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddDefaultProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newDefaultCorrespondenceTemplates[2].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newDefaultCorrespondenceTemplates[2].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.empty.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddDefaultCorrespondenceTemplateEmptyFile() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(8.returnValue((Object)"text/xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(8.returnValue((Object)new byte[0]));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddDefaultProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newDefaultCorrespondenceTemplates[2].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newDefaultCorrespondenceTemplates[2].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.empty.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddDefaultCorrespondenceTemplateInvalidFileType() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(9.returnValue((Object)"bad/content-type"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(9.returnValue((Object)new byte[]{1, 2, 3}));
            }
        });
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddDefaultProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newDefaultCorrespondenceTemplates[2].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newDefaultCorrespondenceTemplates[2].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.invalid.file.type", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testAddDefaultCorrespondenceTemplate() throws Exception {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"12"});
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = this.getCorrespondenceTemplate("13");
        int index = 2;
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processAddDefaultProtocolCorrespondenceTemplateRules((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate, index);
        Assert.assertTrue((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)0L, (long)messageMap.getErrorCount());
    }

    @Test
    public void testSaveCorrespondenceTemplateMissingCommittee() throws Exception {
        this.simulateValidMockedFileBehavior();
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{null}));
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("correspondenceTypes[0].protocolCorrespondenceTemplates[0].committeeId"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("correspondenceTypes[0].protocolCorrespondenceTemplates[0].committeeId");
        Assert.assertEquals((Object)"error.correspondence.template.committee.not.specified", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveCorrespondenceTemplateBlankCommittee() throws Exception {
        this.simulateValidMockedFileBehavior();
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"", "2"}));
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("correspondenceTypes[0].protocolCorrespondenceTemplates[0].committeeId"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("correspondenceTypes[0].protocolCorrespondenceTemplates[0].committeeId");
        Assert.assertEquals((Object)"error.correspondence.template.committee.not.specified", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveCorrespondenceTemplateDuplicateCommittee() throws Exception {
        this.simulateValidMockedFileBehavior();
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"1", "1"}));
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("correspondenceTypes[0].protocolCorrespondenceTemplates[1].committeeId"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("correspondenceTypes[0].protocolCorrespondenceTemplates[1].committeeId");
        Assert.assertEquals((Object)"error.correspondence.template.committee.duplicate", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveCorrespondenceTemplateMissingFileName() throws Exception {
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"1", "2"}));
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"1"});
        ProtocolCorrespondenceTemplate errorTemplate = this.getCorrespondenceTemplate("2");
        errorTemplate.setFileName("");
        correspondenceType.getProtocolCorrespondenceTemplates().add(errorTemplate);
        protocolCorrespondenceTypes.add(correspondenceType);
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("correspondenceTypes[1].protocolCorrespondenceTemplates[1].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("correspondenceTypes[1].protocolCorrespondenceTemplates[1].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.invalid.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveCorrespondenceTemplateInvalidFile() throws Exception {
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"1", "2"}));
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"1"});
        ProtocolCorrespondenceTemplate errorTemplate = this.getCorrespondenceTemplate("2");
        errorTemplate.setCorrespondenceTemplate(new byte[0]);
        correspondenceType.getProtocolCorrespondenceTemplates().add(errorTemplate);
        protocolCorrespondenceTypes.add(correspondenceType);
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("correspondenceTypes[1].protocolCorrespondenceTemplates[1].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("correspondenceTypes[1].protocolCorrespondenceTemplates[1].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.invalid.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveCorrespondenceTemplateMissingDefaultFileName() throws Exception {
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"1", "2"}));
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"1"});
        ProtocolCorrespondenceTemplate errorTemplate = this.getCorrespondenceTemplate("DEFAULT");
        errorTemplate.setFileName("");
        correspondenceType.getProtocolCorrespondenceTemplates().add(errorTemplate);
        protocolCorrespondenceTypes.add(correspondenceType);
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newDefaultCorrespondenceTemplates[1].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newDefaultCorrespondenceTemplates[1].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.invalid.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveCorrespondenceTemplateInvalidDefaultFile() throws Exception {
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"1", "2"}));
        ProtocolCorrespondenceType correspondenceType = this.getCorrespondenceType(new String[]{"1"});
        ProtocolCorrespondenceTemplate errorTemplate = this.getCorrespondenceTemplate("DEFAULT");
        errorTemplate.setCorrespondenceTemplate(new byte[0]);
        correspondenceType.getProtocolCorrespondenceTemplates().add(errorTemplate);
        protocolCorrespondenceTypes.add(correspondenceType);
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertFalse((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)1L, (long)messageMap.getErrorCount());
        Assert.assertTrue((boolean)messageMap.doesPropertyHaveError("newDefaultCorrespondenceTemplates[1].templateFile"));
        AutoPopulatingList errorMessages = messageMap.getErrorMessagesForProperty("newDefaultCorrespondenceTemplates[1].templateFile");
        Assert.assertEquals((Object)"error.correspondence.template.invalid.file", (Object)((ErrorMessage)errorMessages.get(0)).getErrorKey());
    }

    @Test
    public void testSaveCorrespondenceTemplate() throws Exception {
        ArrayList<ProtocolCorrespondenceType> protocolCorrespondenceTypes = new ArrayList<ProtocolCorrespondenceType>();
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"1", "2"}));
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"1", "3"}));
        protocolCorrespondenceTypes.add(this.getCorrespondenceType(new String[]{"3", "2"}));
        boolean rulePassed = new ProtocolCorrespondenceTemplateRule().processSaveProtocolCorrespondenceTemplateRules(protocolCorrespondenceTypes);
        Assert.assertTrue((boolean)rulePassed);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertEquals((long)0L, (long)messageMap.getErrorCount());
    }

    private ProtocolCorrespondenceType getCorrespondenceType(String[] committeeIds) throws IOException {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType protocolCorrespondenceType = new ProtocolCorrespondenceType();
        for (String committeeId : committeeIds) {
            protocolCorrespondenceType.getProtocolCorrespondenceTemplates().add(this.getCorrespondenceTemplate(committeeId));
        }
        return protocolCorrespondenceType;
    }

    private ProtocolCorrespondenceTemplate getCorrespondenceTemplate(String committeeId) throws IOException {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceTemplate protocolCorrespondenceTemplate = new ProtocolCorrespondenceTemplate(){
            private static final long serialVersionUID = 1L;

            public int compareTo(ProtocolCorrespondenceTemplateBase arg) {
                return this.getCommitteeId().compareTo(arg.getCommitteeId());
            }
        };
        protocolCorrespondenceTemplate.setCommitteeId(committeeId);
        protocolCorrespondenceTemplate.setFileName("test.xml");
        protocolCorrespondenceTemplate.setCorrespondenceTemplate(new byte[]{1, 2, 3});
        protocolCorrespondenceTemplate.setTemplateFile(this.mockedFile);
        return protocolCorrespondenceTemplate;
    }

    private void simulateValidMockedFileBehavior() throws IOException {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getContentType();
                this.will(11.returnValue((Object)"text/xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateRuleTest.this.mockedFile)).getFileData();
                this.will(11.returnValue((Object)new byte[]{1, 2, 3}));
            }
        });
    }
}

