/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.correspondence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.struts.upload.FormFile;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplate;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplateService;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceTemplateServiceImpl;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondenceType;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolCorrespondenceTemplateServiceTest {
    private static final String COMMITTEE_ID = "commid";
    private static final String AGENDA_TYPE = "9";
    private static final String AGENDA_FILE_NAME = "agenda.xml";
    Mockery context = new JUnit4Mockery();
    FormFile mockedFile = null;

    @Before
    public void setUp() throws Exception {
        this.mockedFile = (FormFile)this.context.mock(FormFile.class);
    }

    @After
    public void tearDown() throws Exception {
        this.mockedFile = null;
    }

    @Test
    public void addDefaultProtocolCorrespondenceTemplateTest() throws Exception {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType correspondenceType = new ProtocolCorrespondenceType();
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = new ProtocolCorrespondenceTemplate();
        newCorrespondenceTemplate.setProtoCorrespTypeCode("5");
        newCorrespondenceTemplate.setTemplateFile(this.mockedFile);
        this.getProtocolCorrespondenceTemplateService().addDefaultProtocolCorrespondenceTemplate((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate);
        Assert.assertEquals((Object)newCorrespondenceTemplate.getProtoCorrespTypeCode(), (Object)correspondenceType.getDefaultProtocolCorrespondenceTemplate().getProtoCorrespTypeCode());
        Assert.assertEquals((Object)"DEFAULT", (Object)correspondenceType.getDefaultProtocolCorrespondenceTemplate().getCommitteeId());
        Assert.assertEquals((Object)newCorrespondenceTemplate.getFileName(), (Object)correspondenceType.getDefaultProtocolCorrespondenceTemplate().getFileName());
        Assert.assertTrue((boolean)correspondenceType.getCommitteeProtocolCorrespondenceTemplates().isEmpty());
    }

    @Test
    public void addCommitteeProtocolCorrespondenceTemplateTest() throws Exception {
        this.simulateValidMockedFileBehavior();
        ProtocolCorrespondenceType correspondenceType = new ProtocolCorrespondenceType();
        ProtocolCorrespondenceTemplate newCorrespondenceTemplate = new ProtocolCorrespondenceTemplate();
        newCorrespondenceTemplate.setProtoCorrespTypeCode("5");
        newCorrespondenceTemplate.setCommitteeId("Committee1");
        newCorrespondenceTemplate.setTemplateFile(this.mockedFile);
        this.getProtocolCorrespondenceTemplateService().addCommitteeProtocolCorrespondenceTemplate((ProtocolCorrespondenceTypeBase)correspondenceType, (ProtocolCorrespondenceTemplateBase)newCorrespondenceTemplate);
        Assert.assertEquals((long)1L, (long)correspondenceType.getCommitteeProtocolCorrespondenceTemplates().size());
        Assert.assertEquals((Object)newCorrespondenceTemplate.getProtoCorrespTypeCode(), (Object)((ProtocolCorrespondenceTemplateBase)correspondenceType.getCommitteeProtocolCorrespondenceTemplates().get(0)).getProtoCorrespTypeCode());
        Assert.assertEquals((Object)newCorrespondenceTemplate.getCommitteeId(), (Object)((ProtocolCorrespondenceTemplateBase)correspondenceType.getCommitteeProtocolCorrespondenceTemplates().get(0)).getCommitteeId());
        Assert.assertEquals((Object)newCorrespondenceTemplate.getFileName(), (Object)((ProtocolCorrespondenceTemplateBase)correspondenceType.getCommitteeProtocolCorrespondenceTemplates().get(0)).getFileName());
        Assert.assertTrue((correspondenceType.getDefaultProtocolCorrespondenceTemplate() == null ? 1 : 0) != 0);
    }

    private ProtocolCorrespondenceTemplateService getProtocolCorrespondenceTemplateService() {
        return (ProtocolCorrespondenceTemplateService)KraServiceLocator.getService((String)"protocolCorrespondenceTemplateService");
    }

    private void simulateValidMockedFileBehavior() throws IOException {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateServiceTest.this.mockedFile)).getFileName();
                this.will(1.returnValue((Object)"template.xml"));
                ((FormFile)this.allowing(ProtocolCorrespondenceTemplateServiceTest.this.mockedFile)).getFileData();
                this.will(1.returnValue((Object)new byte[]{1, 2, 3}));
            }
        });
    }

    private ProtocolCorrespondenceType createCorrespondenceType() {
        ProtocolCorrespondenceType correspondenceType = new ProtocolCorrespondenceType();
        ProtocolCorrespondenceTemplate correspondenceTemplate = new ProtocolCorrespondenceTemplate(){

            public int compareTo(ProtocolCorrespondenceTemplateBase arg) {
                return this.getCommitteeId().compareTo(arg.getCommitteeId());
            }
        };
        correspondenceTemplate.setProtoCorrespTypeCode("5");
        correspondenceTemplate.setCommitteeId("DEFAULT");
        correspondenceTemplate.setFileName("defaultTemplate.xml");
        correspondenceType.getProtocolCorrespondenceTemplates().add(correspondenceTemplate);
        correspondenceTemplate = new ProtocolCorrespondenceTemplate(){

            public int compareTo(ProtocolCorrespondenceTemplateBase arg) {
                return this.getCommitteeId().compareTo(arg.getCommitteeId());
            }
        };
        correspondenceTemplate.setProtoCorrespTypeCode("5");
        correspondenceTemplate.setCommitteeId("Committee1");
        correspondenceTemplate.setFileName("committee1Template.xml");
        correspondenceType.getProtocolCorrespondenceTemplates().add(correspondenceTemplate);
        correspondenceTemplate = new ProtocolCorrespondenceTemplate(){

            public int compareTo(ProtocolCorrespondenceTemplateBase arg) {
                return this.getCommitteeId().compareTo(arg.getCommitteeId());
            }
        };
        correspondenceTemplate.setProtoCorrespTypeCode("5");
        correspondenceTemplate.setCommitteeId("Committee2");
        correspondenceTemplate.setFileName("committee2Template.xml");
        correspondenceType.getProtocolCorrespondenceTemplates().add(correspondenceTemplate);
        return correspondenceType;
    }

    @Test
    public void testGetProtocolCorrespondenceTemplate() throws Exception {
        ProtocolCorrespondenceTemplateServiceImpl templateService = new ProtocolCorrespondenceTemplateServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolCorrespondenceTemplate template = new ProtocolCorrespondenceTemplate();
        template.setCommitteeId(COMMITTEE_ID);
        template.setProtoCorrespTypeCode(AGENDA_TYPE);
        template.setFileName(AGENDA_FILE_NAME);
        final ArrayList<ProtocolCorrespondenceTemplate> templates = new ArrayList<ProtocolCorrespondenceTemplate>();
        templates.add(template);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("committeeId", ProtocolCorrespondenceTemplateServiceTest.COMMITTEE_ID);
                fieldValues.put("protoCorrespTypeCode", ProtocolCorrespondenceTemplateServiceTest.AGENDA_TYPE);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolCorrespondenceTemplate.class, fieldValues);
                this.will(5.returnValue((Object)templates));
            }
        });
        templateService.setBusinessObjectService(businessObjectService);
        ProtocolCorrespondenceTemplate protocolTemplate = (ProtocolCorrespondenceTemplate)templateService.getProtocolCorrespondenceTemplate(COMMITTEE_ID, AGENDA_TYPE);
        Assert.assertEquals((Object)protocolTemplate.getCommitteeId(), (Object)COMMITTEE_ID);
        Assert.assertEquals((Object)protocolTemplate.getProtoCorrespTypeCode(), (Object)AGENDA_TYPE);
        Assert.assertEquals((Object)protocolTemplate.getFileName(), (Object)AGENDA_FILE_NAME);
    }
}

