/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.noteattachment;

import java.util.ArrayList;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentBaseRuleHelper;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentType;
import org.kuali.kra.irb.test.ProtocolTestUtil;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProtocolAttachmentBaseRuleHelperTest {
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setupGlobalVars() {
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Test
    public void validDescriptionEmpty() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("3", "a desc"));
        boolean valid = helper.validDescriptionWhenRequired((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)true));
    }

    @Test
    public void validDescriptionNotEmpty() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("3", "a desc"));
        attachment.setDescription("a desc");
        boolean valid = helper.validDescriptionWhenRequired((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)true));
    }

    @Test
    public void invalidDescription() {
        final ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("9", "a desc"));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ProtocolAttachmentType type = new ProtocolAttachmentType();
                type.setCode("9");
                type.setDescription("not Other");
                ((ProtocolAttachmentService)this.one(paService)).getTypeFromCode("9");
                this.will(1.returnValue((Object)type));
            }
        });
        boolean valid = helper.validDescriptionWhenRequired((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be not valid", (Object)valid, (Matcher)Is.is((Object)false));
    }

    @Test
    public void validAttachmentAttachmentProtocolDD() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        final DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        helper.resetPropertyPrefix("fooPrefix");
        final ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("9", "a desc"));
        attachment.setSequenceNumber(Integer.valueOf(1));
        attachment.setDocumentId(Integer.valueOf(1));
        Protocol protocol = ProtocolTestUtil.getProtocol(this.context);
        protocol.setProtocolId(Long.valueOf(1L));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DictionaryValidationService)this.one(ddService)).isBusinessObjectValid((BusinessObject)attachment, "fooPrefix");
                this.will(2.returnValue((Object)true));
            }
        });
        boolean valid = helper.validPrimitiveFields((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)true));
    }

    @Test
    public void validTypeForGroupBlankCode() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        helper.resetPropertyPrefix("fooPrefix");
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType(null, "a desc"));
        boolean valid = helper.validTypeForGroup((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)true));
    }

    @Test
    public void validTypeForGroupTypeFound() {
        final ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        helper.resetPropertyPrefix("fooPrefix");
        final ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("9", "a desc"));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ArrayList<ProtocolAttachmentType> types = new ArrayList<ProtocolAttachmentType>();
                ProtocolAttachmentType aType = new ProtocolAttachmentType();
                aType.setCode("9");
                types.add(aType);
                ((ProtocolAttachmentService)this.one(paService)).getTypesForGroup(attachment.getGroupCode());
                this.will(3.returnValue(types));
            }
        });
        boolean valid = helper.validTypeForGroup((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)true));
    }

    @Test
    public void invalidTypeForGroupTypeFound() {
        final ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        helper.resetPropertyPrefix("fooPrefix");
        final ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("9", "a desc"));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ArrayList<ProtocolAttachmentType> types = new ArrayList<ProtocolAttachmentType>();
                ProtocolAttachmentType aType = new ProtocolAttachmentType();
                aType.setCode("12");
                types.add(aType);
                ((ProtocolAttachmentService)this.one(paService)).getTypesForGroup(attachment.getGroupCode());
                this.will(4.returnValue(types));
                ProtocolAttachmentType aType2 = new ProtocolAttachmentType();
                aType2.setCode("9");
                aType2.setDescription("a desc");
                ((ProtocolAttachmentService)this.one(paService)).getTypeFromCode("9");
                this.will(4.returnValue((Object)aType2));
            }
        });
        boolean valid = helper.validTypeForGroup((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)false));
    }

    @Test
    public void invalidTypeForGroupTypeNotFound() {
        final ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        helper.resetPropertyPrefix("fooPrefix");
        final ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("9", "a desc"));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ArrayList<ProtocolAttachmentType> types = new ArrayList<ProtocolAttachmentType>();
                ProtocolAttachmentType aType = new ProtocolAttachmentType();
                aType.setCode("12");
                types.add(aType);
                ((ProtocolAttachmentService)this.one(paService)).getTypesForGroup(attachment.getGroupCode());
                this.will(5.returnValue(types));
                ((ProtocolAttachmentService)this.one(paService)).getTypeFromCode("9");
                this.will(5.returnValue(null));
            }
        });
        boolean valid = helper.validTypeForGroup((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)false));
    }

    @Test
    public void invalidAttachmentDD() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        final DictionaryValidationService ddService = (DictionaryValidationService)this.context.mock(DictionaryValidationService.class);
        ProtocolAttachmentBaseRuleHelper helper = new ProtocolAttachmentBaseRuleHelper((org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService)paService, ddService);
        helper.resetPropertyPrefix("fooPrefix");
        final ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("9", "a desc"));
        attachment.setSequenceNumber(Integer.valueOf(1));
        attachment.setDocumentId(Integer.valueOf(1));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DictionaryValidationService)this.one(ddService)).isBusinessObjectValid((BusinessObject)attachment, "fooPrefix");
                this.will(6.returnValue((Object)false));
            }
        });
        boolean valid = helper.validPrimitiveFields((ProtocolAttachmentBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should not be valid", (Object)valid, (Matcher)Is.is((Object)false));
    }
}

