/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.noteattachment;

import java.io.IOException;
import org.apache.struts.upload.FormFile;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.bo.AttachmentFile;

public class ProtocolAttachmentFileTest {
    Mockery context = new JUnit4Mockery();

    @Test
    public void createFromFormFileBasic() throws Exception {
        String fileName = "fileName";
        String fileType = "fileType";
        byte[] data = new byte[]{1};
        FormFile formFile = this.createMockFormFileWithExpectations("fileName", "fileType", data);
        AttachmentFile file = AttachmentFile.createFromFormFile((FormFile)formFile);
        this.context.assertIsSatisfied();
        Assert.assertThat((Object)file.getName(), (Matcher)Is.is((Object)"fileName"));
        Assert.assertThat((Object)file.getType(), (Matcher)Is.is((Object)"fileType"));
        Assert.assertThat((Object)file.getData(), (Matcher)Is.is((Object)data));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createFromFormFileNullFormFile() {
        AttachmentFile.createFromFormFile(null);
    }

    @Test
    public void createFromFormFileLongName() throws Exception {
        String fileName = "fileNamethrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exception";
        String fileType = "fileType";
        byte[] data = new byte[]{1};
        FormFile formFile = this.createMockFormFileWithExpectations("fileNamethrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exception", "fileType", data);
        AttachmentFile file = AttachmentFile.createFromFormFile((FormFile)formFile);
        this.context.assertIsSatisfied();
        Assert.assertThat((Object)file.getName(), (Matcher)Is.is((Object)"fileNamethrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exception".substring("fileNamethrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exceptionthrows Exception".length() - 150)));
        Assert.assertThat((Object)file.getType(), (Matcher)Is.is((Object)"fileType"));
        Assert.assertThat((Object)file.getData(), (Matcher)Is.is((Object)data));
    }

    @Test
    public void createFromFormFileLongType() throws Exception {
        String fileName = "fileName";
        String fileType = "fileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileType";
        byte[] data = new byte[]{1};
        FormFile formFile = this.createMockFormFileWithExpectations("fileName", "fileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileType", data);
        AttachmentFile file = AttachmentFile.createFromFormFile((FormFile)formFile);
        this.context.assertIsSatisfied();
        Assert.assertThat((Object)file.getName(), (Matcher)Is.is((Object)"fileName"));
        Assert.assertThat((Object)file.getType(), (Matcher)Is.is((Object)"fileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileType".substring("fileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileTypefileType".length() - 250)));
        Assert.assertThat((Object)file.getData(), (Matcher)Is.is((Object)data));
    }

    @Test(expected=AttachmentFile.CreateException.class)
    public void testCreateException() throws Exception {
        final FormFile formFile = (FormFile)this.context.mock(FormFile.class);
        String fileName = "fileName";
        String fileType = "fileType";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.one(formFile)).getFileName();
                this.will(1.returnValue((Object)"fileName"));
                ((FormFile)this.one(formFile)).getContentType();
                this.will(1.returnValue((Object)"fileType"));
                ((FormFile)this.one(formFile)).getFileData();
                this.will(1.throwException((Throwable)new IOException()));
            }
        });
        AttachmentFile.createFromFormFile((FormFile)formFile);
        this.context.assertIsSatisfied();
    }

    private FormFile createMockFormFileWithExpectations(final String fileName, final String type, final byte[] data) throws IOException {
        final FormFile formFile = (FormFile)this.context.mock(FormFile.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FormFile)this.one(formFile)).getFileName();
                this.will(2.returnValue((Object)fileName));
                ((FormFile)this.one(formFile)).getContentType();
                this.will(2.returnValue((Object)type));
                ((FormFile)this.one(formFile)).getFileData();
                this.will(2.returnValue((Object)data));
            }
        });
        return formFile;
    }
}

