/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.noteattachment;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocolRuleHelper;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentStatus;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentType;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentStatusBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProtocolAttachmentProtocolRuleHelperTest {
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setupGlobalVars() {
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Test
    public void validStatusBlankCode() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        ProtocolAttachmentProtocolRuleHelper helper = new ProtocolAttachmentProtocolRuleHelper(paService);
        helper.resetPropertyPrefix("fooPrefix");
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setStatus(null);
        boolean valid = helper.validStatus((ProtocolAttachmentProtocolBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)true));
    }

    @Test
    public void validStatus() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        ProtocolAttachmentProtocolRuleHelper helper = new ProtocolAttachmentProtocolRuleHelper(paService);
        helper.resetPropertyPrefix("fooPrefix");
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setStatus((ProtocolAttachmentStatusBase)new ProtocolAttachmentStatus("1", "a desc"));
        this.context.checking((ExpectationBuilder)new Expectations(){});
        boolean valid = helper.validStatus((ProtocolAttachmentProtocolBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be valid", (Object)valid, (Matcher)Is.is((Object)true));
    }

    @Test
    public void invalidStatusValidCodeForSubmissionNull() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        ProtocolAttachmentProtocolRuleHelper helper = new ProtocolAttachmentProtocolRuleHelper(paService);
        helper.resetPropertyPrefix("fooPrefix");
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setStatus(null);
        boolean valid = helper.validStatusForSubmission((ProtocolAttachmentProtocolBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should not be valid", (Object)valid, (Matcher)Is.is((Object)false));
    }

    @Test
    public void invalidStatusValidCodeForSubmissionValidCode() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        ProtocolAttachmentProtocolRuleHelper helper = new ProtocolAttachmentProtocolRuleHelper(paService);
        helper.resetPropertyPrefix("fooPrefix");
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setStatus((ProtocolAttachmentStatusBase)new ProtocolAttachmentStatus("1", "a desc"));
        boolean valid = helper.validStatusForSubmission((ProtocolAttachmentProtocolBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should not be valid", (Object)valid, (Matcher)Is.is((Object)false));
    }

    @Test
    public void validStatusValidCodeForSubmission() {
        ProtocolAttachmentService paService = (ProtocolAttachmentService)this.context.mock(ProtocolAttachmentService.class);
        ProtocolAttachmentProtocolRuleHelper helper = new ProtocolAttachmentProtocolRuleHelper(paService);
        helper.resetPropertyPrefix("fooPrefix");
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setStatus((ProtocolAttachmentStatusBase)new ProtocolAttachmentStatus("9", "a desc"));
        boolean valid = helper.validStatusForSubmission((ProtocolAttachmentProtocolBase)attachment);
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should not be valid", (Object)valid, (Matcher)Is.is((Object)false));
    }

    private ProtocolAttachmentProtocol getAttachmentToValidate() {
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        attachment.setId(Long.valueOf(1L));
        attachment.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("1", "a desc"));
        return attachment;
    }
}

